/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPoolingDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds = null;
    private GenericObjectPool<PoolableConnection> pool = null;

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("user", "username");
        props.setProperty("password", "password");
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", props), null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new PoolingDataSource(this.pool);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.ds.close();
        super.tearDown();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsReflexive() throws Exception {
        Connection con;
        Connection con2 = con = this.ds.getConnection();
        Assert.assertTrue((boolean)con2.equals(con));
        Assert.assertTrue((boolean)con.equals(con2));
        con.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsFail() throws Exception {
        Connection con1 = this.ds.getConnection();
        Connection con2 = this.ds.getConnection();
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
        con2.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsNull() throws Exception {
        Connection con1 = this.ds.getConnection();
        Object con2 = null;
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsType() throws Exception {
        Connection con1 = this.ds.getConnection();
        Integer con2 = 0;
        Assert.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection con = (DelegatingConnection)this.ds.getConnection();
        Connection inner = con.getInnermostDelegate();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        DelegatingConnection con2 = new DelegatingConnection(inner);
        Assert.assertFalse((boolean)con2.equals(con));
        Assert.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
        Assert.assertTrue((boolean)con2.innermostDelegateEquals(inner));
        Assert.assertFalse((boolean)con.equals(con2));
    }

    @Test
    public void testFixFactoryConfig() throws Exception {
        Properties props = new Properties();
        props.setProperty("user", "username");
        props.setProperty("password", "password");
        PoolableConnectionFactory f = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", props), null);
        f.setValidationQuery("SELECT DUMMY FROM DUAL");
        f.setDefaultReadOnly(Boolean.TRUE);
        f.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool p = new GenericObjectPool((PooledObjectFactory)f);
        p.setMaxTotal(this.getMaxTotal());
        p.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new PoolingDataSource((ObjectPool)p);
        Assert.assertTrue((boolean)f.getPool().equals(p));
        this.ds.getConnection();
    }

    @Test
    public void testClose() throws Exception {
        Properties props = new Properties();
        props.setProperty("user", "username");
        props.setProperty("password", "password");
        PoolableConnectionFactory f = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", props), null);
        f.setValidationQuery("SELECT DUMMY FROM DUAL");
        f.setDefaultReadOnly(Boolean.TRUE);
        f.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool p = new GenericObjectPool((PooledObjectFactory)f);
        p.setMaxTotal(this.getMaxTotal());
        p.setMaxWaitMillis(this.getMaxWaitMillis());
        try (PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)p);){
            Connection connection = dataSource.getConnection();
            Assert.assertNotNull((Object)connection);
            connection.close();
        }
        Assert.assertTrue((boolean)p.isClosed());
        Assert.assertEquals((long)0L, (long)p.getNumIdle());
        Assert.assertEquals((long)0L, (long)p.getNumActive());
    }
}

