/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPerUserPoolDataSource
extends TestConnectionPool {
    private DataSource ds;

    @Override
    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection("foo", "bar");
    }

    @Before
    public void setUp() throws Exception {
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser("foo");
        pcds.setPassword("bar");
        pcds.setAccessToUnderlyingConnectionAllowed(true);
        PerUserPoolDataSource tds = new PerUserPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        tds.setDefaultMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setPerUserMaxTotal("foo", Integer.valueOf(this.getMaxTotal()));
        tds.setPerUserMaxWaitMillis("foo", Long.valueOf(this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        Throwable throwable;
        Connection c2;
        block57: {
            try {
                c2 = this.ds.getConnection("u1", "zlsafjk");
                throwable = null;
                try {
                    Assert.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (c2 != null) {
                        if (throwable != null) {
                            try {
                                c2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            c2.close();
                        }
                    }
                }
            }
            catch (SQLException c2) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                c2 = this.ds.getConnection("u1", "x");
                throwable = null;
                try {
                    Assert.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (c2 != null) {
                        if (throwable != null) {
                            try {
                                c2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            c2.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block57;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection("foo", "bar").close();
        try {
            c2 = this.ds.getConnection("foob", "ar");
            throwable = null;
            try {
                Assert.fail((String)"Should have caused an SQLException");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (c2 != null) {
                    if (throwable != null) {
                        try {
                            c2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        c2.close();
                    }
                }
            }
        }
        catch (SQLException c3) {
            // empty catch block
        }
        try {
            c2 = this.ds.getConnection("foo", "baz");
            throwable = null;
            try {
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (c2 != null) {
                    if (throwable != null) {
                        try {
                            c2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        c2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try (Statement s = conn.createStatement();){
            Assert.fail((String)"Can't use closed connections");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assert.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
            for (int j = 0; j <= i; ++j) {
                Assert.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assert.assertTrue((c[i] != null ? 1 : 0) != 0);
        }
        try (Connection conn = this.ds.getConnection();){
            Assert.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testMaxWaitMillisZero() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setDefaultMaxWaitMillis(0L);
        tds.setPerUserMaxTotal("u1", Integer.valueOf(1));
        Connection conn = tds.getConnection("u1", "p1");
        try (Connection c2 = tds.getConnection("u1", "p1");){
            Assert.fail((String)"Expecting Pool Exhausted exception");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.close();
    }

    @Test
    public void testPerUserMethods() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setPerUserMaxTotal("u1", Integer.valueOf(5));
        tds.setPerUserMaxTotal("u2", Integer.valueOf(5));
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u2"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u2"));
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        int defaultMaxWaitMillis = 430;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(430L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(430L));
        this.multipleThreads(1, false, false, 430L);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        int defaultMaxWaitMillis = 500;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(500L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(500L));
        this.multipleThreads(1000, true, true, 500L);
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)2L, (long)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assert.assertEquals((long)2L, (long)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testSerialization() throws Exception {
        Connection conn = this.ds.getConnection();
        conn.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.ds);
        byte[] b = baos.toByteArray();
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object obj = in.readObject();
        in.close();
        Assert.assertEquals((long)1L, (long)((PerUserPoolDataSource)obj).getNumIdle());
    }

    @Test
    public void testUnregisteredUser() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        Connection conn = tds.getConnection();
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)1L, (long)tds.getNumActive());
        Assert.assertEquals((long)0L, (long)tds.getNumIdle());
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        conn = tds.getConnection("u1", "p1");
        Assert.assertNotNull((Object)conn);
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)1L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)0L, (long)tds.getNumIdle("u1"));
        conn.close();
        Assert.assertEquals((long)0L, (long)tds.getNumActive());
        Assert.assertEquals((long)1L, (long)tds.getNumIdle());
        Assert.assertEquals((long)0L, (long)tds.getNumActive("u1"));
        Assert.assertEquals((long)1L, (long)tds.getNumIdle("u1"));
    }

    @Test
    public void testDefaultUser1() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"mkh", "hanafey", "jsmith"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], password);
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    @Test
    public void testDefaultUser2() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"jsmith", "hanafey", "mkh"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], password);
            Assert.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangePassword() throws Exception {
        try (Connection c2 = this.ds.getConnection("foo", "bay");){
            Assert.fail((String)"Should have generated SQLException");
        }
        catch (SQLException c2) {
            // empty catch block
        }
        Connection con1 = this.ds.getConnection("foo", "bar");
        Connection con2 = this.ds.getConnection("foo", "bar");
        Connection con3 = this.ds.getConnection("foo", "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser("foo", "bay");
        try {
            Connection con4 = this.ds.getConnection("foo", "bay");
            Assert.assertEquals((String)"Should be no idle connections in the pool", (long)0L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con4.close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            try (Connection c3 = this.ds.getConnection("foo", "bar");){
                Assert.fail((String)"Should have generated SQLException");
            }
            catch (SQLException c3) {
                // empty catch block
            }
            Connection con5 = this.ds.getConnection("foo", "bay");
            con3.close();
            this.ds.getConnection("foo", "bay").close();
            Assert.assertEquals((String)"Should be one idle connection in the pool", (long)1L, (long)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con5.close();
        }
        finally {
            TesterDriver.addUser("foo", "bar");
        }
    }
}

