/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDriverAdapterCPDS {
    private DriverAdapterCPDS pcds;

    @Before
    public void setUp() throws Exception {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        this.pcds.setUrl("jdbc:apache:commons:testdriver");
        this.pcds.setUser("foo");
        this.pcds.setPassword("bar");
        this.pcds.setPoolPreparedStatements(false);
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        block4: {
            this.pcds.getPooledConnection("u2", "p2").close();
            try {
                this.pcds.getPooledConnection("u1", "zlsafjk");
                Assert.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.pcds.getPooledConnection("u1", "p1").close();
            try {
                this.pcds.getPooledConnection("u1", "x");
                Assert.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("x is not the correct password")) break block4;
                throw e;
            }
        }
        this.pcds.getPooledConnection("u1", "p1").close();
    }

    @Test
    public void testSimple() throws Exception {
        Connection conn = this.pcds.getPooledConnection().getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.pcds.getPooledConnection("u1", "p1").getConnection();
        Assert.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assert.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assert.assertNotNull((Object)rset);
        Assert.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[10];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        c[0].close();
        Assert.assertTrue((boolean)c[0].isClosed());
        c[0] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.pcds.getPooledConnection("u1", "p1").getConnection();
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testSetProperties() throws Exception {
        this.pcds.setUser("bad");
        Properties properties = new Properties();
        properties.put("user", "foo");
        this.pcds.setConnectionProperties(properties);
        this.pcds.getPooledConnection().close();
        Assert.assertEquals((Object)"foo", (Object)this.pcds.getUser());
        properties.put("password", "bad");
        Assert.assertEquals((Object)"bar", (Object)this.pcds.getPassword());
        this.pcds.getPooledConnection("foo", "bar").close();
        Assert.assertEquals((Object)"bar", (Object)this.pcds.getConnectionProperties().getProperty("password"));
    }

    @Test
    public void testNullValidationQuery() throws Exception {
        SharedPoolDataSource spds = new SharedPoolDataSource();
        spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        spds.setDefaultTestOnBorrow(true);
        Connection c = spds.getConnection();
        c.close();
        spds.close();
    }

    @Test
    public void testDbcp367() throws Exception {
        int i;
        ThreadDbcp367[] threads = new ThreadDbcp367[200];
        this.pcds.setPoolPreparedStatements(true);
        this.pcds.setMaxPreparedStatements(-1);
        this.pcds.setAccessToUnderlyingConnectionAllowed(true);
        SharedPoolDataSource spds = new SharedPoolDataSource();
        spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        spds.setMaxTotal(threads.length + 10);
        spds.setDefaultMaxWaitMillis(-1L);
        spds.setDefaultMaxIdle(10);
        spds.setDefaultAutoCommit(Boolean.FALSE);
        spds.setValidationQuery("SELECT 1");
        spds.setDefaultTimeBetweenEvictionRunsMillis(10000L);
        spds.setDefaultNumTestsPerEvictionRun(-1);
        spds.setDefaultTestWhileIdle(true);
        spds.setDefaultTestOnBorrow(true);
        spds.setDefaultTestOnReturn(false);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new ThreadDbcp367((DataSource)spds);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
            Assert.assertFalse((String)("Thread " + i + " has failed"), (boolean)threads[i].isFailed());
        }
    }

    private static class ThreadDbcp367
    extends Thread {
        private final DataSource ds;
        private volatile boolean failed = false;

        public ThreadDbcp367(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            Connection c = null;
            try {
                for (int j = 0; j < 5000; ++j) {
                    c = this.ds.getConnection();
                    c.close();
                }
            }
            catch (SQLException sqle) {
                this.failed = true;
                sqle.printStackTrace();
            }
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

