/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterResultSet;

public class TesterStatement
implements Statement {
    protected Connection _connection = null;
    protected boolean _open = true;
    protected int _rowsUpdated = 1;
    protected boolean _executeResponse = true;
    protected int _maxFieldSize = 1024;
    protected int _maxRows = 1024;
    protected boolean _escapeProcessing = false;
    protected int _queryTimeout = 1000;
    protected String _cursorName = null;
    protected int _fetchDirection = 1;
    protected int _fetchSize = 1;
    protected int _resultSetConcurrency = 1;
    protected int _resultSetType = 1;
    protected ResultSet _resultSet = null;

    public TesterStatement(Connection conn) {
        this._connection = conn;
    }

    public TesterStatement(Connection conn, int resultSetType, int resultSetConcurrency) {
        this._connection = conn;
        this._resultSetType = resultSetType;
        this._resultSetConcurrency = resultSetConcurrency;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if ("null".equals(sql)) {
            return null;
        }
        if ("invalid".equals(sql)) {
            throw new SQLException("invalid query");
        }
        if ("broken".equals(sql)) {
            throw new SQLException("broken connection");
        }
        if ("select username".equals(sql)) {
            String username = ((TesterConnection)this._connection).getUsername();
            Object[][] data = new Object[][]{{username}};
            return new TesterResultSet(this, data);
        }
        if (this._queryTimeout > 0 && this._queryTimeout < 5) {
            throw new SQLException("query timeout");
        }
        return new TesterResultSet(this);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        return this._rowsUpdated;
    }

    @Override
    public void close() throws SQLException {
        if (!this._open) {
            return;
        }
        this._open = false;
        if (this._resultSet != null) {
            this._resultSet.close();
            this._resultSet = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        this._maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this._maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
        this._escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        this._queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
        this._cursorName = name;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if ("invalid".equals(sql)) {
            throw new SQLException("invalid query");
        }
        return this._executeResponse;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        if (this._resultSet == null) {
            this._resultSet = new TesterResultSet(this);
        }
        return this._resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._rowsUpdated;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this._fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this._fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._connection;
    }

    protected void checkOpen() throws SQLException {
        if (!this._open) {
            throw new SQLException("Connection is closed.");
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new TesterResultSet(this);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this._open;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not implemented.");
    }
}

