/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestDriverManagerConnectionFactory {
    @Test
    public void testDriverManagerInit() throws Exception {
        int i;
        System.setProperty("jdbc.drivers", "org.apache.commons.dbcp2.TesterDriver");
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(10);
        config.setMaxIdle(0);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "foo", "bar");
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultReadOnly(Boolean.FALSE);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, config);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        ConnectionThread[] connectionThreads = new ConnectionThread[10];
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            connectionThreads[i] = new ConnectionThread((DataSource)dataSource);
            threads[i] = new Thread(connectionThreads[i]);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            while (threads[i].isAlive()) {
                Thread.sleep(100L);
            }
            if (connectionThreads[i].getResult()) continue;
            Assert.fail((String)"Exception during getConnection");
        }
    }

    private static final class ConnectionThread
    implements Runnable {
        private final DataSource ds;
        private volatile boolean result = true;

        private ConnectionThread(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            Connection conn = null;
            try {
                conn = this.ds.getConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.result = false;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.result = false;
                    }
                }
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

