/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.List;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.StackMessageLog;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicDataSourceFactory {
    @Test
    public void testNoProperties() throws Exception {
        Properties properties = new Properties();
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void testProperties() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", "org.apache.commons.dbcp2.TesterDriver");
        properties.setProperty("url", "jdbc:apache:commons:testdriver");
        properties.setProperty("maxTotal", "10");
        properties.setProperty("maxIdle", "8");
        properties.setProperty("minIdle", "0");
        properties.setProperty("maxWaitMillis", "500");
        properties.setProperty("initialSize", "5");
        properties.setProperty("defaultAutoCommit", "true");
        properties.setProperty("defaultReadOnly", "false");
        properties.setProperty("defaultTransactionIsolation", "READ_COMMITTED");
        properties.setProperty("defaultCatalog", "test");
        properties.setProperty("testOnBorrow", "true");
        properties.setProperty("testOnReturn", "false");
        properties.setProperty("username", "username");
        properties.setProperty("password", "password");
        properties.setProperty("validationQuery", "SELECT DUMMY FROM DUAL");
        properties.setProperty("validationQueryTimeout", "100");
        properties.setProperty("connectionInitSqls", "SELECT 1;SELECT 2");
        properties.setProperty("timeBetweenEvictionRunsMillis", "1000");
        properties.setProperty("minEvictableIdleTimeMillis", "2000");
        properties.setProperty("softMinEvictableIdleTimeMillis", "3000");
        properties.setProperty("numTestsPerEvictionRun", "2");
        properties.setProperty("testWhileIdle", "true");
        properties.setProperty("accessToUnderlyingConnectionAllowed", "true");
        properties.setProperty("removeAbandoned", "true");
        properties.setProperty("removeAbandonedTimeout", "3000");
        properties.setProperty("logAbandoned", "true");
        properties.setProperty("abandonedUsageTracking", "true");
        properties.setProperty("poolPreparedStatements", "true");
        properties.setProperty("maxOpenPreparedStatements", "10");
        properties.setProperty("lifo", "true");
        properties.setProperty("fastFailValidation", "true");
        properties.setProperty("disconnectionSqlCodes", "XXX,YYY");
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        Assert.assertEquals((Object)"org.apache.commons.dbcp2.TesterDriver", (Object)ds.getDriverClassName());
        Assert.assertEquals((Object)"jdbc:apache:commons:testdriver", (Object)ds.getUrl());
        Assert.assertEquals((long)10L, (long)ds.getMaxTotal());
        Assert.assertEquals((long)8L, (long)ds.getMaxIdle());
        Assert.assertEquals((long)0L, (long)ds.getMinIdle());
        Assert.assertEquals((long)500L, (long)ds.getMaxWaitMillis());
        Assert.assertEquals((long)5L, (long)ds.getInitialSize());
        Assert.assertEquals((long)5L, (long)ds.getNumIdle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ds.getDefaultAutoCommit());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ds.getDefaultReadOnly());
        Assert.assertEquals((long)2L, (long)ds.getDefaultTransactionIsolation());
        Assert.assertEquals((Object)"test", (Object)ds.getDefaultCatalog());
        Assert.assertEquals((Object)true, (Object)ds.getTestOnBorrow());
        Assert.assertEquals((Object)false, (Object)ds.getTestOnReturn());
        Assert.assertEquals((Object)"username", (Object)ds.getUsername());
        Assert.assertEquals((Object)"password", (Object)ds.getPassword());
        Assert.assertEquals((Object)"SELECT DUMMY FROM DUAL", (Object)ds.getValidationQuery());
        Assert.assertEquals((long)100L, (long)ds.getValidationQueryTimeout());
        Assert.assertEquals((long)2L, (long)ds.getConnectionInitSqls().size());
        Assert.assertEquals((Object)"SELECT 1", ds.getConnectionInitSqls().get(0));
        Assert.assertEquals((Object)"SELECT 2", ds.getConnectionInitSqls().get(1));
        Assert.assertEquals((long)1000L, (long)ds.getTimeBetweenEvictionRunsMillis());
        Assert.assertEquals((long)2000L, (long)ds.getMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)3000L, (long)ds.getSoftMinEvictableIdleTimeMillis());
        Assert.assertEquals((long)2L, (long)ds.getNumTestsPerEvictionRun());
        Assert.assertEquals((Object)true, (Object)ds.getTestWhileIdle());
        Assert.assertEquals((Object)true, (Object)ds.isAccessToUnderlyingConnectionAllowed());
        Assert.assertEquals((Object)false, (Object)ds.getRemoveAbandonedOnBorrow());
        Assert.assertEquals((Object)false, (Object)ds.getRemoveAbandonedOnMaintenance());
        Assert.assertEquals((long)3000L, (long)ds.getRemoveAbandonedTimeout());
        Assert.assertEquals((Object)true, (Object)ds.getLogAbandoned());
        Assert.assertEquals((Object)true, (Object)ds.getAbandonedUsageTracking());
        Assert.assertEquals((Object)true, (Object)ds.isPoolPreparedStatements());
        Assert.assertEquals((long)10L, (long)ds.getMaxOpenPreparedStatements());
        Assert.assertEquals((Object)true, (Object)ds.getLifo());
        Assert.assertEquals((Object)true, (Object)ds.getFastFailValidation());
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("XXX"));
        Assert.assertTrue((boolean)ds.getDisconnectionSqlCodes().contains("YYY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateProperties() throws Exception {
        try {
            StackMessageLog.lock();
            Reference ref = new Reference("javax.sql.DataSource", BasicDataSourceFactory.class.getName(), null);
            ref.add(new StringRefAddr("foo", "bar"));
            ref.add(new StringRefAddr("maxWait", "100"));
            ref.add(new StringRefAddr("driverClassName", "org.apache.commons.dbcp2.TesterDriver"));
            BasicDataSourceFactory basicDataSourceFactory = new BasicDataSourceFactory();
            basicDataSourceFactory.getObjectInstance((Object)ref, null, null, null);
            List<String> messages = StackMessageLog.getAll();
            Assert.assertEquals((long)2L, (long)messages.size());
            for (String message : messages) {
                if (message.contains("maxWait")) {
                    Assert.assertTrue((boolean)message.contains("use maxWaitMillis"));
                    continue;
                }
                Assert.assertTrue((boolean)message.contains("foo"));
                Assert.assertTrue((boolean)message.contains("Ignoring unknown property"));
            }
        }
        finally {
            StackMessageLog.clear();
            StackMessageLog.unLock();
        }
    }
}

