/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;
import org.apache.commons.dbcp2.managed.TesterBasicXAConnection;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

public class TestDataSourceXAConnectionFactory
extends TestBasicDataSource {
    protected BasicManagedDataSource bmds;
    public AtomicInteger closeCounter = new AtomicInteger();

    public TestDataSourceXAConnectionFactory(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.bmds = new BasicManagedDataSource();
        this.bmds.setTransactionManager((TransactionManager)new TransactionManagerImpl());
        this.bmds.setXADataSource("notnull");
        XADataSourceHandle handle = new XADataSourceHandle();
        XADataSource xads = (XADataSource)Proxy.newProxyInstance(XADataSourceHandle.class.getClassLoader(), new Class[]{XADataSource.class}, (InvocationHandler)handle);
        this.bmds.setXaDataSourceInstance(xads);
    }

    public void testPhysicalClose() throws Exception {
        this.bmds.setMaxIdle(1);
        Connection conn1 = this.bmds.getConnection();
        Connection conn2 = this.bmds.getConnection();
        this.closeCounter.set(0);
        conn1.close();
        TestDataSourceXAConnectionFactory.assertEquals((int)0, (int)this.closeCounter.get());
        conn2.close();
        TestDataSourceXAConnectionFactory.assertEquals((int)1, (int)this.closeCounter.get());
        this.bmds.close();
        TestDataSourceXAConnectionFactory.assertEquals((int)2, (int)this.closeCounter.get());
    }

    public class XADataSourceHandle
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("getXAConnection")) {
                return this.getXAConnection();
            }
            try {
                return method.invoke((Object)TestDataSourceXAConnectionFactory.this.ds, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected XAConnection getXAConnection() throws SQLException {
            return new TesterBasicXAConnection(TestDataSourceXAConnectionFactory.this.ds.getConnection(), TestDataSourceXAConnectionFactory.this.closeCounter);
        }
    }
}

