/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingDatabaseMetaData;
import org.apache.commons.dbcp2.TesterConnection;

public class TestDelegatingDatabaseMetaData
extends TestCase {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingDatabaseMetaData meta = null;
    private DatabaseMetaData delegateMeta = null;

    public TestDelegatingDatabaseMetaData(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.delegateMeta = this.delegateConn.getMetaData();
        this.conn = new DelegatingConnection(this.delegateConn);
        this.meta = new DelegatingDatabaseMetaData(this.conn, this.delegateMeta);
    }

    public void testGetDelegate() throws Exception {
        TestDelegatingDatabaseMetaData.assertEquals((Object)this.delegateMeta, (Object)this.meta.getDelegate());
    }

    public void testCheckOpen() throws Exception {
        ResultSet rst = this.meta.getSchemas();
        TestDelegatingDatabaseMetaData.assertTrue((!rst.isClosed() ? 1 : 0) != 0);
        this.conn.close();
        TestDelegatingDatabaseMetaData.assertTrue((boolean)rst.isClosed());
    }
}

