/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.script.Compilable;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootMonitor {
    private ScriptEngineFactory scalaScriptEngineFactory;
    private Set<Object> rootResources = Collections.synchronizedSet(new HashSet());
    private boolean clerezzaStarted = false;
    private volatile boolean activated = false;
    private final Logger logger = LoggerFactory.getLogger(BootMonitor.class);

    protected void activate(ComponentContext context) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ((Compilable)((Object)BootMonitor.this.scalaScriptEngineFactory.getScriptEngine())).compile("println(\"helo\")");
                }
                catch (ScriptException ex) {
                    BootMonitor.this.logger.warn(ex.toString());
                }
                BootMonitor.this.activated = true;
            }
        };
        t.start();
    }

    protected void bindJaxrsResource(Object p) {
        this.rootResources.add(p);
        if (!this.clerezzaStarted && this.rootResources.size() == 35) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    int lastSize = 0;
                    for (int i = 0; i < 100; ++i) {
                        if (BootMonitor.this.rootResources.size() == lastSize) {
                            BootMonitor.this.clerezzaStarted = true;
                            if (BootMonitor.this.activated) {
                                BootMonitor.this.logger.info("The Apache Clerezza Platform is now operational.");
                                return;
                            }
                        }
                        lastSize = BootMonitor.this.rootResources.size();
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException();
                        }
                    }
                }
            };
            t.start();
        }
    }

    protected void unbindJaxrsResource(Object p) {
        this.rootResources.remove(p);
    }

    protected void bindScalaScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scalaScriptEngineFactory = scriptEngineFactory;
    }

    protected void unbindScalaScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        if (this.scalaScriptEngineFactory == scriptEngineFactory) {
            this.scalaScriptEngineFactory = null;
        }
    }
}

