/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.permissiondescriptions;

import java.net.URL;
import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.permissiondescriptions.PermissionDescriptionsProvider;
import org.apache.clerezza.permissiondescriptions.PermissionDescripton;
import org.apache.clerezza.permissiondescriptions.PermissionInfo;
import org.apache.clerezza.utils.IteratorMerger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionGatherer
implements BundleListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Bundle, Collection<Class<? extends Permission>>> bundle2PermissionClassesMap = Collections.synchronizedMap(new HashMap());
    private Map<Bundle, Collection<PermissionDescripton>> bundle2PermissionDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private ComponentContext componentContext;
    private Set<ServiceReference> serviceReferenceStore = new HashSet<ServiceReference>();

    public Map<Bundle, Collection<PermissionDescripton>> getPermissionDescriptorsPerBundles() {
        return Collections.unmodifiableMap(this.bundle2PermissionDescriptorsMap);
    }

    public Iterator<PermissionDescripton> getAllPermissionDescriptors() {
        return new IteratorMerger(this.bundle2PermissionDescriptorsMap.values());
    }

    public Map<Bundle, Collection<Class<? extends Permission>>> getPermissionsPerBundles() {
        return Collections.unmodifiableMap(this.bundle2PermissionClassesMap);
    }

    public Iterator<Class<? extends Permission>> getAllPermissions() {
        return new IteratorMerger(this.bundle2PermissionClassesMap.values());
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.registerFromServiceReferenceStore();
        componentContext.getBundleContext().addBundleListener((BundleListener)this);
        this.logger.debug("Start registering permissions from activated bundles");
        this.registerPermissionsFromActivatedBundles(componentContext);
        this.logger.debug("Registered permissions from activated bundles");
    }

    private synchronized void registerFromServiceReferenceStore() {
        if (this.componentContext != null) {
            for (ServiceReference ref : this.serviceReferenceStore) {
                this.registerPermissionDescriptorsProvider(ref);
            }
            this.serviceReferenceStore.clear();
        }
    }

    protected synchronized void bindPermissionProvider(ServiceReference serviceReference) {
        if (this.componentContext != null) {
            this.registerPermissionDescriptorsProvider(serviceReference);
        } else {
            this.serviceReferenceStore.add(serviceReference);
        }
    }

    protected synchronized void unbindPermissionProvider(ServiceReference serviceReference) {
        if (!this.serviceReferenceStore.remove(serviceReference)) {
            PermissionDescriptionsProvider permissionProvider = (PermissionDescriptionsProvider)this.componentContext.locateService("permissionProvider", serviceReference);
            Bundle bundle = serviceReference.getBundle();
            Collection<PermissionDescripton> permissionDescriptiors = this.bundle2PermissionDescriptorsMap.get(bundle);
            if (permissionDescriptiors != null) {
                permissionDescriptiors.removeAll(permissionProvider.getPermissionDescriptors());
                if (permissionDescriptiors.isEmpty()) {
                    this.bundle2PermissionDescriptorsMap.remove(bundle);
                }
            }
        }
    }

    private void registerPermissionDescriptorsProvider(ServiceReference serviceReference) {
        PermissionDescriptionsProvider permissionProvider = (PermissionDescriptionsProvider)this.componentContext.locateService("permissionProvider", serviceReference);
        if (permissionProvider == null) {
            return;
        }
        Bundle bundle = serviceReference.getBundle();
        Collection<PermissionDescripton> permissionDescriptiors = this.bundle2PermissionDescriptorsMap.get(bundle);
        if (permissionDescriptiors == null) {
            permissionDescriptiors = new HashSet<PermissionDescripton>();
        }
        permissionDescriptiors.addAll(permissionProvider.getPermissionDescriptors());
        this.bundle2PermissionDescriptorsMap.put(bundle, permissionDescriptiors);
    }

    protected void deactivate(ComponentContext componentContext) {
        componentContext.getBundleContext().removeBundleListener((BundleListener)this);
        this.bundle2PermissionClassesMap.clear();
        this.bundle2PermissionDescriptorsMap.clear();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                this.registerPermissions(bundle);
                break;
            }
            case 4: {
                this.unregisterPermissions(bundle);
            }
        }
    }

    private void registerPermissionsFromActivatedBundles(ComponentContext componentContext) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = componentContext.getBundleContext().getBundles()) {
            if (bundle.getState() != 32) continue;
            this.registerPermissions(bundle);
        }
    }

    private void registerPermissions(Bundle bundle) {
        Enumeration classUrls = bundle.findEntries("/", "*.class", true);
        if (classUrls == null) {
            return;
        }
        HashSet<Class> permissionClassesSet = new HashSet<Class>();
        HashSet<PermissionDescripton> newPermissionDescriptors = new HashSet<PermissionDescripton>();
        while (classUrls.hasMoreElements()) {
            URL url = (URL)classUrls.nextElement();
            try {
                String className = url.getPath();
                int indexOfLastDot = className.lastIndexOf(".");
                Class clazz = bundle.loadClass(className = className.replaceAll("/", ".").substring(1, indexOfLastDot));
                if (!Permission.class.isAssignableFrom(clazz)) continue;
                PermissionInfo permissionInfo = clazz.getAnnotation(PermissionInfo.class);
                if (permissionInfo != null) {
                    newPermissionDescriptors.add(new PermissionDescripton(permissionInfo.value(), permissionInfo.description(), clazz.getResource(permissionInfo.icon()), clazz, this.getJavaPermissionString(clazz)));
                    continue;
                }
                permissionClassesSet.add(clazz);
            }
            catch (Exception ex) {
            }
            catch (NoClassDefFoundError err) {}
        }
        if (!permissionClassesSet.isEmpty()) {
            this.bundle2PermissionClassesMap.put(bundle, permissionClassesSet);
        }
        if (!newPermissionDescriptors.isEmpty()) {
            Collection<PermissionDescripton> permissionDescriptiors = this.bundle2PermissionDescriptorsMap.get(bundle);
            if (permissionDescriptiors == null) {
                permissionDescriptiors = newPermissionDescriptors;
            } else {
                permissionDescriptiors.addAll(newPermissionDescriptors);
            }
            this.bundle2PermissionDescriptorsMap.put(bundle, permissionDescriptiors);
        }
    }

    private void unregisterPermissions(Bundle bundle) {
        this.bundle2PermissionClassesMap.remove(bundle);
        this.bundle2PermissionDescriptorsMap.remove(bundle);
    }

    private String getJavaPermissionString(Class clazz) {
        return "(" + clazz.getName() + " \"\" \"\")";
    }
}

