/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.sparql.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.rdf.core.sparql.ResultSet;
import org.apache.clerezza.rdf.core.sparql.SolutionMapping;
import org.apache.clerezza.rdf.core.sparql.query.Variable;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Produces(value={"application/xml", "text/xml", "application/sparql-results+xml"})
@Provider
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class ResultSetXmlMessageBodyWriter
implements MessageBodyWriter<ResultSet> {
    private Providers providers;
    final Logger logger = LoggerFactory.getLogger(ResultSetXmlMessageBodyWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Source source = this.toXmlSource(resultSet);
        MessageBodyWriter sourceMessageBodyWriter = this.providers.getMessageBodyWriter(Source.class, null, null, mediaType);
        sourceMessageBodyWriter.writeTo((Object)source, Source.class, null, null, mediaType, httpHeaders, entityStream);
    }

    @Context
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    private Source toXmlSource(ResultSet queryResult) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            Element root = doc.createElement("sparql");
            root.setAttribute("xmlns", "http://www.w3.org/2005/sparql-results#");
            doc.appendChild(root);
            Element head = doc.createElement("head");
            this.createVariables(queryResult.getResultVars(), head, doc);
            root.appendChild(head);
            Element results = doc.createElement("results");
            while (queryResult.hasNext()) {
                this.createResultElement((SolutionMapping)queryResult.next(), results, doc);
            }
            root.appendChild(results);
            DOMSource source = new DOMSource(doc);
            return source;
        }
        catch (ParserConfigurationException e) {
            throw this.createWebApplicationException(e);
        }
    }

    private WebApplicationException createWebApplicationException(Exception e) {
        return new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage().replace("<", "&lt;").replace("\n", "<br/>")).build());
    }

    private Element createValueElement(RDFTerm resource, Document doc) {
        Element value = null;
        if (resource instanceof IRI) {
            value = doc.createElement("uri");
            value.appendChild(doc.createTextNode(((IRI)resource).getUnicodeString()));
        } else if (resource instanceof Literal) {
            value = doc.createElement("literal");
            value.appendChild(doc.createTextNode(((Literal)resource).getLexicalForm()));
            value.setAttribute("datatype", ((Literal)resource).getDataType().getUnicodeString());
            Language lang = ((Literal)resource).getLanguage();
            if (lang != null) {
                value.setAttribute("xml:lang", lang.toString());
            }
        } else {
            value = doc.createElement("bnode");
            value.appendChild(doc.createTextNode("/"));
        }
        return value;
    }

    private void createResultElement(SolutionMapping solutionMap, Element results, Document doc) {
        Set keys = solutionMap.keySet();
        Element result = doc.createElement("result");
        results.appendChild(result);
        for (Variable key : keys) {
            Element bindingElement = doc.createElement("binding");
            bindingElement.setAttribute("name", key.getName());
            bindingElement.appendChild(this.createValueElement((RDFTerm)solutionMap.get((Object)key), doc));
            result.appendChild(bindingElement);
        }
    }

    private void createVariables(List<String> variables, Element head, Document doc) {
        for (String variable : variables) {
            Element varElement = doc.createElement("variable");
            varElement.setAttribute("name", variable);
            head.appendChild(varElement);
        }
    }
}

