/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.sparql.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.rdf.core.sparql.ResultSet;
import org.apache.clerezza.rdf.core.sparql.SolutionMapping;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"text/tab-separated-values"})
@Provider
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class ResultSetTsvMessageBodyWriter
implements MessageBodyWriter<ResultSet> {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetTsvMessageBodyWriter.class);
    private String textEncoding = "UTF-8";
    private byte[] separator;

    public ResultSetTsvMessageBodyWriter() {
        try {
            this.buildSeparatorConformEncoding(this.textEncoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Developer error", (Throwable)e);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.writeTsvHeader(entityStream, resultSet.getResultVars());
        while (resultSet.hasNext()) {
            this.writeTsvLine(entityStream, resultSet.getResultVars(), (SolutionMapping)resultSet.next());
        }
    }

    public void setTextEncoding(String textEncoding) throws UnsupportedEncodingException {
        this.buildSeparatorConformEncoding(textEncoding);
        this.textEncoding = textEncoding;
    }

    protected String getTextEncoding() {
        return this.textEncoding;
    }

    private void buildSeparatorConformEncoding(String encoding) throws UnsupportedEncodingException {
        this.separator = ",".getBytes(encoding);
    }

    private void writeTsvHeader(OutputStream outputStream, List<String> headers) throws IOException {
        boolean first = true;
        for (String header : headers) {
            if (!first) {
                outputStream.write(this.separator);
            }
            this.writeEscaped(outputStream, header);
            first = false;
        }
        outputStream.write("\n".getBytes(this.textEncoding));
    }

    private void writeTsvLine(OutputStream outputStream, List<String> headers, SolutionMapping lineData) throws IOException {
        boolean first = true;
        for (String header : headers) {
            RDFTerm resource;
            if (!first) {
                outputStream.write(this.separator);
            }
            if ((resource = lineData.get(header)) != null) {
                this.writeEscaped(outputStream, this.getResourceValue(resource));
            }
            first = false;
        }
        outputStream.write("\n".getBytes(this.textEncoding));
    }

    private String getResourceValue(RDFTerm resource) {
        StringBuilder value = new StringBuilder();
        if (resource instanceof IRI) {
            value.append(resource.toString());
        } else if (resource instanceof Literal) {
            value.append("\"");
            value.append(this.escapedDQuotes(((Literal)resource).getLexicalForm()));
            value.append("\"");
        } else if (resource instanceof BlankNode) {
            value.append("/");
        } else {
            value.append(resource.toString());
        }
        return value.toString();
    }

    private void writeEscaped(OutputStream outputStream, String text) throws IOException {
        String line = text;
        if (text.contains("\r")) {
            line = text.replaceAll("\r", "\\r");
        }
        if (text.contains("\n")) {
            line = text.replaceAll("\n", "\\n");
        }
        if (text.contains("\t")) {
            line = text.replaceAll("\t", "\\t");
        }
        outputStream.write(line.getBytes(this.textEncoding));
    }

    private String escapedDQuotes(String text) {
        String line = text;
        if (text.contains("\"")) {
            line = text.replaceAll("\"", "\"\"");
        }
        return line;
    }
}

