/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.rdf.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Provider
@Produces(value={"text/rdf+n3", "application/n-triples", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"})
@Component
@Service(value={Object.class})
@Property(name="javax.ws.rs", boolValue={true})
public class GraphNodeWriter
implements MessageBodyWriter<GraphNode> {
    public static final String OBJ_EXP_PARAM = "xPropObj";
    public static final String SUBJ_EXP_PARAM = "xPropSubj";
    @Reference
    private Serializer serializer;
    private UriInfo uriInfo;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return GraphNode.class.isAssignableFrom(type);
    }

    public long getSize(GraphNode n, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(GraphNode node, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.serializer.serialize(entityStream, this.getExpandedContext(node), mediaType.toString());
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    private Graph getExpandedContext(GraphNode node) {
        SimpleGraph result = new SimpleGraph((Collection)node.getNodeContext());
        HashSet<RDFTerm> expandedResources = new HashSet<RDFTerm>();
        expandedResources.add(node.getNode());
        block0: while (true) {
            Set<RDFTerm> additionalExpansionRes = this.getAdditionalExpansionResources((Graph)result);
            additionalExpansionRes.removeAll(expandedResources);
            if (additionalExpansionRes.size() == 0) {
                return result;
            }
            Iterator<RDFTerm> iterator = additionalExpansionRes.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                RDFTerm resource = iterator.next();
                GraphNode additionalNode = new GraphNode(resource, node.getGraph());
                result.addAll((Collection)additionalNode.getNodeContext());
                expandedResources.add(resource);
            }
            break;
        }
    }

    private Set<RDFTerm> getAdditionalExpansionResources(Graph tc) {
        Set<IRI> subjectExpansionProperties = this.getSubjectExpansionProperties();
        Set<IRI> objectExpansionProperties = this.getObjectExpansionProperties();
        HashSet<RDFTerm> result = new HashSet<RDFTerm>();
        if (subjectExpansionProperties.size() > 0 || objectExpansionProperties.size() > 0) {
            for (Triple triple : tc) {
                IRI predicate = triple.getPredicate();
                if (subjectExpansionProperties.contains(predicate)) {
                    result.add((RDFTerm)triple.getSubject());
                }
                if (!objectExpansionProperties.contains(predicate)) continue;
                result.add(triple.getObject());
            }
        }
        return result;
    }

    private Set<IRI> getSubjectExpansionProperties() {
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        List paramValues = (List)queryParams.get((Object)SUBJ_EXP_PARAM);
        if (paramValues == null) {
            return new HashSet<IRI>(0);
        }
        HashSet<IRI> result = new HashSet<IRI>(paramValues.size());
        for (String uriString : paramValues) {
            result.add(new IRI(uriString));
        }
        return result;
    }

    private Set<IRI> getObjectExpansionProperties() {
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        List paramValues = (List)queryParams.get((Object)OBJ_EXP_PARAM);
        if (paramValues == null) {
            return new HashSet<IRI>(0);
        }
        HashSet<IRI> result = new HashSet<IRI>(paramValues.size());
        for (String uriString : paramValues) {
            result.add(new IRI(uriString));
        }
        return result;
    }

    protected void bindSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    protected void unbindSerializer(Serializer serializer) {
        if (this.serializer == serializer) {
            this.serializer = null;
        }
    }
}

