/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.rdf.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.clerezza.rdf.utils.GraphNode;

@Provider
@Produces(value={"text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"})
public class GraphNodeWriter
implements MessageBodyWriter<GraphNode> {
    public static final String OBJ_EXP_PARAM = "xPropObj";
    public static final String SUBJ_EXP_PARAM = "xPropSubj";
    private Serializer serializer;
    private UriInfo uriInfo;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return GraphNode.class.isAssignableFrom(type);
    }

    public long getSize(GraphNode n, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(GraphNode node, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.serializer.serialize(entityStream, this.getExpandedContext(node), mediaType.toString());
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    private TripleCollection getExpandedContext(GraphNode node) {
        SimpleMGraph result = new SimpleMGraph((Collection)node.getNodeContext());
        HashSet<Resource> expandedResources = new HashSet<Resource>();
        expandedResources.add(node.getNode());
        block0: while (true) {
            Set<Resource> additionalExpansionRes = this.getAdditionalExpansionResources((TripleCollection)result);
            additionalExpansionRes.removeAll(expandedResources);
            if (additionalExpansionRes.size() == 0) {
                return result;
            }
            Iterator<Resource> i$ = additionalExpansionRes.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                Resource resource = i$.next();
                GraphNode additionalNode = new GraphNode(resource, node.getGraph());
                result.addAll((Collection)additionalNode.getNodeContext());
                expandedResources.add(resource);
            }
            break;
        }
    }

    private Set<Resource> getAdditionalExpansionResources(TripleCollection tc) {
        Set<UriRef> subjectExpansionProperties = this.getSubjectExpansionProperties();
        Set<UriRef> objectExpansionProperties = this.getObjectExpansionProperties();
        HashSet<Resource> result = new HashSet<Resource>();
        if (subjectExpansionProperties.size() > 0 || objectExpansionProperties.size() > 0) {
            for (Triple triple : tc) {
                UriRef predicate = triple.getPredicate();
                if (subjectExpansionProperties.contains(predicate)) {
                    result.add((Resource)triple.getSubject());
                }
                if (!objectExpansionProperties.contains(predicate)) continue;
                result.add(triple.getObject());
            }
        }
        return result;
    }

    private Set<UriRef> getSubjectExpansionProperties() {
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        List paramValues = (List)queryParams.get((Object)SUBJ_EXP_PARAM);
        if (paramValues == null) {
            return new HashSet<UriRef>(0);
        }
        HashSet<UriRef> result = new HashSet<UriRef>(paramValues.size());
        for (String uriString : paramValues) {
            result.add(new UriRef(uriString));
        }
        return result;
    }

    private Set<UriRef> getObjectExpansionProperties() {
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        List paramValues = (List)queryParams.get((Object)OBJ_EXP_PARAM);
        if (paramValues == null) {
            return new HashSet<UriRef>(0);
        }
        HashSet<UriRef> result = new HashSet<UriRef>(paramValues.size());
        for (String uriString : paramValues) {
            result.add(new UriRef(uriString));
        }
        return result;
    }

    protected void bindSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    protected void unbindSerializer(Serializer serializer) {
        if (this.serializer == serializer) {
            this.serializer = null;
        }
    }
}

