/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.sparql.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.PlainLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.sparql.ResultSet;
import org.apache.clerezza.rdf.core.sparql.SolutionMapping;
import org.apache.clerezza.rdf.core.sparql.query.Variable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json", "application/sparql-results+json"})
@Provider
public class ResultSetJsonMessageBodyWriter
implements MessageBodyWriter<ResultSet> {
    final Logger logger = LoggerFactory.getLogger(ResultSetJsonMessageBodyWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JSONObject json = this.toJsonSource(resultSet);
        entityStream.write(json.toJSONString().getBytes("UTF-8"));
    }

    private JSONObject toJsonSource(ResultSet queryResult) {
        JSONObject root = new JSONObject();
        JSONObject head = new JSONObject();
        root.put((Object)"head", (Object)head);
        this.createVariables(queryResult.getResultVars(), head);
        JSONObject results = new JSONObject();
        root.put((Object)"results", (Object)results);
        JSONArray bindings = null;
        while (queryResult.hasNext()) {
            if (bindings == null) {
                bindings = new JSONArray();
                results.put((Object)"bindings", (Object)bindings);
            }
            bindings.add((Object)this.createResult((SolutionMapping)queryResult.next()));
        }
        return root;
    }

    private JSONObject createResultElement(Resource resource) {
        JSONObject element = new JSONObject();
        if (resource instanceof UriRef) {
            element.put((Object)"type", (Object)"uri");
            element.put((Object)"value", (Object)((UriRef)UriRef.class.cast(resource)).getUnicodeString());
        } else if (resource instanceof PlainLiteral) {
            element.put((Object)"type", (Object)"literal");
            element.put((Object)"value", (Object)((PlainLiteral)PlainLiteral.class.cast(resource)).getLexicalForm());
            Language lang = ((PlainLiteral)PlainLiteral.class.cast(resource)).getLanguage();
            if (lang != null) {
                element.put((Object)"xml:lang", (Object)lang.toString());
            }
        } else if (resource instanceof TypedLiteral) {
            element.put((Object)"type", (Object)"typed-literal");
            element.put((Object)"datatype", (Object)((TypedLiteral)TypedLiteral.class.cast(resource)).getDataType().getUnicodeString());
            element.put((Object)"value", (Object)((TypedLiteral)TypedLiteral.class.cast(resource)).getLexicalForm());
        } else if (resource instanceof BNode) {
            element.put((Object)"type", (Object)"bnode");
            element.put((Object)"value", (Object)"/");
        } else {
            element = null;
        }
        return element;
    }

    private JSONObject createResult(SolutionMapping solutionMap) {
        JSONObject result = new JSONObject();
        Set keys = solutionMap.keySet();
        for (Variable key : keys) {
            result.put((Object)key.getName(), (Object)this.createResultElement((Resource)solutionMap.get((Object)key)));
        }
        return result;
    }

    private void createVariables(List<String> variables, JSONObject head) {
        JSONArray vars = null;
        for (String variable : variables) {
            if (vars == null) {
                vars = new JSONArray();
                head.put((Object)"vars", (Object)vars);
            }
            vars.add((Object)variable);
        }
    }
}

