/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.jaxrs.sparql.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.PlainLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.sparql.ResultSet;
import org.apache.clerezza.rdf.core.sparql.SolutionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"text/csv"})
@Provider
public class ResultSetCsvMessageBodyWriter
implements MessageBodyWriter<ResultSet> {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetCsvMessageBodyWriter.class);
    private static final String UTF_8 = "UTF-8";
    private static byte[] separator;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.writeCsvHeader(entityStream, resultSet.getResultVars());
        while (resultSet.hasNext()) {
            this.writeCsvLine(entityStream, resultSet.getResultVars(), (SolutionMapping)resultSet.next());
        }
    }

    private void writeCsvHeader(OutputStream outputStream, List<String> headers) throws IOException {
        boolean first = true;
        for (String header : headers) {
            if (!first) {
                outputStream.write(separator);
            }
            this.writeEscaped(outputStream, header);
            first = false;
        }
        outputStream.write("\n".getBytes(UTF_8));
    }

    private void writeCsvLine(OutputStream outputStream, List<String> headers, SolutionMapping lineData) throws IOException {
        boolean first = true;
        for (String header : headers) {
            Resource resource;
            if (!first) {
                outputStream.write(separator);
            }
            if ((resource = lineData.get(header)) != null) {
                this.writeEscaped(outputStream, this.getResourceValue(resource));
            }
            first = false;
        }
        outputStream.write("\n".getBytes(UTF_8));
    }

    private String getResourceValue(Resource resource) {
        StringBuilder value = new StringBuilder();
        if (resource instanceof UriRef) {
            value.append(((UriRef)resource).getUnicodeString());
        } else if (resource instanceof TypedLiteral) {
            value.append(((TypedLiteral)resource).getLexicalForm());
        } else if (resource instanceof PlainLiteral) {
            value.append(((PlainLiteral)resource).getLexicalForm());
        } else if (resource instanceof BNode) {
            value.append("/");
        } else {
            value.append(resource.toString());
        }
        return value.toString();
    }

    private void writeEscaped(OutputStream outputStream, String text) throws IOException {
        String line = text;
        if (text.contains("\r") || text.contains("\n") || text.contains(",") || text.contains("\"")) {
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(text.replaceAll("\"", "\"\""));
            builder.append('\"');
            line = builder.toString();
        }
        outputStream.write(line.getBytes(UTF_8));
    }

    static {
        try {
            separator = ",".getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Developer error", (Throwable)e);
        }
    }
}

