/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.sparql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.sparql.SparqlBNode;
import org.apache.clerezza.commons.rdf.impl.sparql.SparqlClient;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractGraph;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;

public class SparqlGraph
extends AbstractGraph {
    private static final int MAX_ISOMORPHIC_BNODES = 1000;
    private static final Logger log = Logger.getLogger(SparqlGraph.class.getName());
    final SparqlClient sparqlClient;

    public SparqlGraph(String endpoint) {
        this.sparqlClient = new SparqlClient(endpoint);
    }

    protected Iterator<Triple> performFilter(final BlankNodeOrIRI filterSubject, final IRI filterPredicate, final RDFTerm filterObject) {
        try {
            String query = this.createQuery(filterSubject, filterPredicate, filterObject);
            List<Map<String, RDFTerm>> sparqlResults = this.sparqlClient.queryResultSet(query);
            final ArrayList<TripleImpl> rawTriples = new ArrayList<TripleImpl>();
            for (Map<String, RDFTerm> result : sparqlResults) {
                rawTriples.add(new TripleImpl(filterSubject != null ? filterSubject : (BlankNodeOrIRI)result.get("s"), filterPredicate != null ? filterPredicate : (IRI)result.get("p"), filterObject != null ? filterObject : result.get("o")));
            }
            final Iterator rawTriplesIter = rawTriples.iterator();
            return new Callable<Iterator<Triple>>(){
                final Map<BlankNode, SparqlBNode> nodeMap = new HashMap<BlankNode, SparqlBNode>();
                final Set<ImmutableGraph> usedContext = new HashSet<ImmutableGraph>();

                private RDFTerm useSparqlNode(RDFTerm node) throws IOException {
                    if (node instanceof BlankNodeOrIRI) {
                        return this.useSparqlNode((BlankNodeOrIRI)node);
                    }
                    return node;
                }

                private BlankNodeOrIRI useSparqlNode(BlankNodeOrIRI node) throws IOException {
                    if (node instanceof BlankNode) {
                        if (!this.nodeMap.containsKey(node)) {
                            this.createBlankNodesForcontext((BlankNode)node);
                        }
                        if (!this.nodeMap.containsKey(node)) {
                            throw new RuntimeException("no Bnode created");
                        }
                        return (BlankNodeOrIRI)this.nodeMap.get(node);
                    }
                    return node;
                }

                private void createBlankNodesForcontext(BlankNode node) throws IOException {
                    ImmutableGraph context = this.getContext(node);
                    HashSet<BlankNode> rawNodes = new HashSet<BlankNode>();
                    for (Triple triple : context) {
                        RDFTerm object;
                        BlankNodeOrIRI subject = triple.getSubject();
                        if (subject instanceof BlankNode) {
                            rawNodes.add((BlankNode)subject);
                        }
                        if (!((object = triple.getObject()) instanceof BlankNode)) continue;
                        rawNodes.add((BlankNode)object);
                    }
                    HashSet<SparqlBNode> createdSparqlNodes = new HashSet<SparqlBNode>();
                    block1: for (BlankNode rawNode : rawNodes) {
                        for (int i = 0; i < 1000; ++i) {
                            SparqlBNode sparqlBNode = new SparqlBNode(rawNode, (Collection<Triple>)context, i);
                            if (createdSparqlNodes.contains((Object)sparqlBNode)) continue;
                            this.nodeMap.put(rawNode, sparqlBNode);
                            createdSparqlNodes.add(sparqlBNode);
                            continue block1;
                        }
                    }
                }

                private ImmutableGraph getContext(BlankNode node) throws IOException {
                    if (filterSubject == null && filterPredicate == null && filterObject == null) {
                        return this.getContextInRaw(node);
                    }
                    ImmutableGraph startContext = this.getContextInRaw(node);
                    Set<ImmutableGraph> expandedContexts = this.expandContext((Collection<Triple>)startContext);
                    ImmutableGraph result = null;
                    for (ImmutableGraph expandedContext : expandedContexts) {
                        if (this.usedContext.contains(expandedContext)) continue;
                        result = expandedContext;
                        break;
                    }
                    if (result == null) {
                        log.warning("he underlying sparql graph seems to contain redundant triples, this might cause unexpected results");
                        result = expandedContexts.iterator().next();
                    } else {
                        this.usedContext.add(result);
                    }
                    return result;
                }

                private ImmutableGraph getContextInRaw(BlankNode node) {
                    SimpleGraph contextBuilder = new SimpleGraph();
                    for (Triple rawTriple : rawTriples) {
                        BlankNodeOrIRI rawSubject = rawTriple.getSubject();
                        RDFTerm rawObject = rawTriple.getObject();
                        if (!rawSubject.equals(node) && !rawObject.equals(node)) continue;
                        contextBuilder.add((Object)rawTriple);
                    }
                    return contextBuilder.getImmutableGraph();
                }

                @Override
                public Iterator<Triple> call() throws Exception {
                    return new Iterator<Triple>(){

                        @Override
                        public boolean hasNext() {
                            return rawTriplesIter.hasNext();
                        }

                        @Override
                        public Triple next() {
                            try {
                                Triple rawTriple = (Triple)rawTriplesIter.next();
                                return new TripleImpl(this.useSparqlNode(rawTriple.getSubject()), rawTriple.getPredicate(), this.useSparqlNode(rawTriple.getObject()));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    };
                }

                private Set<ImmutableGraph> expandContext(Collection<Triple> startContext) throws IOException {
                    StringBuilder queryBuilder = new StringBuilder();
                    queryBuilder.append("SELECT * WHERE {\n ");
                    Map bNodeVarNameMap = SparqlGraph.this.writeTriplePattern(queryBuilder, startContext);
                    Set bNodesInContext = bNodeVarNameMap.keySet();
                    for (BlankNode bNode : bNodesInContext) {
                        String bNodeVarLabel = (String)bNodeVarNameMap.get(bNode);
                        queryBuilder.append("OPTIONAL { ");
                        queryBuilder.append('?');
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(' ');
                        queryBuilder.append("?po");
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(" ?o");
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(" } .\n");
                        queryBuilder.append("OPTIONAL { ");
                        queryBuilder.append("?s");
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(' ');
                        queryBuilder.append("?pi");
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(" ?");
                        queryBuilder.append(bNodeVarLabel);
                        queryBuilder.append(" } .\n");
                    }
                    queryBuilder.append(" }");
                    List<Map<String, RDFTerm>> expansionQueryResults = SparqlGraph.this.sparqlClient.queryResultSet(queryBuilder.toString());
                    HashSet<ImmutableGraph> expandedContexts = new HashSet<ImmutableGraph>();
                    block1: for (Map<String, RDFTerm> expansionQueryResult : expansionQueryResults) {
                        HashSet<Triple> expandedContext = new HashSet<Triple>();
                        HashMap<BlankNode, BlankNode> newBNodesToOldBNodes = new HashMap<BlankNode, BlankNode>();
                        for (BlankNode oldBNode : bNodesInContext) {
                            String bNodeVarLabel = (String)bNodeVarNameMap.get(oldBNode);
                            RDFTerm newNode = expansionQueryResult.get(bNodeVarLabel);
                            if (!(newNode instanceof BlankNode)) continue block1;
                            newBNodesToOldBNodes.put((BlankNode)newNode, oldBNode);
                        }
                        expandedContext.addAll(startContext);
                        boolean newBNodeIntroduced = false;
                        boolean newTripleAdded = false;
                        for (BlankNode oldBNode : bNodesInContext) {
                            String bNodeVarLabel = (String)bNodeVarNameMap.get(oldBNode);
                            IRI newPredicate = (IRI)expansionQueryResult.get("po" + bNodeVarLabel);
                            if (newPredicate != null) {
                                RDFTerm newObject = expansionQueryResult.get("o" + bNodeVarLabel);
                                if (newObject instanceof BlankNode) {
                                    if (newBNodesToOldBNodes.containsKey(newObject)) {
                                        newObject = (RDFTerm)newBNodesToOldBNodes.get(newObject);
                                    } else {
                                        newBNodeIntroduced = true;
                                    }
                                }
                                if (expandedContext.add((Triple)new TripleImpl((BlankNodeOrIRI)oldBNode, newPredicate, newObject))) {
                                    newTripleAdded = true;
                                }
                            }
                            if ((newPredicate = (IRI)expansionQueryResult.get("pi" + bNodeVarLabel)) == null) continue;
                            RDFTerm newSubject = expansionQueryResult.get("s" + bNodeVarLabel);
                            if (newSubject instanceof BlankNode) {
                                if (newBNodesToOldBNodes.containsKey(newSubject)) {
                                    newSubject = (RDFTerm)newBNodesToOldBNodes.get(newSubject);
                                } else {
                                    newBNodeIntroduced = true;
                                }
                            }
                            if (!expandedContext.add((Triple)new TripleImpl((BlankNodeOrIRI)newSubject, newPredicate, (RDFTerm)oldBNode))) continue;
                            newTripleAdded = true;
                        }
                        if (newBNodeIntroduced) {
                            expandedContexts.addAll(this.expandContext(expandedContext));
                            continue;
                        }
                        if (!newTripleAdded) continue;
                        expandedContexts.addAll(this.expandContext(expandedContext));
                    }
                    if (expandedContexts.isEmpty()) {
                        expandedContexts.add(new SimpleGraph(startContext).getImmutableGraph());
                    }
                    return expandedContexts;
                }
            }.call();
        }
        catch (AlienBNodeException e) {
            return new Iterator<Triple>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Triple next() {
                    throw new NoSuchElementException();
                }
            };
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String createQuery(BlankNodeOrIRI filterSubject, IRI filterPredicate, RDFTerm filterObject) {
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append("SELECT ");
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append("WHERE { ");
        if (filterSubject == null) {
            whereBuilder.append("?s");
            selectBuilder.append("?s ");
        } else if (filterSubject instanceof SparqlBNode) {
            whereBuilder.append("?sn");
        } else {
            whereBuilder.append(this.asSparqlTerm(filterSubject));
        }
        whereBuilder.append(' ');
        if (filterPredicate == null) {
            whereBuilder.append("?p");
            selectBuilder.append("?p ");
        } else {
            whereBuilder.append(this.asSparqlTerm(filterPredicate));
        }
        whereBuilder.append(' ');
        if (filterObject == null) {
            whereBuilder.append("?o");
            selectBuilder.append("?o ");
        } else if (filterObject instanceof SparqlBNode) {
            whereBuilder.append("?on");
        } else {
            whereBuilder.append(this.asSparqlTerm(filterObject));
        }
        whereBuilder.append(" .\n");
        if (filterSubject instanceof SparqlBNode) {
            this.writeTriplePattern(whereBuilder, (Collection<Triple>)((SparqlBNode)filterSubject).context, "sn");
        }
        if (filterObject instanceof SparqlBNode) {
            this.writeTriplePattern(whereBuilder, (Collection<Triple>)((SparqlBNode)filterObject).context, "on");
        }
        whereBuilder.append(" }");
        return selectBuilder.append((CharSequence)whereBuilder).toString();
    }

    protected int performSize() {
        try {
            return this.sparqlClient.queryResultSet("SELECT * WHERE { ?s ?p ?o}").size();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String asSparqlTerm(IRI iri) {
        return "<" + iri.getUnicodeString() + ">";
    }

    private String asSparqlTerm(Literal literal) {
        return "\"" + literal.getLexicalForm() + "\"";
    }

    private String asSparqlTerm(BlankNode bnode) {
        if (!(bnode instanceof SparqlBNode)) {
            throw new AlienBNodeException();
        }
        throw new RuntimeException("SparqlBNodes should have been handled earlier");
    }

    private String asSparqlTerm(BlankNodeOrIRI term) {
        if (term instanceof IRI) {
            return this.asSparqlTerm((IRI)term);
        }
        return this.asSparqlTerm((BlankNode)term);
    }

    private String asSparqlTerm(RDFTerm term) {
        if (term instanceof BlankNodeOrIRI) {
            return this.asSparqlTerm((BlankNodeOrIRI)term);
        }
        return this.asSparqlTerm((Literal)term);
    }

    private Map<BlankNode, String> writeTriplePattern(StringBuilder queryBuilder, Collection<Triple> triples) {
        return this.writeTriplePattern(queryBuilder, triples, null);
    }

    private Map<BlankNode, String> writeTriplePattern(StringBuilder queryBuilder, Collection<Triple> triples, String varLabelForInternalBNodeId) {
        ArrayList<String> triplePatterns = new ArrayList<String>();
        int varCounter = 0;
        HashMap<BlankNode, String> bNodeVarNameMap = new HashMap<BlankNode, String>();
        for (Triple t : triples) {
            String varName;
            StringBuilder builder = new StringBuilder();
            BlankNodeOrIRI s = t.getSubject();
            if (s instanceof BlankNode) {
                if (bNodeVarNameMap.containsKey(s)) {
                    varName = (String)bNodeVarNameMap.get(s);
                } else {
                    varName = "v" + varCounter++;
                    bNodeVarNameMap.put((BlankNode)s, varName);
                }
                builder.append('?');
                builder.append(varName);
            } else if (s.equals(SparqlBNode.internalBNodeId)) {
                builder.append('?');
                builder.append(varLabelForInternalBNodeId);
            } else {
                builder.append(this.asSparqlTerm(s));
            }
            builder.append(' ');
            builder.append(this.asSparqlTerm(t.getPredicate()));
            builder.append(' ');
            RDFTerm o = t.getObject();
            if (o instanceof BlankNode) {
                if (bNodeVarNameMap.containsKey(o)) {
                    varName = (String)bNodeVarNameMap.get(o);
                } else {
                    varName = "v" + varCounter++;
                    bNodeVarNameMap.put((BlankNode)o, varName);
                }
                builder.append('?');
                builder.append(varName);
            } else if (o.equals(SparqlBNode.internalBNodeId)) {
                builder.append('?');
                builder.append(varLabelForInternalBNodeId);
            } else {
                builder.append(this.asSparqlTerm(o));
            }
            builder.append('.');
            triplePatterns.add(builder.toString());
        }
        for (String triplePattern : triplePatterns) {
            queryBuilder.append(triplePattern);
            queryBuilder.append('\n');
        }
        return bNodeVarNameMap;
    }

    private static class AlienBNodeException
    extends RuntimeException {
    }
}

