/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.sparql;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractLiteral;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SparqlClient {
    final String endpoint;

    public SparqlClient(String endpoint) {
        this.endpoint = endpoint;
    }

    List<Map<String, RDFTerm>> queryResultSet(String query) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(this.endpoint);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("query", query));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        try (CloseableHttpResponse response2 = httpclient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity2 = response2.getEntity();
            InputStream in = entity2.getContent();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SparqlsResultsHandler sparqlsResultsHandler = new SparqlsResultsHandler();
            xmlReader.setContentHandler(sparqlsResultsHandler);
            xmlReader.parse(new InputSource(in));
            EntityUtils.consume((HttpEntity)entity2);
            List list = sparqlsResultsHandler.getResults();
            return list;
        }
    }

    public static final class SparqlsResultsHandler
    extends DefaultHandler {
        private String currentBindingName;
        private Map<String, RDFTerm> currentResult = null;
        private final List<Map<String, RDFTerm>> results = new ArrayList<Map<String, RDFTerm>>();
        private boolean readingValue;
        private String lang;
        private String value;
        private Map<String, BlankNode> bNodeMap = new HashMap<String, BlankNode>();
        private static final IRI XSD_STRING = new IRI("http://www.w3.org/2001/XMLSchema#string");
        private static final IRI RDF_LANG_STRING = new IRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");

        private RDFTerm getBNode(String value) {
            if (!this.bNodeMap.containsKey(value)) {
                this.bNodeMap.put(value, new BlankNode());
            }
            return (RDFTerm)this.bNodeMap.get(value);
        }

        private List<Map<String, RDFTerm>> getResults() {
            return this.results;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ("http://www.w3.org/2005/sparql-results#".equals(namespaceURI)) {
                if ("result".equals(localName)) {
                    if (this.currentResult != null) {
                        throw new SAXException("unexpected tag <result>");
                    }
                    this.currentResult = new HashMap<String, RDFTerm>();
                } else if ("binding".equals(localName)) {
                    if (this.currentResult == null) {
                        throw new SAXException("unexpected tag <binding>");
                    }
                    this.currentBindingName = atts.getValue("name");
                } else if ("uri".equals(localName) || "bnode".equals(localName) || "literal".equals(localName)) {
                    if (this.readingValue) {
                        throw new SAXException("unexpected tag <" + localName + ">");
                    }
                    this.lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                    this.readingValue = true;
                }
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.readingValue) {
                this.value = new String(chars, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ("http://www.w3.org/2005/sparql-results#".equals(namespaceURI)) {
                if ("result".equals(localName)) {
                    this.results.add(this.currentResult);
                    this.currentResult = null;
                } else if ("binding".equals(localName)) {
                    if (this.currentBindingName == null) {
                        throw new SAXException("unexpected tag </binding>");
                    }
                    this.currentBindingName = null;
                } else {
                    try {
                        BindingType b = BindingType.valueOf(localName);
                        Object rdfTerm = null;
                        final Language language = this.lang == null ? null : new Language(this.lang);
                        switch (b) {
                            case uri: {
                                rdfTerm = new IRI(this.value);
                                break;
                            }
                            case bnode: {
                                rdfTerm = this.getBNode(this.value);
                                break;
                            }
                            case literal: {
                                final String lf = this.value;
                                rdfTerm = new AbstractLiteral(){

                                    public String getLexicalForm() {
                                        return lf;
                                    }

                                    public IRI getDataType() {
                                        if (language != null) {
                                            return RDF_LANG_STRING;
                                        }
                                        return XSD_STRING;
                                    }

                                    public Language getLanguage() {
                                        return language;
                                    }
                                };
                            }
                        }
                        this.currentResult.put(this.currentBindingName, (RDFTerm)rdfTerm);
                        this.readingValue = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        static enum BindingType {
            uri,
            bnode,
            literal;

        }
    }
}

