/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.sparql;

import java.util.Collection;
import java.util.Objects;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;

class SparqlBNode
extends BlankNode {
    static final IRI internalBNodeId = new IRI("urn:x-internalid:fdmpoihdfw");
    final ImmutableGraph context;
    private final int isoDistinguisher;

    SparqlBNode(BlankNode node, Collection<Triple> context, int isoDistinguisher) {
        this.isoDistinguisher = isoDistinguisher;
        SimpleGraph contextBuider = new SimpleGraph();
        for (Triple triple : context) {
            BlankNodeOrIRI subject = triple.getSubject();
            RDFTerm object = triple.getObject();
            contextBuider.add((Triple)new TripleImpl((BlankNodeOrIRI)(subject.equals(node) ? internalBNodeId : subject), triple.getPredicate(), (RDFTerm)(object.equals(node) ? internalBNodeId : object)));
        }
        this.context = contextBuider.getImmutableGraph();
    }

    public int hashCode() {
        int hash = 7 + this.isoDistinguisher;
        hash = 61 * hash + Objects.hashCode(this.context);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SparqlBNode other = (SparqlBNode)((Object)obj);
        if (this.isoDistinguisher != other.isoDistinguisher) {
            return false;
        }
        return Objects.equals(this.context, other.context);
    }
}

