/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.util.repository;

import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.util.repository.ObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.TimeLogger;

public class MultiThreadedObjectGenerator {
    private MultiThreadedObjectGenerator() {
    }

    private static ObjectGenerator createObjectGenerator(CmisBinding binding, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, ObjectGenerator.CONTENT_KIND contentKind, boolean doCleanup) {
        BindingsObjectFactory objectFactory = binding.getObjectFactory();
        NavigationService navSvc = binding.getNavigationService();
        ObjectService objSvc = binding.getObjectService();
        RepositoryService repSvc = binding.getRepositoryService();
        ObjectGenerator gen = new ObjectGenerator(objectFactory, navSvc, objSvc, repSvc, repoId, contentKind);
        gen.setUseUuidsForNames(true);
        gen.setNumberOfDocumentsToCreatePerFolder(docsPerFolder);
        gen.setDocumentTypeId(documentType);
        gen.setFolderTypeId(folderType);
        gen.setContentSizeInKB(contentSizeInKB);
        gen.setCleanUpAfterCreate(doCleanup);
        return gen;
    }

    private static String getRootFolderId(CmisBinding binding, String repositoryId, String rootFolderId) {
        RepositoryService repSvc = binding.getRepositoryService();
        RepositoryInfo rep = repSvc.getRepositoryInfo(repositoryId, null);
        if (null == rootFolderId || rootFolderId.length() == 0) {
            rootFolderId = rep.getRootFolderId();
        }
        return rootFolderId;
    }

    public static ObjectGeneratorRunner prepareForCreateTree(CmisBinding binding, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, ObjectGenerator.CONTENT_KIND contentKind, boolean doCleanup) {
        ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(binding, repoId, docsPerFolder, foldersPerFolders, depth, documentType, folderType, contentSizeInKB, rootFolderId, contentKind, doCleanup);
        ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateTree);
        gen.fFoldersPerFolders = foldersPerFolders;
        gen.fDepth = depth;
        gen.fRootFolderId = MultiThreadedObjectGenerator.getRootFolderId(binding, repoId, rootFolderId);
        return gen;
    }

    public static ObjectGeneratorRunner[] prepareForCreateTreeMT(CmisBinding provider, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String[] rootFolderIds, ObjectGenerator.CONTENT_KIND contentKind, boolean doCleanup) {
        ObjectGeneratorRunner[] runners = new ObjectGeneratorRunner[rootFolderIds.length];
        for (int i = 0; i < rootFolderIds.length; ++i) {
            ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(provider, repoId, docsPerFolder, foldersPerFolders, depth, documentType, folderType, contentSizeInKB, rootFolderIds[i], contentKind, doCleanup);
            ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateTree);
            gen.fFoldersPerFolders = foldersPerFolders;
            gen.fDepth = depth;
            gen.fRootFolderId = rootFolderIds[i];
            runners[i] = gen;
        }
        return runners;
    }

    public static ObjectGeneratorRunner prepareForCreateDocument(CmisBinding provider, String repoId, String documentType, int contentSizeInKB, String rootFolderId, int noDocuments, ObjectGenerator.CONTENT_KIND contentKind, boolean doCleanup) {
        ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(provider, repoId, 0, 0, 0, documentType, null, contentSizeInKB, rootFolderId, contentKind, doCleanup);
        ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateDocument);
        gen.fRootFolderId = MultiThreadedObjectGenerator.getRootFolderId(provider, repoId, rootFolderId);
        gen.fCount = noDocuments;
        return gen;
    }

    public static ObjectGeneratorRunner[] prepareForCreateDocumentMT(int threadCount, CmisBinding binding, String repoId, String documentType, int contentSizeInKB, String rootFolderId, int noDocuments, ObjectGenerator.CONTENT_KIND contentKind, boolean doCleanup) {
        ObjectGeneratorRunner[] runners = new ObjectGeneratorRunner[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(binding, repoId, 0, 0, 0, documentType, null, contentSizeInKB, rootFolderId, contentKind, doCleanup);
            ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateDocument);
            gen.fRootFolderId = MultiThreadedObjectGenerator.getRootFolderId(binding, repoId, rootFolderId);
            gen.fCount = noDocuments;
            runners[i] = gen;
        }
        return runners;
    }

    public static ObjectGeneratorRunner prepareForCreateFolder(CmisBinding provider, String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(provider, repoId, 0, 0, 0, null, folderType, 0, rootFolderId, null, doCleanup);
        ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateFolders);
        gen.fRootFolderId = MultiThreadedObjectGenerator.getRootFolderId(provider, repoId, rootFolderId);
        gen.fCount = noFolders;
        return gen;
    }

    public static ObjectGeneratorRunner[] prepareForCreateFolderMT(int threadCount, CmisBinding binding, String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        ObjectGeneratorRunner[] runners = new ObjectGeneratorRunner[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(binding, repoId, 0, 0, 0, null, folderType, 0, rootFolderId, null, doCleanup);
            ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateFolders);
            gen.fRootFolderId = MultiThreadedObjectGenerator.getRootFolderId(binding, repoId, rootFolderId);
            gen.fCount = noFolders;
            runners[i] = gen;
        }
        return runners;
    }

    public static ObjectGeneratorRunner prepareForCreateTypes(CmisBinding provider, String repoId, TypeDefinitionList typeDefList) {
        ObjectGenerator objGen = MultiThreadedObjectGenerator.createObjectGenerator(provider, repoId, 0, 0, 0, null, null, 0, null, null, false);
        ObjectGeneratorRunner gen = new ObjectGeneratorRunner(objGen, Action.CreateTypes);
        gen.fTypeDefList = typeDefList;
        return gen;
    }

    public static void runMultiThreaded(ObjectGeneratorRunner[] runner) {
        int threadCount = runner.length;
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            Thread thread;
            threads[i] = thread = new Thread((Runnable)runner[i], "ObjectGeneratorThread-" + i);
            thread.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
            System.out.println();
            System.out.println("Result:");
            TimeLogger[] loggersCreateDoc = new TimeLogger[threadCount];
            TimeLogger[] loggersCreateFolder = new TimeLogger[threadCount];
            TimeLogger[] loggersDelete = new TimeLogger[threadCount];
            for (int i = 0; i < threadCount; ++i) {
                loggersCreateDoc[i] = runner[i].fObjGen.getCreateDocumentTimeLogger();
                loggersCreateFolder[i] = runner[i].fObjGen.getCreateFolderTimeLogger();
                loggersDelete[i] = runner[i].fObjGen.getDeleteTimeLogger();
            }
            TimeLogger.printTimes(loggersCreateDoc);
            TimeLogger.printTimes(loggersCreateFolder);
            TimeLogger.printTimes(loggersDelete);
        }
        catch (InterruptedException e) {
            System.out.println("Failed to wait for termination of threads: " + e);
        }
    }

    public static class ObjectGeneratorRunner
    implements Runnable {
        private final Action fAction;
        ObjectGenerator fObjGen;
        private String fRootFolderId;
        private int fFoldersPerFolders;
        private int fDepth;
        private int fCount;
        private TypeDefinitionList fTypeDefList;

        public ObjectGeneratorRunner(ObjectGenerator objGen, Action action) {
            this.fObjGen = objGen;
            this.fAction = action;
        }

        public void run() {
            if (this.fAction == Action.CreateDocument) {
                this.doCreateDocument();
            } else if (this.fAction == Action.CreateTree) {
                this.doCreateTree();
            } else if (this.fAction == Action.CreateFolders) {
                this.doCreateFolder();
            } else if (this.fAction == Action.CreateTypes) {
                this.doCreateTypes();
            }
        }

        public String[] doCreateDocument() {
            String[] ids = this.fObjGen.createDocuments(this.fRootFolderId, this.fCount);
            return ids;
        }

        public void doCreateTree() {
            this.fObjGen.createFolderHierachy(this.fDepth, this.fFoldersPerFolders, this.fRootFolderId);
        }

        public String[] doCreateFolder() {
            return this.fObjGen.createFolders(this.fRootFolderId, this.fCount);
        }

        public void doCreateTypes() {
            this.fObjGen.createTypes(this.fTypeDefList);
        }

        public ObjectGenerator getObjectGenerator() {
            return this.fObjGen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        CreateDocument,
        CreateTree,
        CreateFolders,
        CreateTypes;

    }
}

