/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.util.content.fractal;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.chemistry.opencmis.util.content.fractal.ComplexPoint;
import org.apache.chemistry.opencmis.util.content.fractal.ComplexRectangle;

final class FractalCalculator {
    private int[] colorMap;
    protected int[][] noIterations;
    private double delta;
    private double iRangeMax;
    private double iRangeMin;
    private int maxIterations;
    private ComplexRectangle newRect;
    private int numColors;
    private int imageHeight;
    private int imageWidth;
    private double rRangeMax;
    private double rRangeMin;
    private double cJuliaPointR = 0.0;
    private double cJuliaPointI = 0.0;
    boolean useJulia = false;

    public FractalCalculator(ComplexRectangle complRect, int maxIters, int imgWidth, int imgHeight, int[] colMap, ComplexPoint juliaPoint) {
        this.maxIterations = maxIters;
        this.newRect = complRect;
        this.imageWidth = imgWidth;
        this.imageHeight = imgHeight;
        this.colorMap = colMap;
        this.numColors = this.colorMap.length;
        this.rRangeMin = this.newRect.getRMin();
        this.rRangeMax = this.newRect.getRMax();
        this.iRangeMin = this.newRect.getIMin();
        this.iRangeMax = this.newRect.getIMax();
        this.delta = (this.rRangeMax - this.rRangeMin) / (double)this.imageWidth;
        if (null != juliaPoint) {
            this.cJuliaPointR = juliaPoint.getReal();
            this.cJuliaPointI = juliaPoint.getImaginary();
            this.useJulia = true;
        }
    }

    public int[][] calcFractal() {
        this.noIterations = new int[this.imageWidth][this.imageHeight];
        for (int x = 0; x < this.imageWidth; ++x) {
            for (int y = 0; y < this.imageHeight; ++y) {
                double zR = this.rRangeMin + (double)x * this.delta;
                double zI = this.iRangeMin + (double)(this.imageHeight - y) * this.delta;
                this.noIterations[x][y] = this.useJulia ? this.testPointJuliaSet(zR, zI, this.maxIterations) : this.testPointMandelbrot(zR, zI, this.maxIterations);
            }
        }
        return this.noIterations;
    }

    public BufferedImage mapItersToColors(int[][] iterations) {
        BufferedImage image = new BufferedImage(this.imageWidth, this.imageHeight, 5);
        for (int x = 0; x < this.imageWidth; ++x) {
            for (int y = 0; y < this.imageHeight; ++y) {
                int color = this.getColor(iterations[x][y]);
                image.setRGB(x, y, color);
            }
        }
        return image;
    }

    protected int getColor(int numIterations) {
        int c = Color.black.getRGB();
        if (numIterations != 0) {
            int colorNum = (int)((double)this.numColors * (1.0 - (double)((float)numIterations / (float)this.maxIterations)));
            colorNum = colorNum == this.numColors ? 0 : colorNum;
            c = this.colorMap[colorNum];
        }
        return c;
    }

    private int testPointMandelbrot(double cR, double cI, int maxIterations) {
        double zR = cR;
        double zI = cI;
        for (int i = 1; i <= maxIterations; ++i) {
            double zROld = zR;
            double distSquared = (zR = zR * zR - zI * zI + cR) * zR + (zI = 2.0 * zROld * zI + cI) * zI;
            if (!(distSquared >= 4.0)) continue;
            return i;
        }
        return 0;
    }

    private int testPointJuliaSet(double zR, double zI, int maxIterations) {
        for (int i = 1; i <= maxIterations; ++i) {
            double zROld = zR;
            double distSquared = (zR = zR * zR - zI * zI + this.cJuliaPointR) * zR + (zI = 2.0 * zROld * zI + this.cJuliaPointI) * zI;
            if (!(distSquared >= 4.0)) continue;
            return i;
        }
        return 0;
    }
}

