/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.util.repository;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeLogger {
    private static Log LOG = LogFactory.getLog(TimeLogger.class);
    private String fAction;
    private LinkedList<TimeRecord> fTimeRecs = new LinkedList();
    private final int maxSize = 2500;
    TimeRecord fCurrentRec;

    public TimeLogger() {
        this.fAction = "";
        this.fTimeRecs = new LinkedList();
    }

    public TimeLogger(String action) {
        this.fAction = action;
    }

    public void start() {
        this.createAndAddNewRecord();
        this.fCurrentRec.fStart = System.currentTimeMillis();
    }

    public void stop() {
        this.fCurrentRec.fStop = System.currentTimeMillis();
    }

    public void reset() {
        this.fTimeRecs.clear();
    }

    public void logTimes() {
        long size = this.fTimeRecs.size();
        if (size == 0L) {
            LOG.info((Object)("No samples for " + this.fAction + " available. "));
        } else if (size == 1L) {
            LOG.info((Object)("Time elapsed for " + this.fAction + ": " + this.getLastTime()));
        } else {
            LOG.info((Object)("Timings for " + size + " samples for action " + this.fAction + ": "));
            LOG.info((Object)("  Average: " + this.getAverageTime() + "ms"));
            LOG.info((Object)("  Min    : " + this.getMinTime() + "ms"));
            LOG.info((Object)("  Max    : " + this.getMaxTime() + "ms"));
            LOG.info((Object)("  Total  : " + this.getTotalTime() + "ms"));
        }
    }

    public void printTimes() {
        long size = this.fTimeRecs.size();
        if (size == 0L) {
            System.out.println("No samples for " + this.fAction + " available. ");
        } else if (size == 1L) {
            System.out.println("Time elapsed for " + this.fAction + ": " + this.getLastTime());
        } else {
            System.out.println("Timings for " + size + " samples for action " + this.fAction + ": ");
            System.out.println("  Average: " + this.getAverageTime() + "ms");
            System.out.println("  Min    : " + this.getMinTime() + "ms");
            System.out.println("  Max    : " + this.getMaxTime() + "ms");
            System.out.println("  Total  : " + this.getTotalTime() + "ms");
        }
    }

    public long getLastTime() {
        TimeRecord lastRec = this.fTimeRecs.getLast();
        if (null != lastRec) {
            return lastRec.fStop - lastRec.fStart;
        }
        return 0L;
    }

    private void createAndAddNewRecord() {
        if (this.fTimeRecs.size() < 2500) {
            this.fCurrentRec = new TimeRecord();
            this.fTimeRecs.add(this.fCurrentRec);
        }
    }

    private long getAverageTime() {
        long sum = 0L;
        long size = this.fTimeRecs.size();
        if (0 == this.fTimeRecs.size()) {
            return 0L;
        }
        for (TimeRecord tm : this.fTimeRecs) {
            sum += tm.fStop - tm.fStart;
        }
        return (sum + size / 2L) / size;
    }

    private long getMinTime() {
        long min = Long.MAX_VALUE;
        if (0 == this.fTimeRecs.size()) {
            return 0L;
        }
        for (TimeRecord tm : this.fTimeRecs) {
            long val = tm.fStop - tm.fStart;
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    private long getMaxTime() {
        long max = Long.MIN_VALUE;
        if (0 == this.fTimeRecs.size()) {
            return 0L;
        }
        for (TimeRecord tm : this.fTimeRecs) {
            long val = tm.fStop - tm.fStart;
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    private long getTotalTime() {
        long sum = 0L;
        for (TimeRecord tm : this.fTimeRecs) {
            sum += tm.fStop - tm.fStart;
        }
        return sum;
    }

    public static void logTimes(TimeLogger[] loggers) {
        long size = 0L;
        if (null == loggers) {
            return;
        }
        for (int i = 0; i < loggers.length; ++i) {
            size += (long)loggers[i].fTimeRecs.size();
        }
        LOG.info((Object)("Timings for " + size + " samples for action " + loggers[0].fAction + ": "));
        LOG.info((Object)("  Average: " + TimeLogger.getAverageTime(loggers) + "ms"));
        LOG.info((Object)("  Min    : " + TimeLogger.getMinTime(loggers) + "ms"));
        LOG.info((Object)("  Max    : " + TimeLogger.getMaxTime(loggers) + "ms"));
        LOG.info((Object)("  Total  : " + TimeLogger.getTotalTime(loggers) + "ms"));
    }

    public static void printTimes(TimeLogger[] loggers) {
        long size = 0L;
        if (null == loggers) {
            return;
        }
        for (int i = 0; i < loggers.length; ++i) {
            size += (long)loggers[i].fTimeRecs.size();
        }
        System.out.println("Timings for " + size + " samples for action " + loggers[0].fAction + ": ");
        System.out.println("  Average: " + TimeLogger.getAverageTime(loggers) + "ms");
        System.out.println("  Min    : " + TimeLogger.getMinTime(loggers) + "ms");
        System.out.println("  Max    : " + TimeLogger.getMaxTime(loggers) + "ms");
        System.out.println("  Total  : " + TimeLogger.getTotalTime(loggers) + "ms");
    }

    private static long getAverageTime(TimeLogger[] loggers) {
        int i;
        long sum = 0L;
        long size = 0L;
        for (i = 0; i < loggers.length; ++i) {
            size += (long)loggers[i].fTimeRecs.size();
        }
        if (size == 0L) {
            return 0L;
        }
        for (i = 0; i < loggers.length; ++i) {
            if (0 == loggers[i].fTimeRecs.size()) continue;
            for (TimeRecord tm : loggers[i].fTimeRecs) {
                sum += tm.fStop - tm.fStart;
            }
        }
        return (sum + size / 2L) / size;
    }

    private static long getMaxTime(TimeLogger[] loggers) {
        long max = Long.MIN_VALUE;
        for (int i = 0; i < loggers.length; ++i) {
            long val = loggers[i].getMaxTime();
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    private static long getMinTime(TimeLogger[] loggers) {
        long min = Long.MAX_VALUE;
        for (int i = 0; i < loggers.length; ++i) {
            long val = loggers[i].getMinTime();
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    private static long getTotalTime(TimeLogger[] loggers) {
        long totalTime = Long.MIN_VALUE;
        for (int i = 0; i < loggers.length; ++i) {
            long val = loggers[i].getTotalTime();
            if (val <= totalTime) continue;
            totalTime = val;
        }
        return totalTime;
    }

    private static class TimeRecord {
        public long fStart;
        public long fStop;

        private TimeRecord() {
        }
    }
}

