/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.main;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.tools.filecopy.FileCopier;
import org.apache.chemistry.opencmis.util.repository.MultiThreadedObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.ObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjGenApp {
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjGenApp.class.getName());
    private static final String PROP_USER = "org.apache.chemistry.opencmis.user";
    private static final String PROP_PASSWORD = "org.apache.chemistry.opencmis.password";
    private static final String DEFAULT_USER = "user";
    private static final String DEFAULT_PASSWORD = "dummy";
    private static final String PROP_ATOMPUB_URL = "org.apache.chemistry.opencmis.binding.atompub.url";
    private static final String PROP_WS_URL = "org.apache.chemistry.opencmis.binding.webservices.url";
    private static final String PROP_BROWSER_URL = "org.apache.chemistry.opencmis.binding.browser.url";
    private static final String PROP_BINDING = "org.apache.chemistry.opencmis.binding.spi.type";
    private static final String PROP_CUSTOM = "org.apache.chemistry.opencmis.binding.header.";
    private static final String DEFAULT_ATOMPUB_URL = "http://localhost:8080/inmemory/atom";
    private static final String DEFAULT_WS_URL = "http://localhost:8080/inmemory/services/";
    private static final String DEFAULT_BROWSER_BINDING_URL = "http://localhost:8080/inmemory/browser/";
    private static final String DEFAULT_BINDING = "atompub";
    private static final String CMD = "Command";
    private static final String REPOSITORY_ID = "RepositoryId";
    private static final String FILLER_DOCUMENT_TYPE_ID = "DocumentTypeId";
    private static final String FILLER_FOLDER_TYPE_ID = "FolderTypeId";
    private static final String FILLER_DOCS_PER_FOLDER = "DocsPerFolder";
    private static final String FILLER_FOLDERS_PER_FOLDER = "FoldersPerFolder";
    private static final String FILLER_DEPTH = "Depth";
    private static final String FILLER_CONTENT_SIZE = "ContentSizeInKB";
    private static final String COUNT = "Count";
    private static final String CLEANUP = "Cleanup";
    private static final String ROOTFOLDER = "RootFolder";
    private static final String THREADS = "Threads";
    private static final String CONTENT_KIND = "ContentKind";
    private static final String FILE_NAME_PATTERN = "FileName";
    private static final String LOCAL_FILE = "File";
    private static final String LOCAL_DIR = "Dir";
    private static final String BINDING_ATOM = "atompub";
    private static final String BINDING_WS = "webservices";
    private static final String BINDING_BROWSER = "browser";
    BindingType fBindingType;
    private ObjectGenerator.CONTENT_KIND fContentKind;
    CmisBinding binding;
    OptionSpec<String> fCmd;
    OptionSpec<Integer> fDepth;
    OptionSpec<Integer> fContentSize;
    OptionSpec<Integer> fFolderPerFolder;
    OptionSpec<Integer> fDocsPerFolder;
    OptionSpec<String> fFolderType;
    OptionSpec<String> fDocType;
    OptionSpec<String> fRepoId;
    OptionSpec<Integer> fCount;
    OptionSpec<Boolean> fCleanup;
    OptionSpec<String> fRootFolder;
    OptionSpec<Integer> fThreads;
    OptionSpec<String> fFileName;
    OptionSpec<String> fContentKindStr;
    OptionSpec<String> fFileNamePattern;
    OptionSpec<String> fLocalDir;
    OptionSpec<String> fLocalFile;

    public static void main(String[] args) {
        ObjGenApp app = new ObjGenApp();
        try {
            app.processCmdLine(args);
        }
        catch (CmisBaseException ce) {
            System.out.println("Error: Could not process command. " + (Object)((Object)ce));
            System.out.println("Extended error: " + ce.getErrorContent());
            ce.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Could not fill repository " + e);
            e.printStackTrace();
        }
    }

    private void processCmdLine(String[] args) {
        String binding;
        OptionParser parser = new OptionParser();
        this.fCmd = parser.accepts(CMD).withRequiredArg().describedAs("Command to perform (see below)");
        this.fRepoId = parser.accepts(REPOSITORY_ID).withOptionalArg().describedAs("Repository used");
        this.fDocType = parser.accepts(FILLER_DOCUMENT_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_DOCUMENT.value(), (Object[])new String[0]).describedAs("Document type created");
        this.fFolderType = parser.accepts(FILLER_FOLDER_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_FOLDER.value(), (Object[])new String[0]).describedAs("Folder type created");
        this.fDocsPerFolder = parser.accepts(FILLER_DOCS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs("Documents on each level").defaultsTo((Object)1, (Object[])new Integer[0]);
        this.fFolderPerFolder = parser.accepts(FILLER_FOLDERS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs(" Folders on each level").defaultsTo((Object)0, (Object[])new Integer[0]);
        this.fDepth = parser.accepts(FILLER_DEPTH).withOptionalArg().ofType(Integer.class).describedAs("Levels of folders").defaultsTo((Object)1, (Object[])new Integer[0]);
        this.fContentSize = parser.accepts(FILLER_CONTENT_SIZE).withOptionalArg().ofType(Integer.class).describedAs("Content size of each doc").defaultsTo((Object)0, (Object[])new Integer[0]);
        this.fCount = parser.accepts(COUNT).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Repeat a command n times (partially implemented)");
        this.fCleanup = parser.accepts(CLEANUP).withOptionalArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("Clean all created objects at the end");
        this.fRootFolder = parser.accepts(ROOTFOLDER).withOptionalArg().ofType(String.class).describedAs("folder id used as root to create objects (default repository root folder)");
        this.fThreads = parser.accepts(THREADS).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Number of threads to start in parallel");
        this.fContentKindStr = parser.accepts(CONTENT_KIND).withOptionalArg().ofType(String.class).defaultsTo((Object)"lorem/text", (Object[])new String[0]).describedAs("kind of content: static/text, lorem/text, lorem/html, fractal/jpeg");
        this.fFileNamePattern = parser.accepts(FILE_NAME_PATTERN).withOptionalArg().ofType(String.class).defaultsTo((Object)"ContentData-%03d.bin", (Object[])new String[0]).describedAs("file name pattern to be used with CreateFiles action");
        this.fLocalDir = parser.accepts(LOCAL_DIR).withOptionalArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]).describedAs("name of a directory to be recursively copied to the repository");
        this.fLocalFile = parser.accepts(LOCAL_FILE).withOptionalArg().ofType(String.class).describedAs("file name of a file to be copied to the repository");
        OptionSet options = parser.parse(args);
        if (options.valueOf(this.fCmd) == null || options.has("?")) {
            ObjGenApp.usage(parser);
        }
        if ((binding = ObjGenApp.getBinding()).equals(BINDING_WS)) {
            this.fBindingType = BindingType.WEBSERVICES;
        } else if (binding.equals("atompub")) {
            this.fBindingType = BindingType.ATOMPUB;
        } else if (binding.equals(BINDING_BROWSER)) {
            this.fBindingType = BindingType.BROWSER;
        } else {
            System.out.println("Error: Unknown binding: " + binding + " allowed values: " + BINDING_WS + " or " + "atompub" + " or " + BINDING_BROWSER);
            return;
        }
        String kind = (String)options.valueOf(this.fContentKindStr);
        if (null == kind) {
            this.fContentKind = (Integer)options.valueOf(this.fContentSize) > 0 ? ObjectGenerator.CONTENT_KIND.StaticText : null;
        } else if (kind.equals("static/text")) {
            this.fContentKind = ObjectGenerator.CONTENT_KIND.StaticText;
        } else if (kind.equals("lorem/text")) {
            this.fContentKind = ObjectGenerator.CONTENT_KIND.LoremIpsumText;
        } else if (kind.equals("lorem/html")) {
            this.fContentKind = ObjectGenerator.CONTENT_KIND.LoremIpsumHtml;
        } else if (kind.equals("fractal/jpeg")) {
            this.fContentKind = ObjectGenerator.CONTENT_KIND.ImageFractalJpeg;
        } else {
            System.out.println("Unknown content kind: " + (String)options.valueOf(this.fContentKindStr));
            System.out.println("  must be one of static/text, lorem/text, lorem/html, fractal/jpeg");
            ObjGenApp.usage(parser);
        }
        if (null == options.valueOf(this.fCmd)) {
            System.out.println("No command given.");
            ObjGenApp.usage(parser);
        } else if (((String)options.valueOf(this.fCmd)).equals("FillRepository")) {
            this.fillRepository(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CreateDocument")) {
            this.createSingleDocument(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CreateFolder")) {
            this.createFolders(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("RepositoryInfo")) {
            this.repositoryInfo(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CreateFiles")) {
            this.createFiles(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CopyFiles")) {
            this.transferFiles(options);
        } else if (((String)options.valueOf(this.fCmd)).equals("CopyFilesTest")) {
            this.transferFilesTest(options);
        } else {
            System.out.println("Unknown cmd: " + (String)options.valueOf(this.fCmd));
            ObjGenApp.usage(parser);
        }
    }

    private static void usage(OptionParser parser) {
        try {
            System.out.println();
            System.out.println("ObjGenApp is a command line tool for testing a CMIS repository.");
            System.out.println("Usage:");
            parser.printHelpOn((OutputStream)System.out);
            System.out.println();
            System.out.println("Command is one of [CreateDocument, CreateFolder, FillRepository, RepositoryInfo, CreateFiles, CopyFiles, CopyFilesTest]");
            System.out.println("JVM system properties: org.apache.chemistry.opencmis.binding.atompub.url, org.apache.chemistry.opencmis.binding.webservices.url, org.apache.chemistry.opencmis.binding.browser.url");
            System.out.println("                       org.apache.chemistry.opencmis.user, org.apache.chemistry.opencmis.password");
            System.out.println();
            System.out.println("Example: ");
            System.out.println("java -Dorg.apache.chemistry.opencmis.binding.atompub.url=http://localhost:8080/opencmis/atom -cp ... org.apache.chemistry.opencmis.util.repository.ObjGenApp --Binding=AtomPub --Command=CreateDocument --RepositoryId=A1 --ContentSizeInKB=25 --ContentKind=lorem/text");
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void fillRepository(String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateTree((CmisBinding)this.getClientBindings(), (String)repoId, (int)docsPerFolder, (int)foldersPerFolders, (int)depth, (String)documentType, (String)folderType, (int)contentSizeInKB, (String)rootFolderId, (ObjectGenerator.CONTENT_KIND)this.fContentKind, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        runner.doCreateTree();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Filling repository succeeded.");
        System.out.println("Folder used as root for creation (null=rootFolderId): " + rootFolderId);
        System.out.println("Number of documents created: " + gen.getDocumentsInTotal());
        System.out.println("Number of folders created: " + gen.getFoldersInTotal());
        gen.printTimings();
    }

    private void fillRepositoryMT(int noThreads, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder((CmisBinding)this.getClientBindings(), (String)repoId, (String)folderType, (String)rootFolderId, (int)noThreads, (boolean)doCleanup);
        String[] folderIds = runner.doCreateFolder();
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateTreeMT((CmisBinding)this.getClientBindings(), (String)repoId, (int)docsPerFolder, (int)foldersPerFolders, (int)depth, (String)documentType, (String)folderType, (int)contentSizeInKB, (String[])folderIds, (ObjectGenerator.CONTENT_KIND)this.fContentKind, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Filling repository succeeded.");
    }

    private void printParameters(OptionSet options) {
        if (this.fBindingType == BindingType.ATOMPUB) {
            System.out.println("Using AtomPub, connecting to  " + ObjGenApp.getAtomPubUrl());
        } else if (this.fBindingType == BindingType.WEBSERVICES) {
            System.out.println("Using WebService, connecting to  " + ObjGenApp.getWsUrl());
        } else if (this.fBindingType == BindingType.BROWSER) {
            System.out.println("Using Browser binding, connecting to  " + ObjGenApp.getBrowserUrl());
        } else {
            System.out.println("Unknown binding type.");
        }
        System.out.println("Repository id is: " + (String)options.valueOf(this.fRepoId));
        System.out.println("Content size: " + options.valueOf(this.fContentSize));
        System.out.println("Document Type: " + (String)options.valueOf(this.fDocType));
        System.out.println("Folder id used as root: " + (String)options.valueOf(this.fRootFolder));
        System.out.println("Delete all objects after creation: " + options.valueOf(this.fCleanup));
        System.out.println("Number of actions to perform: " + options.valueOf(this.fCount));
        System.out.println("Number of threads to start: " + options.valueOf(this.fThreads));
        System.out.println("Kind of created content: " + (String)options.valueOf(this.fContentKindStr));
    }

    private void createSingleDocument(OptionSet options) {
        System.out.println();
        System.out.println("Creating document with parameters:");
        this.printParameters(options);
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.createSingleDocument((String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fDocType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.createSingleDocumentMT(noThreads, (String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fDocType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void fillRepository(OptionSet options) {
        System.out.println();
        this.printParameters(options);
        System.out.println("Creating object tree with folowing parameters: ");
        System.out.println("Documents per folder: " + options.valueOf(this.fDocsPerFolder));
        System.out.println("Folder per folder: " + options.valueOf(this.fFolderPerFolder));
        System.out.println("Depth: " + options.valueOf(this.fDepth));
        System.out.println("Folder Type: " + (String)options.valueOf(this.fFolderType));
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.fillRepository((String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fDocsPerFolder), (Integer)options.valueOf(this.fFolderPerFolder), (Integer)options.valueOf(this.fDepth), (String)options.valueOf(this.fDocType), (String)options.valueOf(this.fFolderType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.fillRepositoryMT(noThreads, (String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fDocsPerFolder), (Integer)options.valueOf(this.fFolderPerFolder), (Integer)options.valueOf(this.fDepth), (String)options.valueOf(this.fDocType), (String)options.valueOf(this.fFolderType), (Integer)options.valueOf(this.fContentSize), (String)options.valueOf(this.fRootFolder), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void createFolders(OptionSet options) {
        System.out.println();
        System.out.println("Creating folder with parameters:");
        this.printParameters(options);
        System.out.println("Folder Type: " + (String)options.valueOf(this.fFolderType));
        int noThreads = (Integer)options.valueOf(this.fThreads);
        if (noThreads <= 1) {
            this.createFolders((String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fFolderType), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        } else {
            this.createFoldersMT(noThreads, (String)options.valueOf(this.fRepoId), (String)options.valueOf(this.fFolderType), (String)options.valueOf(this.fRootFolder), (Integer)options.valueOf(this.fCount), (Boolean)options.valueOf(this.fCleanup));
        }
    }

    private void createSingleDocument(String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateDocument((CmisBinding)this.getClientBindings(), (String)repoId, (String)documentType, (int)contentSizeInKB, (String)rootFolderId, (int)docCount, (ObjectGenerator.CONTENT_KIND)this.fContentKind, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateDocument();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Document creation succeeded.");
        System.out.println("Folder used as root for creation: " + rootFolderId);
        System.out.println("Ids of created documents: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createSingleDocumentMT(int noThreads, String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateDocumentMT((int)noThreads, (CmisBinding)this.getClientBindings(), (String)repoId, (String)documentType, (int)contentSizeInKB, (String)rootFolderId, (int)docCount, (ObjectGenerator.CONTENT_KIND)this.fContentKind, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Document creation succeeded. All threads terminated.");
    }

    private void createFolders(String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder((CmisBinding)this.getClientBindings(), (String)repoId, (String)folderType, (String)rootFolderId, (int)noFolders, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateFolder();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Folder creation succeeded.");
        System.out.println("Ids of created folders: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createFoldersMT(int noThreads, String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateFolderMT((int)noThreads, (CmisBinding)this.getClientBindings(), (String)repoId, (String)folderType, (String)rootFolderId, (int)noFolders, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Folder creation succeeded.");
    }

    private void callRepoInfo(String repositoryId, int count) {
        RepositoryService repSvc = this.getClientBindings().getRepositoryService();
        TimeLogger timeLogger = new TimeLogger("RepoInfoTest");
        RepositoryInfo repoInfo = null;
        for (int i = 0; i < count; ++i) {
            this.binding.clearRepositoryCache(repositoryId);
            timeLogger.start();
            repoInfo = repSvc.getRepositoryInfo(repositoryId, null);
            timeLogger.stop();
        }
        System.out.println("Root Folder id is: " + (repoInfo == null ? "<unknown>" : repoInfo.getRootFolderId()));
        timeLogger.printTimes();
    }

    private void createTypes(OptionSet options) {
        String repoId = (String)options.valueOf(this.fRepoId);
        String fileName = (String)options.valueOf(this.fFileName);
        System.out.println();
        System.out.println("Not yet implemented waiting for CMIS 1.1!");
    }

    private void repositoryInfo(OptionSet options) {
        this.callRepoInfo((String)options.valueOf(this.fRepoId), (Integer)options.valueOf(this.fCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(OptionSet options) {
        ContentStream contentStream = null;
        String fileNamePattern = (String)options.valueOf(this.fFileNamePattern);
        int count = (Integer)options.valueOf(this.fCount);
        int contentSize = (Integer)options.valueOf(this.fContentSize);
        System.out.println("Creating local files with content: ");
        System.out.println("Kind: " + options.valueOf(this.fDocsPerFolder));
        System.out.println("Number of files: " + count);
        System.out.println("File name pattern: " + fileNamePattern);
        System.out.println("Kind of content: " + (String)options.valueOf(this.fContentKindStr));
        System.out.println("Size of content (text only): " + contentSize);
        ObjectGenerator objGen = new ObjectGenerator(null, null, null, null, null, this.fContentKind);
        objGen.setContentSizeInKB(contentSize);
        InputStream is = null;
        FileOutputStream os = null;
        try {
            for (int i = 0; i < count; ++i) {
                int read;
                String fileName = String.format(fileNamePattern, i);
                System.out.println("Generating file: " + fileName);
                if (contentSize > 0) {
                    switch (this.fContentKind) {
                        case StaticText: {
                            contentStream = objGen.createContentStaticText();
                            break;
                        }
                        case LoremIpsumText: {
                            contentStream = objGen.createContentLoremIpsumText();
                            break;
                        }
                        case LoremIpsumHtml: {
                            contentStream = objGen.createContentLoremIpsumHtml();
                            break;
                        }
                        case ImageFractalJpeg: {
                            contentStream = objGen.createContentFractalimageJpeg();
                        }
                    }
                }
                is = contentStream.getStream();
                os = new FileOutputStream(fileName);
                byte[] b = new byte[65536];
                while ((read = is.read(b)) != -1) {
                    os.write(b, 0, read);
                }
                is.close();
                is = null;
                os.close();
                os = null;
            }
        }
        catch (Exception e) {
            System.err.println("Error generating file: " + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void transferFiles(OptionSet options) {
        String fileName = (String)options.valueOf(this.fLocalFile);
        String dirName = (String)options.valueOf(this.fLocalDir);
        String repoId = (String)options.valueOf(this.fRepoId);
        String folderId = (String)options.valueOf(this.fRootFolder);
        String name = fileName;
        if (!(null != fileName && fileName.length() != 0 || null != dirName && dirName.length() != 0)) {
            System.out.println("Error: You either have to provide a --file or a --dir option to copy file(s).");
            return;
        }
        if (null == name || name.length() == 0) {
            name = dirName;
        }
        if (null == repoId || repoId.length() == 0) {
            System.out.println("Error: You have to provide a repository id");
            return;
        }
        System.out.println("Copying files to a repository: ");
        System.out.println("Repository id is: " + repoId);
        System.out.println("Folder id used as root: " + (String)options.valueOf(this.fRootFolder));
        Map<String, String> parameters = this.getConnectionParameters(ObjGenApp.getBinding(), repoId);
        FileCopier fc = new FileCopier();
        fc.connect(parameters);
        fc.copyRecursive(name, folderId);
    }

    private void transferFilesTest(OptionSet options) {
        String fileName = (String)options.valueOf(this.fLocalFile);
        if (null == fileName || fileName.length() == 0) {
            System.out.println("Error: You have to provide a --file option to test metadata extraction.");
            return;
        }
        System.out.println("Testing metadata extraction: ");
        FileCopier fc = new FileCopier();
        fc.listMetadata(fileName);
    }

    private Map<String, String> getConnectionParameters(String binding, String repoId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoId);
        parameters.put(PROP_BINDING, binding);
        if (binding.equals(BindingType.ATOMPUB.value())) {
            parameters.put(PROP_ATOMPUB_URL, ObjGenApp.getAtomPubUrl());
            ObjGenApp.filLoginParams(parameters, ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else if (binding.equals(BindingType.WEBSERVICES.value())) {
            ObjGenApp.fillWSParameters(parameters, ObjGenApp.getWsUrl(), ObjGenApp.isPrefix(ObjGenApp.getWsUrl()), ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else if (binding.equals(BindingType.BROWSER.value())) {
            parameters.put(PROP_BROWSER_URL, ObjGenApp.getBrowserUrl());
            ObjGenApp.filLoginParams(parameters, ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else {
            System.out.println("Error unknown binding: " + binding);
        }
        ObjGenApp.fillCustomHeaders(parameters);
        return parameters;
    }

    private CmisBinding getClientBindings() {
        if (this.binding == null) {
            if (this.fBindingType == BindingType.ATOMPUB) {
                this.binding = ObjGenApp.createAtomBinding(ObjGenApp.getAtomPubUrl(), ObjGenApp.getUser(), ObjGenApp.getPassword());
            }
            if (this.fBindingType == BindingType.WEBSERVICES) {
                String url = ObjGenApp.getWsUrl();
                this.binding = ObjGenApp.createWSBinding(url, ObjGenApp.isPrefix(url), ObjGenApp.getUser(), ObjGenApp.getPassword());
            } else if (this.fBindingType == BindingType.BROWSER) {
                this.binding = ObjGenApp.createBrowserBinding(ObjGenApp.getBrowserUrl(), ObjGenApp.getUser(), ObjGenApp.getPassword());
            }
        }
        return this.binding;
    }

    private static void filLoginParams(Map<String, String> parameters, String user, String password) {
        if (user != null && user.length() > 0) {
            parameters.put(PROP_USER, user);
        }
        if (user != null && user.length() > 0) {
            parameters.put(PROP_PASSWORD, password);
        }
    }

    private static void fillCustomHeaders(Map<String, String> parameters) {
        Map<String, String> customHeaders = ObjGenApp.getCustomHeaders();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            parameters.put(entry.getKey(), entry.getValue());
        }
    }

    private static CmisBinding createAtomBinding(String url, String user, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.filLoginParams(parameters, user, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        parameters.put(PROP_ATOMPUB_URL, url);
        CmisBinding binding = factory.createCmisAtomPubBinding(parameters);
        return binding;
    }

    private static CmisBinding createBrowserBinding(String url, String user, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.filLoginParams(parameters, user, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        parameters.put(PROP_BROWSER_URL, url);
        CmisBinding binding = factory.createCmisBrowserBinding(parameters);
        return binding;
    }

    private static boolean isPrefix(String url) {
        boolean isPrefix = true;
        String urlLower = url.toLowerCase();
        if (urlLower.endsWith("?wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".xml")) {
            isPrefix = false;
        }
        return isPrefix;
    }

    public static CmisBinding createWSBinding(String url, boolean isPrefix, String username, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.fillWSParameters(parameters, url, isPrefix, username, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisWebServicesBinding(parameters);
        return binding;
    }

    public static void fillWSParameters(Map<String, String> parameters, String url, boolean isPrefix, String username, String password) {
        parameters.put(PROP_USER, username);
        parameters.put(PROP_PASSWORD, password);
        if (!isPrefix) {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url + "VersioningService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url + "ACLService?wsdl");
        }
    }

    private static String getBinding() {
        return System.getProperty(PROP_BINDING, "atompub");
    }

    private static String getAtomPubUrl() {
        return System.getProperty(PROP_ATOMPUB_URL, DEFAULT_ATOMPUB_URL);
    }

    private static String getWsUrl() {
        return System.getProperty(PROP_WS_URL, DEFAULT_WS_URL);
    }

    private static String getBrowserUrl() {
        return System.getProperty(PROP_BROWSER_URL, DEFAULT_BROWSER_BINDING_URL);
    }

    private static String getUser() {
        return System.getProperty(PROP_USER, DEFAULT_USER);
    }

    private static String getPassword() {
        return System.getProperty(PROP_PASSWORD, DEFAULT_PASSWORD);
    }

    private static Map<String, String> getCustomHeaders() {
        String val;
        int i = 0;
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        while (null != (val = System.getProperty(PROP_CUSTOM + i, null))) {
            customHeaders.put(PROP_CUSTOM + i++, val);
        }
        return customHeaders;
    }

    private static void getUrl(String urlStr) {
        try {
            String str;
            System.out.println("Reading URL: " + urlStr);
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader r = new BufferedReader(isr);
            do {
                if ((str = r.readLine()) == null) continue;
                System.out.println(str);
            } while (str != null);
        }
        catch (MalformedURLException e) {
            System.out.println("Must enter a valid URL" + e);
        }
        catch (IOException e) {
            System.out.println("Can not connect" + e);
        }
    }
}

