/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commander;

import java.io.PrintWriter;
import org.apache.chemistry.opencmis.commander.Command;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class DeleteCommand
implements Command {
    public String getCommandName() {
        return "delete";
    }

    public String getUsage() {
        return "DELETE <repository id> <object id> [all versions: true/false]";
    }

    public void execute(CmisBinding binding, String[] args, PrintWriter output) {
        if (args.length < 2) {
            output.println(this.getUsage());
            return;
        }
        String repositoryId = args[0];
        String objectId = args[1];
        Boolean allVersions = args.length > 2 ? Boolean.valueOf(args[2]) : null;
        output.println("Deleting " + objectId + " ...");
        output.flush();
        binding.getObjectService().deleteObject(repositoryId, objectId, allVersions, null);
        output.println("done.");
    }
}

