/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.tools.mapper.MapperException;
import org.apache.chemistry.opencmis.tools.parser.AbstractMetadataParser;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataParserTika
extends AbstractMetadataParser {
    private static final Logger LOG = LoggerFactory.getLogger((String)MetadataParserTika.class.getName());

    @Override
    public void extractMetadata(File f, TypeDefinition td, Session session) throws MapperException {
        try {
            FileInputStream stream = new FileInputStream(f);
            Metadata metadata = new Metadata();
            DefaultHandler handler = new DefaultHandler();
            AutoDetectParser parser = new AutoDetectParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
            this.reset();
            for (String key : metadata.names()) {
                String propertyId;
                String val = metadata.get(key);
                LOG.debug("Found metadata '" + key + "': " + val);
                if (null == this.cmisProperties || null == (propertyId = this.mapper.getMappedPropertyId(key)) || null == val) continue;
                if (td != null) {
                    PropertyDefinition<?> propDef = this.getMappedPropertyDefinition(td.getId(), propertyId, session);
                    Object convVal = this.mapper.convertValue(propertyId, propDef, val);
                    if (null == convVal) continue;
                    this.cmisProperties.put(propertyId, convVal);
                    continue;
                }
                this.cmisProperties.put(propertyId, val);
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new MapperException("Extracting metadata failed for file " + f.getAbsolutePath(), e);
        }
    }

    private PropertyDefinition<?> getMappedPropertyDefinition(String typeId, String propertyId, Session session) throws MapperException {
        String typeIdMod = typeId;
        while (null != typeIdMod) {
            ObjectType td = session.getTypeDefinition(typeIdMod);
            PropertyDefinition propDef = (PropertyDefinition)td.getPropertyDefinitions().get(propertyId);
            if (null != propDef) {
                return propDef;
            }
            typeIdMod = td.getParentTypeId();
        }
        throw new MapperException("Mapping error: unknown property " + propertyId + " in type definition " + typeId);
    }

    public void listMetadata(File f) throws MapperException {
        try {
            FileInputStream stream = new FileInputStream(f);
            Metadata metadata = new Metadata();
            DefaultHandler handler = new DefaultHandler();
            AutoDetectParser parser = new AutoDetectParser();
            ParseContext context = new ParseContext();
            parser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
            for (String key : metadata.names()) {
                String val = metadata.get(key);
                LOG.info("Found metadata '" + key + "': " + val);
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new MapperException("Extracting metadata failed, file not found: " + f.getAbsolutePath(), e);
        }
    }
}

