/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.parser;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.tools.mapper.MapperException;
import org.apache.chemistry.opencmis.tools.mapper.PropertyMapperExif;
import org.apache.chemistry.opencmis.tools.parser.AbstractMetadataParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataParserExif
extends AbstractMetadataParser {
    private static final Logger LOG = LoggerFactory.getLogger((String)MetadataParserExif.class.getName());

    @Override
    public void extractMetadata(File f, TypeDefinition td, Session session) throws MapperException {
        this.reset();
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)f);
            Iterator it = metadata.getDirectoryIterator();
            while (it.hasNext()) {
                Directory directory = (Directory)it.next();
                Iterator tagIt = directory.getTagIterator();
                while (tagIt.hasNext()) {
                    Tag tag = (Tag)tagIt.next();
                    Object o = directory.getObject(tag.getTagType());
                    LOG.debug("Tag: " + tag + ", value: " + o + ", class: " + o.getClass() + ", tag type: " + tag.getTagType() + ", hex-value: " + tag.getTagTypeHex());
                    if (null == this.cmisProperties) continue;
                    ((PropertyMapperExif)this.mapper).mapTagAndConvert(directory, tag, td);
                }
            }
            Map<String, Object> props = ((PropertyMapperExif)this.mapper).getMappedProperties();
            this.cmisProperties.putAll(props);
        }
        catch (ImageProcessingException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
    }
}

