/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.mapper;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.tools.mapper.AbstractPropertyMapper;
import org.apache.chemistry.opencmis.tools.mapper.MapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapperTika
extends AbstractPropertyMapper {
    private static final Logger LOG = LoggerFactory.getLogger((String)PropertyMapperTika.class.getName());
    private Map<String, String> propMapTags = new HashMap<String, String>();
    private Map<String, String> tokenizerMap = new HashMap<String, String>();

    @Override
    public boolean initialize(String cfgPrefix, String typeKey, Properties properties) {
        super.initialize(cfgPrefix, typeKey, properties);
        this.buildIdMap(typeKey, properties);
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getMappedPropertyId(String key) {
        String propId = this.propMapTags.get(key);
        return propId;
    }

    @Override
    public Object convertValue(String key, PropertyDefinition<?> propDef, String strValueParam) {
        String strValue = strValueParam;
        ArrayList<String> value = null;
        PropertyType pt = propDef.getPropertyType();
        if (null == pt) {
            value = null;
        } else if (null != strValue && strValue.length() > 0) {
            int lastIllegalPos = -1;
            for (int i = 0; i < strValue.length(); ++i) {
                int c = strValue.codePointAt(i);
                if (!Character.isISOControl(c)) continue;
                lastIllegalPos = i;
            }
            if (lastIllegalPos >= 0) {
                strValue = strValue.substring(lastIllegalPos + 1);
            }
            switch (pt) {
                case STRING: 
                case HTML: 
                case URI: 
                case ID: {
                    if (propDef.getCardinality() == Cardinality.SINGLE) {
                        value = strValue;
                        break;
                    }
                    String tokenizer = this.tokenizerMap.containsKey(key) ? this.tokenizerMap.get(key) : "\\W";
                    String[] result = strValue.split(tokenizer);
                    ArrayList<String> valList = new ArrayList<String>();
                    for (String s : result) {
                        valList.add(s.trim());
                    }
                    value = valList;
                    break;
                }
                case INTEGER: {
                    if (propDef.getCardinality() == Cardinality.SINGLE) {
                        value = Integer.valueOf(strValue);
                        break;
                    }
                    String tokenizer = this.tokenizerMap.containsKey(key) ? this.tokenizerMap.get(key) : "\\W";
                    String[] result = strValue.split(tokenizer);
                    ArrayList<Integer> valList = new ArrayList<Integer>();
                    for (String s : result) {
                        valList.add(Integer.valueOf(s.trim()));
                    }
                    value = valList;
                    break;
                }
                case DECIMAL: {
                    if (propDef.getCardinality() == Cardinality.SINGLE) {
                        value = Double.valueOf(strValue);
                        break;
                    }
                    String tokenizer = this.tokenizerMap.containsKey(key) ? this.tokenizerMap.get(key) : "[\\s;:]";
                    String[] result = strValue.split(tokenizer);
                    ArrayList<Double> valList = new ArrayList<Double>();
                    for (String s : result) {
                        valList.add(Double.valueOf(s.trim()));
                    }
                    value = valList;
                    break;
                }
                case DATETIME: {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat, new DateFormatSymbols(Locale.US));
                        if (propDef.getCardinality() == Cardinality.SINGLE) {
                            Date date = sdf.parse(strValue);
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(date);
                            value = date;
                            break;
                        }
                        String tokenizer = this.tokenizerMap.containsKey(key) ? this.tokenizerMap.get(key) : "[;,:]";
                        String[] result = strValue.split(tokenizer);
                        ArrayList<GregorianCalendar> valList = new ArrayList<GregorianCalendar>();
                        for (String s : result) {
                            Date date = sdf.parse(s.trim());
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(date);
                            valList.add(cal);
                        }
                        value = valList;
                    }
                    catch (ParseException e) {
                        LOG.error("Could not parse date: " + strValue + " (check date format");
                        LOG.error(e.toString(), (Throwable)e);
                        value = null;
                    }
                    break;
                }
                default: {
                    throw new MapperException("unknown property type " + pt);
                }
            }
        }
        return value;
    }

    void buildIdMap(String typeKey, Properties properties) {
        Set<String> keys = properties.stringPropertyNames();
        String prefix = this.propPrefix + ".id.";
        String tokenizerPrefix = this.propPrefix + ".tokenizer.";
        for (String key : keys) {
            String id;
            if (key.startsWith(prefix)) {
                id = key.substring(prefix.length());
                String cmisPropId = properties.getProperty(key);
                if (null == cmisPropId) {
                    throw new MapperException("Configuration key " + key + " must have a value assigned");
                }
                cmisPropId = cmisPropId.trim();
                LOG.debug("Found mapping for type " + typeKey + " with " + id + " to " + cmisPropId);
                this.propMapTags.put(id, cmisPropId);
            }
            if (!key.startsWith(tokenizerPrefix)) continue;
            id = key.substring(tokenizerPrefix.length());
            String regex = properties.getProperty(key);
            if (null == regex) {
                throw new MapperException("Configuration key " + key + " must have a value assigned");
            }
            regex = regex.trim();
            LOG.debug("Found tokenizer mapping for property " + id + " to " + regex);
            this.tokenizerMap.put(id, regex);
        }
    }

    int getSize() {
        return this.propMapTags.size();
    }
}

