/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.mapper;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.tools.mapper.AbstractPropertyMapper;
import org.apache.chemistry.opencmis.tools.mapper.MapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapperExif
extends AbstractPropertyMapper {
    private static final int SECS_PER_HOUR = 3600;
    private static final int SECS_PER_MINUTE = 60;
    private static final Logger LOG = LoggerFactory.getLogger((String)PropertyMapperExif.class.getName());
    private static final String EXIF_DATE_FORMAT = "yyyy:MM:dd HH:mm:ss";
    private Map<String, String> propMapExif = new HashMap<String, String>();
    private Map<String, String> propMapGps = new HashMap<String, String>();
    private Map<String, String> propMapJpeg = new HashMap<String, String>();
    protected Map<String, Object> propMap;

    @Override
    public boolean initialize(String cfgPrefix, String typeKey, Properties properties) {
        super.initialize(cfgPrefix, typeKey, properties);
        this.reset();
        this.dateFormat = EXIF_DATE_FORMAT;
        this.buildIdMap("exif", this.propMapExif, properties);
        this.buildIdMap("gps", this.propMapGps, properties);
        this.buildIdMap("jpeg", this.propMapJpeg, properties);
        return true;
    }

    @Override
    public void reset() {
        this.propMap = new HashMap<String, Object>();
    }

    public Map<String, Object> getMappedProperties() {
        return this.propMap;
    }

    private void buildIdMap(String dirKey, Map<String, String> propMap, Properties properties) {
        Set<String> keys = properties.stringPropertyNames();
        String prefix = this.propPrefix + "." + dirKey + ".id.";
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            String id = key.substring(prefix.length());
            String cmisPropId = properties.getProperty(key);
            if (null == cmisPropId) {
                throw new MapperException("Configuration key " + key + " must have a value assigned");
            }
            cmisPropId = cmisPropId.trim();
            LOG.debug("Found mapping for type " + dirKey + " with " + id + " to " + cmisPropId);
            propMap.put(id, cmisPropId);
        }
    }

    public String getMappedTypeId(String mimeType) {
        return this.cmisTypeId;
    }

    @Override
    public String getMappedPropertyId(String key) {
        return null;
    }

    @Override
    public Object convertValue(String id, PropertyDefinition<?> propDef, String strValue) {
        return null;
    }

    private String getHexString(int tagType) {
        StringBuffer hexStr = new StringBuffer();
        hexStr.append(Integer.toHexString(tagType));
        while (hexStr.length() < 4) {
            hexStr.insert(0, "0");
        }
        hexStr.insert(0, "0x");
        return hexStr.toString();
    }

    public void mapTagAndConvert(Directory dir, Tag tag, TypeDefinition td) {
        String propId = null;
        String hexStr = this.getHexString(tag.getTagType());
        propId = GpsDirectory.class.equals(dir.getClass()) ? this.propMapGps.get(hexStr) : (ExifDirectory.class.equals(dir.getClass()) ? this.propMapExif.get(hexStr) : (JpegDirectory.class.equals(dir.getClass()) ? this.propMapJpeg.get(hexStr) : null));
        if (null != propId) {
            if (null != td) {
                PropertyDefinition pd = (PropertyDefinition)td.getPropertyDefinitions().get(propId);
                if (null == pd) {
                    throw new MapperException("Unknown property id " + propId + " in type definition " + td.getId());
                }
                PropertyType pt = pd.getPropertyType();
                Object convValue = this.convertValue(dir, tag, pt);
                this.propMap.put(propId, convValue);
            } else {
                this.propMap.put(propId, dir.getObject(tag.getTagType()));
            }
        }
    }

    public Object convertValue(Directory dir, Tag tag, PropertyType propType) {
        Object res = null;
        String hexStr = this.getHexString(tag.getTagType());
        if (GpsDirectory.class.equals(dir.getClass())) {
            if (4 == tag.getTagType()) {
                Object ref = dir.getObject(3);
                boolean mustInv = ref != null && ref.equals("W");
                return PropertyMapperExif.convertGps(tag, dir, mustInv);
            }
            if (2 == tag.getTagType()) {
                Object ref = dir.getObject(3);
                boolean mustInv = ref != null && ref.equals("S");
                return PropertyMapperExif.convertGps(tag, dir, mustInv);
            }
            String propId = this.propMapGps.get(hexStr);
            LOG.debug("Found GPS tag '" + tag + "', property mapped is: " + propId);
            if (null == propId) {
                LOG.info("Ignoring EXIF tag '" + tag + "' no property mapped to this tag.");
            } else if (propType == null) {
                LOG.error("Ignoring EXIF tag '" + tag + "' no property type mapped to this tag.");
            }
            Object src = dir.getObject(tag.getTagType());
            Class<?> clazz = src.getClass();
            if (clazz.equals(Rational.class)) {
                if (propType != PropertyType.DECIMAL) {
                    throw new MapperException("Tag value has type Rational and expected CMIS Decimal, but found: " + propType + " for tag: " + tag);
                }
                double d = ((Rational)src).doubleValue();
                res = d;
            } else if (clazz.equals(String.class)) {
                if (propType != PropertyType.STRING && propType != PropertyType.ID && propType != PropertyType.URI && propType != PropertyType.HTML && propType != PropertyType.DATETIME) {
                    throw new MapperException("Tag value has type String and expected CMIS String, but found: " + propType + " for tag: " + tag);
                }
                String s = (String)src;
                res = s;
            } else {
                res = null;
            }
        } else if (ExifDirectory.class.equals(dir.getClass())) {
            String propId = this.propMapExif.get(hexStr);
            LOG.debug("Found EXIF tag '" + tag + "', property mapped is: " + propId);
            if (null == propId) {
                LOG.debug("Ignoring EXIF tag '" + tag + "' no property mapped to this tag.");
            } else if (propType == null) {
                LOG.error("Ignoring EXIF tag '" + tag + "' no property type mapped to this tag.");
            } else {
                Object src = dir.getObject(tag.getTagType());
                Class<?> clazz = src.getClass();
                if (clazz.isArray()) {
                    LOG.error("Found a multi-value tag " + tag + ": multi value not implemented");
                    return null;
                }
                if (clazz.equals(Rational.class)) {
                    if (propType != PropertyType.DECIMAL) {
                        throw new MapperException("Tag value has type Rational and expected CMIS Decimal, but found: " + propType + " for tag: " + tag);
                    }
                    if (tag.getTagType() == 37377) {
                        double apexValue = ((Rational)src).doubleValue();
                        res = PhotographicConversions.shutterSpeedToExposureTime((double)apexValue);
                    } else if (tag.getTagType() == 37378) {
                        double aperture = ((Rational)src).doubleValue();
                        double fStop = PhotographicConversions.apertureToFStop((double)aperture);
                        res = fStop;
                    } else {
                        double d = ((Rational)src).doubleValue();
                        res = d;
                    }
                } else if (clazz.equals(Integer.class)) {
                    if (propType != PropertyType.INTEGER) {
                        throw new MapperException("Tag value has type Integer and expected CMIS Integer, but found: " + propType + " for tag: " + tag);
                    }
                    long l = ((Integer)src).longValue();
                    res = l;
                } else if (clazz.equals(String.class)) {
                    if (propType != PropertyType.STRING && propType != PropertyType.ID && propType != PropertyType.URI && propType != PropertyType.HTML && propType != PropertyType.DATETIME) {
                        throw new MapperException("Tag value has type String and expected CMIS String, but found: " + propType + " for tag: " + tag);
                    }
                    if (propType == PropertyType.DATETIME) {
                        GregorianCalendar cal;
                        SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
                        try {
                            Date date = formatter.parse((String)src);
                            cal = new GregorianCalendar();
                            cal.setTime(date);
                        }
                        catch (ParseException e) {
                            LOG.error(e.toString(), (Throwable)e);
                            throw new MapperException("Unrecognized date format in EXIF date tag: " + src + " for tag: " + tag + " expected: yyyy:MM:dd HH:mm:ss", e);
                        }
                        res = cal;
                    } else {
                        String s = (String)src;
                        res = s;
                    }
                } else if (clazz.equals(Date.class)) {
                    if (propType != PropertyType.DATETIME) {
                        throw new MapperException("Tag value has type Date and expected CMIS DateTime, but found: " + propType + " for tag: " + tag);
                    }
                    Date date = (Date)src;
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    res = cal;
                } else if (clazz.equals(Boolean.class)) {
                    if (propType != PropertyType.BOOLEAN) {
                        throw new MapperException("Tag value has type Boolean and expected CMIS Boolean, but found: " + propType + " for tag: " + tag);
                    }
                    Boolean b = (Boolean)src;
                    res = b;
                } else {
                    LOG.debug("Tag value has unsupported type: " + clazz.getName() + " for EXIF tag: " + tag);
                }
            }
        } else if (JpegDirectory.class.equals(dir.getClass())) {
            String propId = this.propMapJpeg.get(hexStr);
            LOG.debug("Found JPEG tag '" + tag + "', property mapped is: " + propId);
            if (null == propId) {
                LOG.info("Ignoring JPEG tag '" + tag + "' no property mapped to this tag.");
            } else if (propType == null) {
                LOG.error("Ignoring JPEG tag '" + tag + "' no property type mapped to this tag.");
            } else {
                Object src = dir.getObject(tag.getTagType());
                Class<?> clazz = src.getClass();
                if (clazz.equals(Integer.class)) {
                    if (propType != PropertyType.INTEGER) {
                        throw new MapperException("Tag value has type Integer and expected CMIS Integer, but found: " + propType + " for tag: " + tag);
                    }
                    long l = ((Integer)src).longValue();
                    res = l;
                } else {
                    LOG.debug("Tag value has unsupported type: " + clazz.getName() + " for JPEG tag: " + tag);
                }
            }
        }
        return res;
    }

    private static Object convertGps(Tag tag, Directory dir, boolean mustInvert) {
        double sec;
        double min;
        Double res = null;
        Object src = dir.getObject(tag.getTagType());
        Class<?> stringArrayClass = src.getClass();
        Class<?> stringArrayComponentType = stringArrayClass.getComponentType();
        if (!stringArrayClass.isArray() || null == stringArrayComponentType || Array.getLength(src) != 3) {
            throw new MapperException("GPS coordinate \"" + tag + "\" has unknown type.");
        }
        if (!stringArrayComponentType.equals(Rational.class)) {
            throw new MapperException("GPS coordinate \"" + tag + "\" has unknown component type (expected Rational, found: " + stringArrayComponentType.getName() + ")");
        }
        Rational[] components = (Rational[])src;
        int deg = components[0].intValue();
        Double d = (double)deg + (min = components[1].doubleValue()) / 60.0 + (sec = components[2].doubleValue()) / 3600.0;
        if (d > 0.0 && mustInvert) {
            d = -d.doubleValue();
        }
        res = d;
        return res;
    }
}

