/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tools.main;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.tools.filecopy.FileCopier;
import org.apache.chemistry.opencmis.util.repository.MultiThreadedObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.ObjectGenerator;
import org.apache.chemistry.opencmis.util.repository.TimeLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjGenApp {
    private static final int BUFSIZE = 65536;
    private static final String PROP_USER = "org.apache.chemistry.opencmis.user";
    private static final String PROP_PASSWORD = "org.apache.chemistry.opencmis.password";
    private static final String DEFAULT_USER = "user";
    private static final String DEFAULT_PASSWORD = "dummy";
    private static final String PROP_ATOMPUB_URL = "org.apache.chemistry.opencmis.binding.atompub.url";
    private static final String PROP_WS_URL = "org.apache.chemistry.opencmis.binding.webservices.url";
    private static final String PROP_BROWSER_URL = "org.apache.chemistry.opencmis.binding.browser.url";
    private static final String PROP_BINDING = "org.apache.chemistry.opencmis.binding.spi.type";
    private static final String PROP_CUSTOM = "org.apache.chemistry.opencmis.binding.header.";
    private static final String DEFAULT_ATOMPUB_URL = "http://localhost:8080/inmemory/atom";
    private static final String DEFAULT_WS_URL = "http://localhost:8080/inmemory/services/";
    private static final String DEFAULT_BROWSER_BINDING_URL = "http://localhost:8080/inmemory/browser/";
    private static final String DEFAULT_BINDING = "atompub";
    private static final String CMD = "Command";
    private static final String REPOSITORY_ID = "RepositoryId";
    private static final String FILLER_DOCUMENT_TYPE_ID = "DocumentTypeId";
    private static final String FILLER_FOLDER_TYPE_ID = "FolderTypeId";
    private static final String FILLER_DOCS_PER_FOLDER = "DocsPerFolder";
    private static final String FILLER_FOLDERS_PER_FOLDER = "FoldersPerFolder";
    private static final String FILLER_DEPTH = "Depth";
    private static final String FILLER_CONTENT_SIZE = "ContentSizeInKB";
    private static final String COUNT = "Count";
    private static final String CLEANUP = "Cleanup";
    private static final String ROOTFOLDER = "RootFolder";
    private static final String THREADS = "Threads";
    private static final String CONTENT_KIND = "ContentKind";
    private static final String FILE_NAME_PATTERN = "FileName";
    private static final String LOCAL_FILE = "File";
    private static final String LOCAL_DIR = "Dir";
    private static final String BINDING_ATOM = "atompub";
    private static final String BINDING_WS = "webservices";
    private static final String BINDING_BROWSER = "browser";
    private BindingType bindingType;
    private ObjectGenerator.ContentKind contentKind;
    private CmisBinding binding;
    private String cmd;
    private Integer depth;
    private Integer contentSize;
    private Integer folderPerFolder;
    private Integer docsPerFolder;
    private String folderType;
    private String docType;
    private String repositoryId;
    private Integer count;
    private Boolean cleanup;
    private String rootFolder;
    private Integer threads;
    private String contentKindStr;
    private String fileNamePattern;
    private String localDir;
    private String localFile;

    public static void main(String[] args) {
        ObjGenApp app = new ObjGenApp();
        try {
            app.processCmdLine(args);
        }
        catch (CmisBaseException ce) {
            System.out.println("Error: Could not process command. " + (Object)((Object)ce));
            System.out.println("Extended error: " + ce.getErrorContent());
            ce.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Could not fill repository " + e);
            e.printStackTrace();
        }
    }

    private void processCmdLine(String[] args) {
        String bindingStr;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optCmd = parser.accepts(CMD).withRequiredArg().describedAs("Command to perform (see below)");
        ArgumentAcceptingOptionSpec optRepoId = parser.accepts(REPOSITORY_ID).withOptionalArg().describedAs("Repository used");
        ArgumentAcceptingOptionSpec optDocType = parser.accepts(FILLER_DOCUMENT_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_DOCUMENT.value(), (Object[])new String[0]).describedAs("Document type created");
        ArgumentAcceptingOptionSpec optFolderType = parser.accepts(FILLER_FOLDER_TYPE_ID).withOptionalArg().defaultsTo((Object)BaseTypeId.CMIS_FOLDER.value(), (Object[])new String[0]).describedAs("Folder type created");
        ArgumentAcceptingOptionSpec optDocsPerFolder = parser.accepts(FILLER_DOCS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs("Documents on each level").defaultsTo((Object)1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optFolderPerFolder = parser.accepts(FILLER_FOLDERS_PER_FOLDER).withOptionalArg().ofType(Integer.class).describedAs(" Folders on each level").defaultsTo((Object)0, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optDepth = parser.accepts(FILLER_DEPTH).withOptionalArg().ofType(Integer.class).describedAs("Levels of folders").defaultsTo((Object)1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optContentSize = parser.accepts(FILLER_CONTENT_SIZE).withOptionalArg().ofType(Integer.class).describedAs("Content size of each doc").defaultsTo((Object)0, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optCount = parser.accepts(COUNT).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Repeat a command n times (partially implemented)");
        ArgumentAcceptingOptionSpec optCleanup = parser.accepts(CLEANUP).withOptionalArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]).describedAs("Clean all created objects at the end");
        ArgumentAcceptingOptionSpec optRootFolder = parser.accepts(ROOTFOLDER).withOptionalArg().ofType(String.class).describedAs("folder id used as root to create objects (default repository root folder)");
        ArgumentAcceptingOptionSpec optThreads = parser.accepts(THREADS).withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Number of threads to start in parallel");
        ArgumentAcceptingOptionSpec optContentKindStr = parser.accepts(CONTENT_KIND).withOptionalArg().ofType(String.class).defaultsTo((Object)"lorem/text", (Object[])new String[0]).describedAs("kind of content: static/text, lorem/text, lorem/html, fractal/jpeg");
        ArgumentAcceptingOptionSpec optFileNamePattern = parser.accepts(FILE_NAME_PATTERN).withOptionalArg().ofType(String.class).defaultsTo((Object)"ContentData-%03d.bin", (Object[])new String[0]).describedAs("file name pattern to be used with CreateFiles action");
        ArgumentAcceptingOptionSpec optLocalDir = parser.accepts(LOCAL_DIR).withOptionalArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]).describedAs("name of a directory to be recursively copied to the repository");
        ArgumentAcceptingOptionSpec optLocalFile = parser.accepts(LOCAL_FILE).withOptionalArg().ofType(String.class).describedAs("file name of a file to be copied to the repository");
        OptionSet options = parser.parse(args);
        if (this.cmd == null || options.has("?")) {
            ObjGenApp.usage(parser);
        }
        if ((bindingStr = ObjGenApp.getBindingProperty()).equals(BINDING_WS)) {
            this.bindingType = BindingType.WEBSERVICES;
        } else if (bindingStr.equals("atompub")) {
            this.bindingType = BindingType.ATOMPUB;
        } else if (bindingStr.equals(BINDING_BROWSER)) {
            this.bindingType = BindingType.BROWSER;
        } else {
            System.out.println("Error: Unknown binding: " + bindingStr + " allowed values: " + BINDING_WS + " or " + "atompub" + " or " + BINDING_BROWSER);
            return;
        }
        String kind = (String)options.valueOf((OptionSpec)optContentKindStr);
        if (null == kind) {
            this.contentKind = (Integer)options.valueOf((OptionSpec)optContentSize) > 0 ? ObjectGenerator.ContentKind.STATIC_TEXT : null;
        } else if (kind.equals("static/text")) {
            this.contentKind = ObjectGenerator.ContentKind.STATIC_TEXT;
        } else if (kind.equals("lorem/text")) {
            this.contentKind = ObjectGenerator.ContentKind.LOREM_IPSUM_TEXT;
        } else if (kind.equals("lorem/html")) {
            this.contentKind = ObjectGenerator.ContentKind.LOREM_IPSUM_HTML;
        } else if (kind.equals("fractal/jpeg")) {
            this.contentKind = ObjectGenerator.ContentKind.IMAGE_FRACTAL_JPEG;
        } else {
            System.out.println("Unknown content kind: " + (String)options.valueOf((OptionSpec)optContentKindStr));
            System.out.println("  must be one of static/text, lorem/text, lorem/html, fractal/jpeg");
            ObjGenApp.usage(parser);
        }
        this.repositoryId = (String)options.valueOf((OptionSpec)optRepoId);
        this.cmd = (String)options.valueOf((OptionSpec)optCmd);
        this.depth = (Integer)options.valueOf((OptionSpec)optDepth);
        this.contentSize = (Integer)options.valueOf((OptionSpec)optContentSize);
        this.folderPerFolder = (Integer)options.valueOf((OptionSpec)optFolderPerFolder);
        this.docsPerFolder = (Integer)options.valueOf((OptionSpec)optDocsPerFolder);
        this.folderType = (String)options.valueOf((OptionSpec)optFolderType);
        this.docType = (String)options.valueOf((OptionSpec)optDocType);
        this.count = (Integer)options.valueOf((OptionSpec)optCount);
        this.cleanup = (Boolean)options.valueOf((OptionSpec)optCleanup);
        this.rootFolder = (String)options.valueOf((OptionSpec)optRootFolder);
        this.threads = (Integer)options.valueOf((OptionSpec)optThreads);
        this.contentKindStr = (String)options.valueOf((OptionSpec)optContentKindStr);
        this.fileNamePattern = (String)options.valueOf((OptionSpec)optFileNamePattern);
        this.localDir = (String)options.valueOf((OptionSpec)optLocalDir);
        this.localFile = (String)options.valueOf((OptionSpec)optLocalFile);
        this.initClientBindings();
        if (null == this.cmd) {
            System.out.println("No command given.");
            ObjGenApp.usage(parser);
        } else if (this.cmd.equals("FillRepository")) {
            this.fillRepository(options);
        } else if (this.cmd.equals("CreateDocument")) {
            this.createSingleDocument(options);
        } else if (this.cmd.equals("CreateFolder")) {
            this.createFolders(options);
        } else if (this.cmd.equals("RepositoryInfo")) {
            this.repositoryInfo(options);
        } else if (this.cmd.equals("CreateFiles")) {
            this.createFiles(options);
        } else if (this.cmd.equals("CopyFiles")) {
            this.transferFiles(options);
        } else if (this.cmd.equals("CopyFilesTest")) {
            this.transferFilesTest(options);
        } else {
            System.out.println("Unknown cmd: " + this.cmd);
            ObjGenApp.usage(parser);
        }
    }

    private static void usage(OptionParser parser) {
        try {
            System.out.println();
            System.out.println("ObjGenApp is a command line tool for testing a CMIS repository.");
            System.out.println("Usage:");
            parser.printHelpOn((OutputStream)System.out);
            System.out.println();
            System.out.println("Command is one of [CreateDocument, CreateFolder, FillRepository, RepositoryInfo, CreateFiles, CopyFiles, CopyFilesTest]");
            System.out.println("JVM system properties: org.apache.chemistry.opencmis.binding.atompub.url, org.apache.chemistry.opencmis.binding.webservices.url, org.apache.chemistry.opencmis.binding.browser.url");
            System.out.println("                       org.apache.chemistry.opencmis.user, org.apache.chemistry.opencmis.password");
            System.out.println();
            System.out.println("Example: ");
            System.out.println("java -Dorg.apache.chemistry.opencmis.binding.atompub.url=http://localhost:8080/inmemory/atom -cp ... org.apache.chemistry.opencmis.util.repository.ObjGenApp --Binding=AtomPub --Command=CreateDocument --RepositoryId=A1 --ContentSizeInKB=25 --ContentKind=lorem/text");
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void fillRepository(String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateTree((CmisBinding)this.binding, (String)repoId, (int)docsPerFolder, (int)foldersPerFolders, (int)depth, (String)documentType, (String)folderType, (int)contentSizeInKB, (String)rootFolderId, (ObjectGenerator.ContentKind)this.contentKind, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        runner.doCreateTree();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Filling repository succeeded.");
        System.out.println("Folder used as root for creation (null=rootFolderId): " + rootFolderId);
        System.out.println("Number of documents created: " + gen.getDocumentsInTotal());
        System.out.println("Number of folders created: " + gen.getFoldersInTotal());
        gen.printTimings();
    }

    private void fillRepositoryMT(int noThreads, String repoId, int docsPerFolder, int foldersPerFolders, int depth, String documentType, String folderType, int contentSizeInKB, String rootFolderId, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder((CmisBinding)this.binding, (String)repoId, (String)folderType, (String)rootFolderId, (int)noThreads, (boolean)doCleanup);
        String[] folderIds = runner.doCreateFolder();
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateTreeMT((CmisBinding)this.binding, (String)repoId, (int)docsPerFolder, (int)foldersPerFolders, (int)depth, (String)documentType, (String)folderType, (int)contentSizeInKB, (String[])folderIds, (ObjectGenerator.ContentKind)this.contentKind, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Filling repository succeeded.");
    }

    private void printParameters(OptionSet options) {
        if (this.bindingType == BindingType.ATOMPUB) {
            System.out.println("Using AtomPub, connecting to  " + ObjGenApp.getAtomPubUrl());
        } else if (this.bindingType == BindingType.WEBSERVICES) {
            System.out.println("Using WebService, connecting to  " + ObjGenApp.getWsUrl());
        } else if (this.bindingType == BindingType.BROWSER) {
            System.out.println("Using Browser binding, connecting to  " + ObjGenApp.getBrowserUrl());
        } else {
            System.out.println("Unknown binding type.");
        }
        System.out.println("Repository id is: " + this.repositoryId);
        System.out.println("Content size: " + this.contentSize);
        System.out.println("Document Type: " + this.docType);
        System.out.println("Folder id used as root: " + this.rootFolder);
        System.out.println("Delete all objects after creation: " + this.cleanup);
        System.out.println("Number of actions to perform: " + this.count);
        System.out.println("Number of threads to start: " + this.threads);
        System.out.println("Kind of created content: " + this.contentKindStr);
    }

    private void createSingleDocument(OptionSet options) {
        System.out.println();
        System.out.println("Creating document with parameters:");
        this.printParameters(options);
        int noThreads = this.threads;
        if (noThreads <= 1) {
            this.createSingleDocument(this.repositoryId, this.docType, this.contentSize, this.rootFolder, this.count, this.cleanup);
        } else {
            this.createSingleDocumentMT(noThreads, this.repositoryId, this.docType, this.contentSize, this.rootFolder, this.count, this.cleanup);
        }
    }

    private void fillRepository(OptionSet options) {
        System.out.println();
        this.printParameters(options);
        System.out.println("Creating object tree with folowing parameters: ");
        System.out.println("Documents per folder: " + this.docsPerFolder);
        System.out.println("Folder per folder: " + this.folderPerFolder);
        System.out.println("Depth: " + this.depth);
        System.out.println("Folder Type: " + this.folderType);
        int noThreads = this.threads;
        if (noThreads <= 1) {
            this.fillRepository(this.repositoryId, this.docsPerFolder, this.folderPerFolder, this.depth, this.docType, this.folderType, this.contentSize, this.rootFolder, this.cleanup);
        } else {
            this.fillRepositoryMT(noThreads, this.repositoryId, this.docsPerFolder, this.folderPerFolder, this.depth, this.docType, this.folderType, this.contentSize, this.rootFolder, this.cleanup);
        }
    }

    private void createFolders(OptionSet options) {
        System.out.println();
        System.out.println("Creating folder with parameters:");
        this.printParameters(options);
        System.out.println("Folder Type: " + this.folderType);
        int noThreads = this.threads;
        if (noThreads <= 1) {
            this.createFolders(this.repositoryId, this.folderType, this.rootFolder, this.count, this.cleanup);
        } else {
            this.createFoldersMT(noThreads, this.repositoryId, this.folderType, this.rootFolder, this.count, this.cleanup);
        }
    }

    private void createSingleDocument(String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateDocument((CmisBinding)this.binding, (String)repoId, (String)documentType, (int)contentSizeInKB, (String)rootFolderId, (int)docCount, (ObjectGenerator.ContentKind)this.contentKind, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateDocument();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Document creation succeeded.");
        System.out.println("Folder used as root for creation: " + rootFolderId);
        System.out.println("Ids of created documents: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createSingleDocumentMT(int noThreads, String repoId, String documentType, int contentSizeInKB, String rootFolderId, int docCount, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateDocumentMT((int)noThreads, (CmisBinding)this.binding, (String)repoId, (String)documentType, (int)contentSizeInKB, (String)rootFolderId, (int)docCount, (ObjectGenerator.ContentKind)this.contentKind, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Document creation succeeded. All threads terminated.");
    }

    private void createFolders(String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner runner = MultiThreadedObjectGenerator.prepareForCreateFolder((CmisBinding)this.binding, (String)repoId, (String)folderType, (String)rootFolderId, (int)noFolders, (boolean)doCleanup);
        ObjectGenerator gen = runner.getObjectGenerator();
        String[] ids = runner.doCreateFolder();
        System.out.println();
        System.out.println("Result:");
        System.out.println("Folder creation succeeded.");
        System.out.println("Ids of created folders: ");
        if (null == ids) {
            System.out.println("<none>");
        } else {
            for (int i = 0; i < ids.length; ++i) {
                System.out.println(ids[i]);
            }
        }
        gen.printTimings();
        gen.resetCounters();
    }

    private void createFoldersMT(int noThreads, String repoId, String folderType, String rootFolderId, int noFolders, boolean doCleanup) {
        MultiThreadedObjectGenerator.ObjectGeneratorRunner[] runners = MultiThreadedObjectGenerator.prepareForCreateFolderMT((int)noThreads, (CmisBinding)this.binding, (String)repoId, (String)folderType, (String)rootFolderId, (int)noFolders, (boolean)doCleanup);
        MultiThreadedObjectGenerator.runMultiThreaded((MultiThreadedObjectGenerator.ObjectGeneratorRunner[])runners);
        System.out.println("Folder creation succeeded.");
    }

    private void callRepoInfo(String repositoryId, int count) {
        RepositoryService repSvc = this.binding.getRepositoryService();
        TimeLogger timeLogger = new TimeLogger("RepoInfoTest");
        RepositoryInfo repoInfo = null;
        for (int i = 0; i < count; ++i) {
            this.binding.clearRepositoryCache(repositoryId);
            timeLogger.start();
            repoInfo = repSvc.getRepositoryInfo(repositoryId, null);
            timeLogger.stop();
        }
        System.out.println("Root Folder id is: " + (repoInfo == null ? "<unknown>" : repoInfo.getRootFolderId()));
        timeLogger.printTimes();
    }

    private void repositoryInfo(OptionSet options) {
        this.callRepoInfo(this.repositoryId, this.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFiles(OptionSet options) {
        ContentStream contentStream = null;
        System.out.println("Creating local files with content: ");
        System.out.println("Kind: " + this.docsPerFolder);
        System.out.println("Number of files: " + this.count);
        System.out.println("File name pattern: " + this.fileNamePattern);
        System.out.println("Kind of content: " + this.contentKindStr);
        System.out.println("Size of content (text only): " + this.contentSize);
        ObjectGenerator objGen = new ObjectGenerator(null, null, null, null, null, this.contentKind);
        objGen.setContentSizeInKB(this.contentSize.intValue());
        InputStream is = null;
        FileOutputStream os = null;
        try {
            for (int i = 0; i < this.count; ++i) {
                String fileName = String.format(this.fileNamePattern, i);
                System.out.println("Generating file: " + fileName);
                if (this.contentSize > 0) {
                    switch (this.contentKind) {
                        case STATIC_TEXT: {
                            contentStream = objGen.createContentStaticText();
                            break;
                        }
                        case LOREM_IPSUM_TEXT: {
                            contentStream = objGen.createContentLoremIpsumText();
                            break;
                        }
                        case LOREM_IPSUM_HTML: {
                            contentStream = objGen.createContentLoremIpsumHtml();
                            break;
                        }
                        case IMAGE_FRACTAL_JPEG: {
                            contentStream = objGen.createContentFractalimageJpeg();
                        }
                    }
                }
                is = contentStream.getStream();
                os = new FileOutputStream(fileName);
                IOUtils.copy((InputStream)is, (OutputStream)os, (int)65536);
                is.close();
                is = null;
                os.close();
                os = null;
            }
        }
        catch (Exception e) {
            System.err.println("Error generating file: " + e);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
    }

    private void transferFiles(OptionSet options) {
        String fileName = this.localFile;
        String dirName = this.localDir;
        String folderId = this.rootFolder;
        String name = fileName;
        if (!(null != fileName && fileName.length() != 0 || null != dirName && dirName.length() != 0)) {
            System.out.println("Error: You either have to provide a --file or a --dir option to copy file(s).");
            return;
        }
        if (null == name || name.length() == 0) {
            name = dirName;
        }
        System.out.println("Copying files to a repository: ");
        System.out.println("Repository id is: " + (this.repositoryId == null ? "not set!" : this.repositoryId));
        System.out.println("Folder id used as root: " + this.rootFolder);
        Map<String, String> parameters = this.getConnectionParameters(ObjGenApp.getBindingProperty(), this.repositoryId);
        FileCopier fc = new FileCopier();
        fc.connect(parameters);
        fc.copyRecursive(name, folderId);
    }

    private void transferFilesTest(OptionSet options) {
        String fileName = this.localFile;
        if (null == fileName || fileName.length() == 0) {
            System.out.println("Error: You have to provide a --file option to test metadata extraction.");
            return;
        }
        System.out.println("Testing metadata extraction: ");
        FileCopier fc = new FileCopier();
        fc.listMetadata(fileName);
    }

    private Map<String, String> getConnectionParameters(String binding, String repoId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoId);
        parameters.put(PROP_BINDING, binding);
        if (binding.equals(BindingType.ATOMPUB.value())) {
            parameters.put(PROP_ATOMPUB_URL, ObjGenApp.getAtomPubUrl());
            ObjGenApp.filLoginParams(parameters, ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else if (binding.equals(BindingType.WEBSERVICES.value())) {
            ObjGenApp.fillWSParameters(parameters, ObjGenApp.getWsUrl(), ObjGenApp.isPrefix(ObjGenApp.getWsUrl()), ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else if (binding.equals(BindingType.BROWSER.value())) {
            parameters.put(PROP_BROWSER_URL, ObjGenApp.getBrowserUrl());
            ObjGenApp.filLoginParams(parameters, ObjGenApp.getUser(), ObjGenApp.getPassword());
        } else {
            System.out.println("Error unknown binding: " + binding);
        }
        ObjGenApp.fillCustomHeaders(parameters);
        return parameters;
    }

    private void initClientBindings() {
        if (this.binding == null) {
            if (this.bindingType == BindingType.ATOMPUB) {
                this.binding = ObjGenApp.createAtomBinding(ObjGenApp.getAtomPubUrl(), ObjGenApp.getUser(), ObjGenApp.getPassword());
            }
            if (this.bindingType == BindingType.WEBSERVICES) {
                String url = ObjGenApp.getWsUrl();
                this.binding = ObjGenApp.createWSBinding(url, ObjGenApp.isPrefix(url), ObjGenApp.getUser(), ObjGenApp.getPassword());
            } else if (this.bindingType == BindingType.BROWSER) {
                this.binding = ObjGenApp.createBrowserBinding(ObjGenApp.getBrowserUrl(), ObjGenApp.getUser(), ObjGenApp.getPassword());
            }
            RepositoryInfo repoInfo = this.binding.getRepositoryService().getRepositoryInfo(null, null);
            if (null == this.repositoryId) {
                this.repositoryId = repoInfo.getId();
            }
        }
    }

    private static void filLoginParams(Map<String, String> parameters, String user, String password) {
        if (user != null && user.length() > 0) {
            parameters.put(PROP_USER, user);
        }
        if (user != null && user.length() > 0) {
            parameters.put(PROP_PASSWORD, password);
        }
    }

    private static void fillCustomHeaders(Map<String, String> parameters) {
        Map<String, String> customHeaders = ObjGenApp.getCustomHeaders();
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            parameters.put(entry.getKey(), entry.getValue());
        }
    }

    private static CmisBinding createAtomBinding(String url, String user, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.filLoginParams(parameters, user, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        parameters.put(PROP_ATOMPUB_URL, url);
        CmisBinding binding = factory.createCmisAtomPubBinding(parameters);
        return binding;
    }

    private static CmisBinding createBrowserBinding(String url, String user, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.filLoginParams(parameters, user, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        parameters.put(PROP_BROWSER_URL, url);
        CmisBinding binding = factory.createCmisBrowserBinding(parameters);
        return binding;
    }

    private static boolean isPrefix(String url) {
        boolean isPrefix = true;
        String urlLower = url.toLowerCase();
        if (urlLower.endsWith("?wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".wsdl")) {
            isPrefix = false;
        } else if (urlLower.endsWith(".xml")) {
            isPrefix = false;
        }
        return isPrefix;
    }

    public static CmisBinding createWSBinding(String url, boolean isPrefix, String username, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObjGenApp.fillWSParameters(parameters, url, isPrefix, username, password);
        ObjGenApp.fillCustomHeaders(parameters);
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding binding = factory.createCmisWebServicesBinding(parameters);
        return binding;
    }

    public static void fillWSParameters(Map<String, String> parameters, String url, boolean isPrefix, String username, String password) {
        parameters.put(PROP_USER, username);
        parameters.put(PROP_PASSWORD, password);
        if (!isPrefix) {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url + "VersioningService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url + "ACLService?wsdl");
        }
    }

    private static String getBindingProperty() {
        return System.getProperty(PROP_BINDING, "atompub");
    }

    private static String getAtomPubUrl() {
        return System.getProperty(PROP_ATOMPUB_URL, DEFAULT_ATOMPUB_URL);
    }

    private static String getWsUrl() {
        return System.getProperty(PROP_WS_URL, DEFAULT_WS_URL);
    }

    private static String getBrowserUrl() {
        return System.getProperty(PROP_BROWSER_URL, DEFAULT_BROWSER_BINDING_URL);
    }

    private static String getUser() {
        return System.getProperty(PROP_USER, DEFAULT_USER);
    }

    private static String getPassword() {
        return System.getProperty(PROP_PASSWORD, DEFAULT_PASSWORD);
    }

    private static Map<String, String> getCustomHeaders() {
        String val;
        int i = 0;
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        while (null != (val = System.getProperty(PROP_CUSTOM + i, null))) {
            customHeaders.put(PROP_CUSTOM + i++, val);
        }
        return customHeaders;
    }
}

