/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commander;

import java.io.PrintWriter;
import java.util.List;
import org.apache.chemistry.opencmis.commander.Command;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class InfosCommand
implements Command {
    public String getCommandName() {
        return "infos";
    }

    public String getUsage() {
        return "INFOS";
    }

    public void execute(CmisBinding binding, String[] args, PrintWriter output) {
        List repositoryInfos = binding.getRepositoryService().getRepositoryInfos(null);
        for (RepositoryInfo repositoryInfo : repositoryInfos) {
            this.printRepositoryInfo(repositoryInfo, output);
        }
    }

    private void printRepositoryInfo(RepositoryInfo repositoryInfo, PrintWriter output) {
        output.println("Id:           " + repositoryInfo.getId());
        output.println("Name:         " + repositoryInfo.getProductName());
        output.println("Description:  " + repositoryInfo.getDescription());
        output.println("Vendor:       " + repositoryInfo.getVendorName());
        output.println("Product:      " + repositoryInfo.getProductName() + " " + repositoryInfo.getProductVersion());
        output.println("Root Folder:  " + repositoryInfo.getRootFolderId());
        output.println("Capabilities: " + repositoryInfo.getCapabilities());
        output.println("------------------------------------------------------");
    }
}

