/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commander;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.commander.Command;
import org.apache.chemistry.opencmis.commander.DeleteCommand;
import org.apache.chemistry.opencmis.commander.InfosCommand;
import org.apache.chemistry.opencmis.commander.ListCommand;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class Commander {
    private static final Map<String, Command> COMMAND_MAP = new LinkedHashMap<String, Command>();
    private PrintWriter fPW = new PrintWriter(System.out);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Commander(String[] args) {
        if (args.length < 2) {
            this.printUsage(this.fPW);
            return;
        }
        try {
            Command command = COMMAND_MAP.get(args[1].toLowerCase());
            if (command == null) {
                this.printUsage(this.fPW);
                return;
            }
            CmisBinding binding = this.createBinding(args[0]);
            String[] commandArgs = new String[args.length - 2];
            System.arraycopy(args, 2, commandArgs, 0, commandArgs.length);
            command.execute(binding, commandArgs, this.fPW);
        }
        catch (Exception e) {
            this.fPW.println("Exception:");
            if (e instanceof CmisBaseException) {
                this.fPW.println(e);
            } else {
                e.printStackTrace(this.fPW);
            }
        }
        finally {
            this.fPW.flush();
        }
    }

    private void printUsage(PrintWriter output) {
        output.println("CMIS Commander\n");
        output.println("Usage: Commander <config file> <command>\n");
        output.println("Available commands:");
        for (Command command : COMMAND_MAP.values()) {
            output.println("  " + command.getUsage());
        }
        output.flush();
    }

    private CmisBinding createBinding(String configFile) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(configFile));
        HashMap<String, String> sessionParameters = new HashMap<String, String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            sessionParameters.put(key, value);
        }
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        CmisBinding result = null;
        if (sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.atompub.url")) {
            result = factory.createCmisAtomPubBinding(sessionParameters);
        } else if (sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.webservices.RepositoryService")) {
            result = factory.createCmisWebServicesBinding(sessionParameters);
        } else {
            throw new IllegalArgumentException("Cannot find CMIS binding information in config file!");
        }
        return result;
    }

    private static final void addCommand(Command command) {
        if (command == null || command.getCommandName() == null) {
            return;
        }
        COMMAND_MAP.put(command.getCommandName().toLowerCase(), command);
    }

    public static void main(String[] args) {
        new Commander(args);
    }

    static {
        Commander.addCommand(new InfosCommand());
        Commander.addCommand(new ListCommand());
        Commander.addCommand(new DeleteCommand());
    }
}

