/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.DataObjectCreator;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCreationHelper {
    private static Log log = LogFactory.getLog(PropertyCreationHelper.class);

    public static PropertyBooleanDefinitionImpl createBooleanDefinition(String id, String displayName) {
        PropertyBooleanDefinitionImpl prop = new PropertyBooleanDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.BOOLEAN, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyBooleanDefinitionImpl createBooleanMultiDefinition(String id, String displayName) {
        PropertyBooleanDefinitionImpl prop = new PropertyBooleanDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.BOOLEAN, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyDateTimeDefinitionImpl createDateTimeDefinition(String id, String displayName) {
        PropertyDateTimeDefinitionImpl prop = new PropertyDateTimeDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DATETIME, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyDateTimeDefinitionImpl createDateTimeMultiDefinition(String id, String displayName) {
        PropertyDateTimeDefinitionImpl prop = new PropertyDateTimeDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DATETIME, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyDecimalDefinitionImpl createDecimalDefinition(String id, String displayName) {
        PropertyDecimalDefinitionImpl prop = new PropertyDecimalDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DECIMAL, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyDecimalDefinitionImpl createDecimalMultiDefinition(String id, String displayName) {
        PropertyDecimalDefinitionImpl prop = new PropertyDecimalDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.DECIMAL, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyHtmlDefinitionImpl createHtmlDefinition(String id, String displayName) {
        PropertyHtmlDefinitionImpl prop = new PropertyHtmlDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.HTML, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyHtmlDefinitionImpl createHtmlMultiDefinition(String id, String displayName) {
        PropertyHtmlDefinitionImpl prop = new PropertyHtmlDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.HTML, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyIdDefinitionImpl createIdDefinition(String id, String displayName) {
        PropertyIdDefinitionImpl prop = new PropertyIdDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.ID, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyIdDefinitionImpl createIdMultiDefinition(String id, String displayName) {
        PropertyIdDefinitionImpl prop = new PropertyIdDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.ID, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyIntegerDefinitionImpl createIntegerDefinition(String id, String displayName) {
        PropertyIntegerDefinitionImpl prop = new PropertyIntegerDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.INTEGER, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyIntegerDefinitionImpl createIntegerMultiDefinition(String id, String displayName) {
        PropertyIntegerDefinitionImpl prop = new PropertyIntegerDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.INTEGER, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyStringDefinitionImpl createStringDefinition(String id, String displayName) {
        PropertyStringDefinitionImpl prop = new PropertyStringDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.STRING, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyStringDefinitionImpl createStringMultiDefinition(String id, String displayName) {
        PropertyStringDefinitionImpl prop = new PropertyStringDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.STRING, displayName, Cardinality.MULTI);
        return prop;
    }

    public static PropertyUriDefinitionImpl createUriDefinition(String id, String displayName) {
        PropertyUriDefinitionImpl prop = new PropertyUriDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.URI, displayName, Cardinality.SINGLE);
        return prop;
    }

    public static PropertyUriDefinitionImpl createUriMultiDefinition(String id, String displayName) {
        PropertyUriDefinitionImpl prop = new PropertyUriDefinitionImpl();
        PropertyCreationHelper.createStandardDefinition(prop, id, PropertyType.URI, displayName, Cardinality.MULTI);
        return prop;
    }

    public static <T> void addElemToPicklist(AbstractPropertyDefinition<T> prop, T value) {
        ArrayList<ChoiceImpl> choiceList = prop.getChoices();
        if (choiceList == null) {
            choiceList = new ArrayList<ChoiceImpl>();
            prop.setChoices(choiceList);
        }
        ChoiceImpl elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList(value));
        choiceList.add(elem);
    }

    public static <T> void setDefaultValue(AbstractPropertyDefinition<T> prop, T defVal) {
        prop.setDefaultValue(Collections.singletonList(defVal));
    }

    public static Properties getPropertiesFromObject(StoredObject so, TypeDefinition td, List<String> requestedIds, boolean fillOptionalPropertyData) {
        BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
        HashMap properties = new HashMap();
        so.fillProperties(properties, (BindingsObjectFactory)objectFactory, requestedIds);
        String typeId = so.getTypeId();
        if (FilterParser.isContainedInFilter("cmis:baseTypeId", requestedIds)) {
            if (td == null) {
                log.warn((Object)("getPropertiesFromObject(), cannot get type definition, a type with id " + typeId + " is unknown"));
            } else {
                String baseTypeId = td.getBaseTypeId().value();
                properties.put("cmis:baseTypeId", (PropertyData<?>)objectFactory.createPropertyIdData("cmis:baseTypeId", baseTypeId));
            }
        }
        ArrayList propertiesList = new ArrayList(properties.values());
        if (fillOptionalPropertyData) {
            PropertyCreationHelper.fillOptionalPropertyData(td, propertiesList);
        }
        Properties props = objectFactory.createPropertiesData(propertiesList);
        return props;
    }

    public static Properties getPropertiesFromObject(StoredObject so, TypeDefinition td, Map<String, String> requestedIds, Map<String, String> requestedFuncs) {
        AbstractPropertyData ad;
        String displayName;
        String localName;
        ArrayList<String> idList = new ArrayList<String>(requestedIds.keySet());
        BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
        HashMap properties = new HashMap();
        so.fillProperties(properties, (BindingsObjectFactory)objectFactory, idList);
        String typeId = so.getTypeId();
        if (FilterParser.isContainedInFilter("cmis:baseTypeId", idList)) {
            if (td == null) {
                log.warn((Object)("getPropertiesFromObject(), cannot get type definition, a type with id " + typeId + " is unknown"));
            } else {
                String baseTypeId = td.getBaseTypeId().value();
                properties.put("cmis:baseTypeId", (PropertyData<?>)objectFactory.createPropertyIdData("cmis:baseTypeId", baseTypeId));
            }
        }
        HashMap mappedProperties = new HashMap();
        if (requestedIds.containsKey("*")) {
            for (Map.Entry prop : properties.entrySet()) {
                String queryName = ((PropertyDefinition)td.getPropertyDefinitions().get(prop.getKey())).getQueryName();
                localName = ((PropertyDefinition)td.getPropertyDefinitions().get(prop.getKey())).getLocalName();
                displayName = ((PropertyDefinition)td.getPropertyDefinitions().get(prop.getKey())).getDisplayName();
                ad = (AbstractPropertyData)prop.getValue();
                ad.setQueryName(queryName);
                ad.setLocalName(localName);
                ad.setDisplayName(displayName);
                mappedProperties.put(queryName, prop.getValue());
            }
        } else {
            for (Map.Entry prop : properties.entrySet()) {
                String queryNameOrAlias = requestedIds.get(prop.getKey());
                localName = ((PropertyDefinition)td.getPropertyDefinitions().get(prop.getKey())).getLocalName();
                displayName = ((PropertyDefinition)td.getPropertyDefinitions().get(prop.getKey())).getDisplayName();
                ad = (AbstractPropertyData)prop.getValue();
                ad.setQueryName(queryNameOrAlias);
                ad.setLocalName(localName);
                ad.setDisplayName(displayName);
                mappedProperties.put(queryNameOrAlias, prop.getValue());
            }
        }
        BindingsObjectFactoryImpl objFactory = new BindingsObjectFactoryImpl();
        for (Map.Entry<String, String> funcEntry : requestedFuncs.entrySet()) {
            PropertyInteger pi = objFactory.createPropertyIntegerData(funcEntry.getKey(), BigInteger.valueOf(100L));
            mappedProperties.put(funcEntry.getValue(), pi);
        }
        PropertiesImpl props = new PropertiesImpl(mappedProperties.values());
        return props;
    }

    public static ObjectData getObjectData(TypeDefinition typeDef, StoredObject so, String filter, String user, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectDataImpl od = new ObjectDataImpl();
        if (so == null) {
            throw new CmisObjectNotFoundException("Illegal object id: null");
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, typeDef, requestedIds, true);
        if (null != includeAllowableActions && includeAllowableActions.booleanValue()) {
            AllowableActions allowableActions = DataObjectCreator.fillAllowableActions(so, user);
            od.setAllowableActions(allowableActions);
        }
        if (null != includeACL && includeACL.booleanValue()) {
            od.setAcl(null);
        }
        od.setIsExactAcl(Boolean.valueOf(true));
        if (null != includePolicyIds && includePolicyIds.booleanValue()) {
            od.setPolicyIds(DataObjectCreator.fillPolicyIds(so));
        }
        if (null != includeRelationships && includeRelationships != IncludeRelationships.NONE) {
            od.setRelationships(DataObjectCreator.fillRelationships(includeRelationships, so));
        }
        if (renditionFilter != null && renditionFilter.length() > 0) {
            od.setRenditions(DataObjectCreator.fillRenditions(so));
        }
        od.setProperties(props);
        return od;
    }

    public static ObjectData getObjectDataQueryResult(TypeDefinition typeDef, StoredObject so, String user, Map<String, String> requestedProperties, Map<String, String> requestedFuncs, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter) {
        ObjectDataImpl od = new ObjectDataImpl();
        Properties props = PropertyCreationHelper.getPropertiesFromObject(so, typeDef, requestedProperties, requestedFuncs);
        if (null != includeAllowableActions && includeAllowableActions.booleanValue()) {
            AllowableActions allowableActions = DataObjectCreator.fillAllowableActions(so, user);
            od.setAllowableActions(allowableActions);
        }
        if (null != includeRelationships && includeRelationships != IncludeRelationships.NONE) {
            od.setRelationships(DataObjectCreator.fillRelationships(includeRelationships, so));
        }
        if (renditionFilter != null && renditionFilter.length() > 0) {
            od.setRenditions(DataObjectCreator.fillRenditions(so));
        }
        od.setProperties(props);
        return od;
    }

    private static void createStandardDefinition(AbstractPropertyDefinition<?> prop, String id, PropertyType propType, String displayName, Cardinality card) {
        if (!NameValidator.isValidId(id) && !NameValidator.isValidId(id)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        prop.setId(id);
        if (displayName == null) {
            prop.setDisplayName("Sample " + prop.getId() + " boolean property");
        } else {
            prop.setDisplayName(displayName);
        }
        prop.setLocalName(id);
        prop.setLocalNamespace("local");
        prop.setQueryName(id);
        prop.setIsInherited(Boolean.valueOf(false));
        prop.setCardinality(card);
        prop.setIsOpenChoice(Boolean.valueOf(false));
        prop.setIsQueryable(Boolean.valueOf(true));
        prop.setIsRequired(Boolean.valueOf(false));
        prop.setPropertyType(propType);
        prop.setUpdatability(Updatability.READWRITE);
    }

    private static void fillOptionalPropertyData(TypeDefinition td, List<PropertyData<?>> properties) {
        for (PropertyData<?> pd : properties) {
            PropertyCreationHelper.fillOptionalPropertyData(td, (AbstractPropertyData)pd);
        }
    }

    private static void fillOptionalPropertyData(TypeDefinition td, AbstractPropertyData<?> property) {
        PropertyDefinition pd = (PropertyDefinition)td.getPropertyDefinitions().get(property.getId());
        if (null != pd) {
            String displayName = pd.getDisplayName();
            String queryName = pd.getQueryName();
            String localName = pd.getLocalName();
            property.setDisplayName(displayName);
            property.setLocalName(localName);
            property.setQueryName(queryName);
        }
    }
}

