/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRelationshipTypeDefinition
extends RelationshipTypeDefinitionImpl {
    private static final long serialVersionUID = 1L;
    private static InMemoryRelationshipTypeDefinition RELATIONSHIP_TYPE = new InMemoryRelationshipTypeDefinition();

    public static InMemoryRelationshipTypeDefinition getRootRelationshipType() {
        return RELATIONSHIP_TYPE;
    }

    public InMemoryRelationshipTypeDefinition() {
        this.init(BaseTypeId.CMIS_RELATIONSHIP.value(), "CMIS Relation");
        this.setParentTypeId(null);
        Map props = this.getPropertyDefinitions();
        DocumentTypeCreationHelper.setBasicRelationshipPropertyDefinitions(props);
    }

    public InMemoryRelationshipTypeDefinition(String id, String displayName) {
        this.init(id, displayName);
        this.setParentTypeId(RELATIONSHIP_TYPE.getId());
    }

    public InMemoryRelationshipTypeDefinition(String id, String displayName, InMemoryRelationshipTypeDefinition parentType) {
        this.init(id, displayName);
        if (parentType == null) {
            throw new IllegalArgumentException("Must provide a parent type when creating a relationship definition");
        }
        this.setBaseTypeId(parentType.getBaseTypeId());
        this.setParentTypeId(parentType.getId());
    }

    public void addCustomPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.mergePropertyDefinitions(this.getPropertyDefinitions(), propertyDefinitions);
    }

    private void init(String id, String displayName) {
        if (!NameValidator.isValidId(id)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        this.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        this.setId(id);
        if (displayName == null) {
            displayName = '#' + id + '#';
        }
        this.setDisplayName(displayName);
        this.setDescription("Description of " + this.getDisplayName() + " Type");
        this.setLocalName(id);
        this.setLocalNamespace("local");
        this.setQueryName(id);
        this.setIsControllableAcl(false);
        this.setIsControllablePolicy(false);
        this.setIsCreatable(true);
        this.setIsFileable(true);
        this.setIsFulltextIndexed(false);
        this.setIsIncludedInSupertypeQuery(true);
        this.setIsQueryable(false);
        this.setAllowedSourceTypes(null);
        this.setAllowedTargetTypes(null);
        HashMap props = new HashMap();
        this.setPropertyDefinitions(props);
    }
}

