/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryFolderTypeDefinition
extends FolderTypeDefinitionImpl {
    private static final long serialVersionUID = 1L;
    private static InMemoryFolderTypeDefinition FOLDER_TYPE = new InMemoryFolderTypeDefinition();

    public static InMemoryFolderTypeDefinition getRootFolderType() {
        return FOLDER_TYPE;
    }

    public InMemoryFolderTypeDefinition() {
        this.init(BaseTypeId.CMIS_FOLDER.value(), "CMIS Folder");
        this.setParentTypeId(null);
        Map props = this.getPropertyDefinitions();
        DocumentTypeCreationHelper.setBasicFolderPropertyDefinitions(props);
    }

    public InMemoryFolderTypeDefinition(String id, String displayName) {
        this.init(id, displayName);
        this.setParentTypeId(FOLDER_TYPE.getId());
    }

    public InMemoryFolderTypeDefinition(String id, String displayName, InMemoryFolderTypeDefinition parentType) {
        this.init(id, displayName);
        if (parentType == null) {
            throw new IllegalArgumentException("Must provide a parent type when creating a folder type definition");
        }
        this.setBaseTypeId(parentType.getBaseTypeId());
        this.setParentTypeId(parentType.getId());
    }

    public void addCustomPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.mergePropertyDefinitions(this.getPropertyDefinitions(), propertyDefinitions);
    }

    private void init(String id, String displayName) {
        if (!NameValidator.isValidId(id)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        this.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        this.setId(id);
        if (displayName == null) {
            displayName = '#' + id + '#';
        }
        this.setDisplayName(displayName);
        this.setDescription("Description of " + this.getDisplayName() + " Type");
        this.setLocalName(id);
        this.setLocalNamespace("local");
        this.setQueryName(id);
        this.setIsControllableAcl(false);
        this.setIsControllablePolicy(false);
        this.setIsCreatable(true);
        this.setIsFileable(true);
        this.setIsFulltextIndexed(false);
        this.setIsIncludedInSupertypeQuery(true);
        this.setIsQueryable(false);
        HashMap props = new HashMap();
        this.setPropertyDefinitions(props);
    }
}

