/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.types.DocumentTypeCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDocumentTypeDefinition
extends DocumentTypeDefinitionImpl {
    private static final long serialVersionUID = 1L;
    private static InMemoryDocumentTypeDefinition DOCUMENT_TYPE = new InMemoryDocumentTypeDefinition();

    public static InMemoryDocumentTypeDefinition getRootDocumentType() {
        return DOCUMENT_TYPE;
    }

    public InMemoryDocumentTypeDefinition() {
        this.init(BaseTypeId.CMIS_DOCUMENT.value(), "CMIS Document");
        this.setParentTypeId(null);
        Map props = this.getPropertyDefinitions();
        DocumentTypeCreationHelper.setBasicDocumentPropertyDefinitions(props);
    }

    public InMemoryDocumentTypeDefinition(String id, String displayName) {
        this.init(id, displayName);
        this.setParentTypeId(DOCUMENT_TYPE.getId());
    }

    public InMemoryDocumentTypeDefinition(String id, String displayName, InMemoryDocumentTypeDefinition parentType) {
        this.init(id, displayName);
        if (parentType == null) {
            throw new IllegalArgumentException("Must provide a parent type when creating a document type definition");
        }
        this.setBaseTypeId(parentType.getBaseTypeId());
        this.setParentTypeId(parentType.getId());
    }

    public void addCustomPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.mergePropertyDefinitions(this.getPropertyDefinitions(), propertyDefinitions);
    }

    private void init(String id, String displayName) {
        if (!NameValidator.isValidId(id)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_'");
        }
        this.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        this.setId(id);
        if (displayName == null) {
            displayName = '#' + id + '#';
        }
        this.setDisplayName(displayName);
        this.setDescription("Description of " + this.getDisplayName() + " Type");
        this.setLocalName(id);
        this.setLocalNamespace("local");
        this.setQueryName(id);
        this.setIsControllableAcl(false);
        this.setIsControllablePolicy(false);
        this.setIsCreatable(true);
        this.setIsFileable(true);
        this.setIsFulltextIndexed(false);
        this.setIsIncludedInSupertypeQuery(true);
        this.setIsQueryable(false);
        HashMap props = new HashMap();
        this.setPropertyDefinitions(props);
        this.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        this.setIsVersionable(false);
    }
}

