/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryDocumentTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryFolderTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTypeCreationHelper {
    private static List<TypeDefinition> defaultTypes = DocumentTypeCreationHelper.createCmisDefaultTypes();

    public static List<TypeDefinition> createMapWithDefaultTypes() {
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        typesList.addAll(defaultTypes);
        return typesList;
    }

    public static final List<TypeDefinition> getDefaultTypes() {
        return defaultTypes;
    }

    private static List<TypeDefinition> createCmisDefaultTypes() {
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        Object cmisType = InMemoryDocumentTypeDefinition.getRootDocumentType();
        typesList.add((TypeDefinition)cmisType);
        cmisType = InMemoryFolderTypeDefinition.getRootFolderType();
        typesList.add((TypeDefinition)cmisType);
        return typesList;
    }

    public static List<TypeDefinition> createDefaultTypes() {
        List<TypeDefinition> typesList = DocumentTypeCreationHelper.createCmisDefaultTypes();
        return typesList;
    }

    public static void setBasicPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:name", "CMIS Name Property");
        propS.setUpdatability(Updatability.READWRITE);
        propS.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:objectId", "CMIS Object Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:objectTypeId", "CMIS Object Type Id Property");
        propId.setUpdatability(Updatability.ONCREATE);
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:baseTypeId", "CMIS Base Type Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propS = PropertyCreationHelper.createStringDefinition("cmis:createdBy", "CMIS Created By Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyDateTimeDefinitionImpl propD = PropertyCreationHelper.createDateTimeDefinition("cmis:creationDate", "CMIS Creation Date Property");
        propD.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propD.getId(), (PropertyDefinition<?>)propD);
        propS = PropertyCreationHelper.createStringDefinition("cmis:lastModifiedBy", "CMIS Last Modified By Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propD = PropertyCreationHelper.createDateTimeDefinition("cmis:lastModificationDate", "CMIS Last Modification Date Property");
        propD.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propD.getId(), (PropertyDefinition<?>)propD);
        propS = PropertyCreationHelper.createStringDefinition("cmis:changeToken", "CMIS Change Token Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicDocumentPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyBooleanDefinitionImpl propB = PropertyCreationHelper.createBooleanDefinition("cmis:isImmutable", "CMIS Is Immutable Property");
        propB.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isLatestVersion", "CMIS Is Latest Version Property");
        propB.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isMajorVersion", "CMIS Is Major Version Property");
        propB.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isLatestMajorVersion", "CMIS Is Latest Major Version Property");
        propB.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:versionLabel", "CMIS Version Label Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:versionSeriesId", "CMIS Version Series Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isVersionSeriesCheckedOut", "CMIS Is Version Series Checked Out Property");
        propB.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propS = PropertyCreationHelper.createStringDefinition("cmis:versionSeriesCheckedOutBy", "CMIS Version Series Checked Out By Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propId = PropertyCreationHelper.createIdDefinition("cmis:versionSeriesCheckedOutId", "CMIS Version Series Checked Out Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propS = PropertyCreationHelper.createStringDefinition("cmis:checkinComment", "CMIS Checkin Comment Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIntegerDefinitionImpl propI = PropertyCreationHelper.createIntegerDefinition("cmis:contentStreamLength", "CMIS Content Stream Length Property");
        propI.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propI.getId(), (PropertyDefinition<?>)propI);
        propS = PropertyCreationHelper.createStringDefinition("cmis:contentStreamMimeType", "CMIS Content Stream Mime Type Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propS = PropertyCreationHelper.createStringDefinition("cmis:contentStreamFileName", "CMIS Content Stream File Name Property");
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propId = PropertyCreationHelper.createIdDefinition("cmis:contentStreamId", "CMIS Stream Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
    }

    public static void setBasicFolderPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:parentId", "CMIS Parent Id Property");
        propId.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:allowedChildObjectTypeIds", "CMIS Allowed Childe Object Type Ids Property");
        propId.setUpdatability(Updatability.READONLY);
        propId.setCardinality(Cardinality.MULTI);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:path", "CMIS Path Property");
        propS.setUpdatability(Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicPolicyPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:policyText", "CMIS Policy Text Property");
        propS.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicRelationshipPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:sourceId", "CMIS Source Id Property");
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:targetId", "CMIS Target Id Property");
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
    }

    public static void mergePropertyDefinitions(Map<String, PropertyDefinition<?>> existingPpropertyDefinitions, Map<String, PropertyDefinition<?>> newPropertyDefinitions) {
        for (String propId : newPropertyDefinitions.keySet()) {
            if (!existingPpropertyDefinitions.containsKey(propId)) continue;
            throw new RuntimeException("You can't set a property with id " + propId + ". This property id already exists already or exists in supertype");
        }
        existingPpropertyDefinitions.putAll(newPropertyDefinitions);
    }
}

