/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.inmemory.TypeCreator;
import org.apache.chemistry.opencmis.inmemory.types.InMemoryDocumentTypeDefinition;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeSystemCreator
implements TypeCreator {
    public static List<TypeDefinition> singletonTypes = DefaultTypeSystemCreator.buildTypesList();
    public static final String COMPLEX_TYPE = "ComplexType";
    public static final String TOPLEVEL_TYPE = "DocumentTopLevel";
    public static final String VERSIONED_TYPE = "VersionableType";
    public static final String LEVEL1_TYPE = "DocumentLevel1";
    public static final String LEVEL2_TYPE = "DocumentLevel2";

    @Override
    public List<TypeDefinition> createTypesList() {
        return singletonTypes;
    }

    public static List<TypeDefinition> getTypesList() {
        return singletonTypes;
    }

    public static TypeDefinition getTypeById(String typeId) {
        for (TypeDefinition typeDef : singletonTypes) {
            if (!typeDef.getId().equals(typeId)) continue;
            return typeDef;
        }
        return null;
    }

    private static List<TypeDefinition> buildTypesList() {
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        InMemoryDocumentTypeDefinition cmisType1 = new InMemoryDocumentTypeDefinition("MyDocType1", "My Type 1 Level 1", InMemoryDocumentTypeDefinition.getRootDocumentType());
        typesList.add((TypeDefinition)cmisType1);
        InMemoryDocumentTypeDefinition cmisType2 = new InMemoryDocumentTypeDefinition("MyDocType2", "My Type 2 Level 1", InMemoryDocumentTypeDefinition.getRootDocumentType());
        typesList.add((TypeDefinition)cmisType2);
        InMemoryDocumentTypeDefinition cmisType11 = new InMemoryDocumentTypeDefinition("MyDocType1.1", "My Type 3 Level 2", cmisType1);
        typesList.add((TypeDefinition)cmisType11);
        InMemoryDocumentTypeDefinition cmisType111 = new InMemoryDocumentTypeDefinition("MyDocType1.1.1", "My Type 4 Level 3", cmisType11);
        typesList.add((TypeDefinition)cmisType111);
        InMemoryDocumentTypeDefinition cmisType112 = new InMemoryDocumentTypeDefinition("MyDocType1.1.2", "My Type 5 Level 3", cmisType11);
        typesList.add((TypeDefinition)cmisType112);
        InMemoryDocumentTypeDefinition cmisType12 = new InMemoryDocumentTypeDefinition("MyDocType1.2", "My Type 6 Level 2", cmisType1);
        typesList.add((TypeDefinition)cmisType12);
        InMemoryDocumentTypeDefinition cmisType21 = new InMemoryDocumentTypeDefinition("MyDocType2.1", "My Type 7 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType21);
        InMemoryDocumentTypeDefinition cmisType22 = new InMemoryDocumentTypeDefinition("MyDocType2.2", "My Type 8 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType22);
        InMemoryDocumentTypeDefinition cmisType23 = new InMemoryDocumentTypeDefinition("MyDocType2.3", "My Type 9 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType23);
        InMemoryDocumentTypeDefinition cmisType24 = new InMemoryDocumentTypeDefinition("MyDocType2.4", "My Type 10 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType24);
        InMemoryDocumentTypeDefinition cmisType25 = new InMemoryDocumentTypeDefinition("MyDocType2.5", "My Type 11 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType25);
        InMemoryDocumentTypeDefinition cmisType26 = new InMemoryDocumentTypeDefinition("MyDocType2.6", "My Type 12 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType26);
        InMemoryDocumentTypeDefinition cmisType27 = new InMemoryDocumentTypeDefinition("MyDocType2.7", "My Type 13 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType27);
        InMemoryDocumentTypeDefinition cmisType28 = new InMemoryDocumentTypeDefinition("MyDocType2.8", "My Type 14 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType28);
        InMemoryDocumentTypeDefinition cmisType29 = new InMemoryDocumentTypeDefinition("MyDocType2.9", "My Type 15 Level 2", cmisType2);
        typesList.add((TypeDefinition)cmisType29);
        InMemoryDocumentTypeDefinition cmisComplexType = new InMemoryDocumentTypeDefinition(COMPLEX_TYPE, "Complex type with properties, Level 1", InMemoryDocumentTypeDefinition.getRootDocumentType());
        HashMap propertyDefinitions = new HashMap();
        PropertyBooleanDefinitionImpl prop = PropertyCreationHelper.createBooleanDefinition("BooleanProp", "Sample Boolean Property");
        propertyDefinitions.put(prop.getId(), (PropertyDefinition<?>)prop);
        prop = PropertyCreationHelper.createBooleanMultiDefinition("BooleanPropMV", "Sample Boolean multi-value Property");
        propertyDefinitions.put(prop.getId(), (PropertyDefinition<?>)prop);
        PropertyDateTimeDefinitionImpl prop2 = PropertyCreationHelper.createDateTimeDefinition("DateTimeProp", "Sample DateTime Property");
        propertyDefinitions.put(prop2.getId(), (PropertyDefinition<?>)prop2);
        prop2 = PropertyCreationHelper.createDateTimeMultiDefinition("DateTimePropMV", "Sample DateTime multi-value Property");
        propertyDefinitions.put(prop2.getId(), (PropertyDefinition<?>)prop2);
        PropertyDecimalDefinitionImpl prop3 = PropertyCreationHelper.createDecimalDefinition("DecimalProp", "Sample Decimal Property");
        propertyDefinitions.put(prop3.getId(), (PropertyDefinition<?>)prop3);
        prop3 = PropertyCreationHelper.createDecimalMultiDefinition("DecimalPropMV", "Sample Decimal multi-value Property");
        propertyDefinitions.put(prop3.getId(), (PropertyDefinition<?>)prop3);
        PropertyHtmlDefinitionImpl prop4 = PropertyCreationHelper.createHtmlDefinition("HtmlProp", "Sample Html Property");
        propertyDefinitions.put(prop4.getId(), (PropertyDefinition<?>)prop4);
        prop4 = PropertyCreationHelper.createHtmlMultiDefinition("HtmlPropMV", "Sample Html multi-value Property");
        propertyDefinitions.put(prop4.getId(), (PropertyDefinition<?>)prop4);
        PropertyIdDefinitionImpl prop5 = PropertyCreationHelper.createIdDefinition("IdProp", "Sample Id Property");
        propertyDefinitions.put(prop5.getId(), (PropertyDefinition<?>)prop5);
        prop5 = PropertyCreationHelper.createIdMultiDefinition("IdPropMV", "Sample Id Html multi-value Property");
        propertyDefinitions.put(prop5.getId(), (PropertyDefinition<?>)prop5);
        PropertyIntegerDefinitionImpl prop6 = PropertyCreationHelper.createIntegerDefinition("IntProp", "Sample Int Property");
        propertyDefinitions.put(prop6.getId(), (PropertyDefinition<?>)prop6);
        prop6 = PropertyCreationHelper.createIntegerMultiDefinition("IntPropMV", "Sample Int multi-value Property");
        propertyDefinitions.put(prop6.getId(), (PropertyDefinition<?>)prop6);
        PropertyStringDefinitionImpl prop7 = PropertyCreationHelper.createStringDefinition("StringProp", "Sample String Property");
        propertyDefinitions.put(prop7.getId(), (PropertyDefinition<?>)prop7);
        PropertyUriDefinitionImpl prop8 = PropertyCreationHelper.createUriDefinition("UriProp", "Sample Uri Property");
        propertyDefinitions.put(prop8.getId(), (PropertyDefinition<?>)prop8);
        prop8 = PropertyCreationHelper.createUriMultiDefinition("UriPropMV", "Sample Uri multi-value Property");
        propertyDefinitions.put(prop8.getId(), (PropertyDefinition<?>)prop8);
        PropertyStringDefinitionImpl prop9 = PropertyCreationHelper.createStringDefinition("PickListProp", "Sample Pick List Property");
        ArrayList<ChoiceImpl> choiceList = new ArrayList<ChoiceImpl>();
        ChoiceImpl elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList("red"));
        choiceList.add(elem);
        elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList("green"));
        choiceList.add(elem);
        elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList("blue"));
        choiceList.add(elem);
        elem = new ChoiceImpl();
        elem.setValue(Collections.singletonList("black"));
        choiceList.add(elem);
        prop9.setChoices(choiceList);
        prop9.setDefaultValue(Collections.singletonList("blue"));
        propertyDefinitions.put(prop9.getId(), (PropertyDefinition<?>)prop9);
        cmisComplexType.setPropertyDefinitions(propertyDefinitions);
        typesList.add((TypeDefinition)cmisComplexType);
        InMemoryDocumentTypeDefinition cmisDocTypeTopLevel = new InMemoryDocumentTypeDefinition(TOPLEVEL_TYPE, "Document type with properties, Level 1", InMemoryDocumentTypeDefinition.getRootDocumentType());
        InMemoryDocumentTypeDefinition cmisDocTypeLevel1 = new InMemoryDocumentTypeDefinition(LEVEL1_TYPE, "Document type with inherited properties, Level 2", cmisDocTypeTopLevel);
        InMemoryDocumentTypeDefinition cmisDocTypeLevel2 = new InMemoryDocumentTypeDefinition(LEVEL2_TYPE, "Document type with inherited properties, Level 3", cmisDocTypeLevel1);
        propertyDefinitions = new HashMap();
        PropertyStringDefinitionImpl propTop = PropertyCreationHelper.createStringDefinition("StringPropTopLevel", "Sample String Property");
        propertyDefinitions.put(propTop.getId(), (PropertyDefinition<?>)propTop);
        cmisDocTypeTopLevel.setPropertyDefinitions(propertyDefinitions);
        propertyDefinitions = new HashMap();
        PropertyStringDefinitionImpl propLevel1 = PropertyCreationHelper.createStringDefinition("StringPropLevel1", "String Property Level 1");
        propertyDefinitions.put(propLevel1.getId(), (PropertyDefinition<?>)propLevel1);
        cmisDocTypeLevel1.setPropertyDefinitions(propertyDefinitions);
        propertyDefinitions = new HashMap();
        PropertyStringDefinitionImpl propLevel2 = PropertyCreationHelper.createStringDefinition("StringPropLevel2", "String Property Level 2");
        propertyDefinitions.put(propLevel2.getId(), (PropertyDefinition<?>)propLevel2);
        cmisDocTypeLevel2.setPropertyDefinitions(propertyDefinitions);
        typesList.add((TypeDefinition)cmisDocTypeTopLevel);
        typesList.add((TypeDefinition)cmisDocTypeLevel1);
        typesList.add((TypeDefinition)cmisDocTypeLevel2);
        InMemoryDocumentTypeDefinition cmisVersionedType = new InMemoryDocumentTypeDefinition(VERSIONED_TYPE, "VersionedType", InMemoryDocumentTypeDefinition.getRootDocumentType());
        propertyDefinitions = new HashMap();
        PropertyStringDefinitionImpl prop1 = PropertyCreationHelper.createStringDefinition("VersionedStringProp", "Sample String Property");
        propertyDefinitions.put(prop1.getId(), (PropertyDefinition<?>)prop1);
        cmisVersionedType.addCustomPropertyDefinitions(propertyDefinitions);
        cmisVersionedType.setIsVersionable(true);
        typesList.add((TypeDefinition)cmisVersionedType);
        return typesList;
    }
}

