/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.AbstractMultiFilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.DocumentVersionImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedDocumentImpl
extends AbstractMultiFilingImpl
implements VersionedDocument {
    private boolean fIsCheckedOut = false;
    private String fCheckedOutUser;
    private List<DocumentVersion> fVersions = new ArrayList<DocumentVersion>();

    public VersionedDocumentImpl(ObjectStoreImpl objStore) {
        super(objStore);
    }

    @Override
    public DocumentVersion addVersion(ContentStream content, VersioningState verState, String user) {
        if (this.isCheckedOut()) {
            throw new CmisConstraintException("Cannot add a version to document, document is checked out.");
        }
        DocumentVersionImpl ver = new DocumentVersionImpl(this.fRepositoryId, this, content, verState, this.fObjStore);
        ver.setSystemBasePropertiesWhenCreatedDirect(this.getName(), this.getTypeId(), user);
        ver.persist();
        this.fVersions.add(ver);
        if (verState == VersioningState.CHECKEDOUT) {
            this.fCheckedOutUser = user;
            this.fIsCheckedOut = true;
        }
        return ver;
    }

    @Override
    public boolean deleteVersion(DocumentVersion version) {
        if (this.fIsCheckedOut) {
            throw new CmisInvalidArgumentException("version cannot be deleted if document is checked-out: " + version.getId());
        }
        boolean found = this.fVersions.remove(version);
        if (!found) {
            throw new CmisInvalidArgumentException("Version is not contained in the document:" + version.getId());
        }
        return !this.fVersions.isEmpty();
    }

    @Override
    public void cancelCheckOut(String user) {
        DocumentVersion pwc = this.getPwc();
        this.fVersions.remove(pwc);
        this.fObjStore.removeVersion(pwc);
        this.fIsCheckedOut = false;
        this.fCheckedOutUser = null;
    }

    @Override
    public void checkIn(boolean isMajor, String checkinComment, String user) {
        if (this.fIsCheckedOut) {
            if (!this.fCheckedOutUser.equals(user)) {
                throw new CmisConstraintException("Error: Can't checkin. Document " + this.getId() + " user " + user + " has not checked out the document");
            }
        } else {
            throw new CmisConstraintException("Error: Can't cancel checkout, Document " + this.getId() + " is not checked out.");
        }
        this.fIsCheckedOut = false;
        this.fCheckedOutUser = null;
        DocumentVersion pwc = this.getPwc();
        pwc.setCheckinComment(checkinComment);
        pwc.commit(isMajor);
    }

    @Override
    public DocumentVersion checkOut(ContentStream content, String user) {
        if (this.fIsCheckedOut) {
            throw new CmisConstraintException("Error: Can't checkout, Document " + this.getId() + " is already checked out.");
        }
        DocumentVersion pwc = this.addVersion(content, VersioningState.CHECKEDOUT, user);
        return pwc;
    }

    @Override
    public List<DocumentVersion> getAllVersions() {
        return this.fVersions;
    }

    @Override
    public DocumentVersion getLatestVersion(boolean major) {
        DocumentVersion latest = null;
        if (major) {
            for (DocumentVersion ver : this.fVersions) {
                if (!ver.isMajor()) continue;
                latest = ver;
            }
        } else {
            latest = this.fVersions.get(this.fVersions.size() - 1);
        }
        return latest;
    }

    @Override
    public boolean isCheckedOut() {
        return this.fIsCheckedOut;
    }

    @Override
    public String getCheckedOutBy() {
        return this.fCheckedOutUser;
    }

    @Override
    public DocumentVersion getPwc() {
        for (DocumentVersion ver : this.fVersions) {
            if (!ver.isPwc()) continue;
            return ver;
        }
        return null;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        DocumentVersion pwc = this.getPwc();
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:versionSeriesId", requestedIds)) {
            properties.put("cmis:versionSeriesId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesId", this.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:isVersionSeriesCheckedOut", requestedIds)) {
            properties.put("cmis:isVersionSeriesCheckedOut", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(this.isCheckedOut())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutBy", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", this.getCheckedOutBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutId", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesCheckedOutId", pwc == null ? null : pwc.getId()));
        }
    }
}

