/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredObjectImpl
implements StoredObject {
    protected String fId;
    protected String fName;
    protected String fTypeId;
    protected String fCreatedBy;
    protected String fModifiedBy;
    protected GregorianCalendar fCreatedAt;
    protected GregorianCalendar fModifiedAt;
    protected String fRepositoryId;
    protected Map<String, PropertyData<?>> fProperties;
    protected ObjectStoreImpl fObjStore;

    StoredObjectImpl(ObjectStoreImpl objStore) {
        GregorianCalendar now = this.getNow();
        now.setTime(new Date());
        this.fCreatedAt = now;
        this.fModifiedAt = now;
        this.fObjStore = objStore;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setTypeId(String type) {
        this.fTypeId = type;
    }

    @Override
    public String getCreatedBy() {
        return this.fCreatedBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.fCreatedBy = createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.fModifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.fModifiedBy = modifiedBy;
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        return this.fCreatedAt;
    }

    @Override
    public void setCreatedAt(GregorianCalendar createdAt) {
        this.fCreatedAt = createdAt;
    }

    @Override
    public GregorianCalendar getModifiedAt() {
        return this.fModifiedAt;
    }

    @Override
    public void setModifiedAtNow() {
        this.fModifiedAt = this.getNow();
    }

    @Override
    public void setRepositoryId(String repositoryId) {
        this.fRepositoryId = repositoryId;
    }

    @Override
    public String getRepositoryId() {
        return this.fRepositoryId;
    }

    @Override
    public void setProperties(Map<String, PropertyData<?>> props) {
        this.fProperties = props;
    }

    @Override
    public Map<String, PropertyData<?>> getProperties() {
        return this.fProperties;
    }

    @Override
    public String getChangeToken() {
        GregorianCalendar lastModified = this.getModifiedAt();
        String token = Long.valueOf(lastModified.getTimeInMillis()).toString();
        return token;
    }

    @Override
    public void rename(String newName) {
        this.setName(newName);
    }

    @Override
    public void createSystemBasePropertiesWhenCreated(Map<String, PropertyData<?>> properties, String user) {
        this.addSystemBaseProperties(properties, user, true);
    }

    @Override
    public void updateSystemBasePropertiesWhenModified(Map<String, PropertyData<?>> properties, String user) {
        this.addSystemBaseProperties(properties, user, false);
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        if (FilterParser.isContainedInFilter("cmis:name", requestedIds)) {
            properties.put("cmis:name", (PropertyData<?>)objFactory.createPropertyStringData("cmis:name", this.getName()));
        }
        if (FilterParser.isContainedInFilter("cmis:objectId", requestedIds)) {
            properties.put("cmis:objectId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:objectId", this.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:objectTypeId", requestedIds)) {
            properties.put("cmis:objectTypeId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:objectTypeId", this.getTypeId()));
        }
        if (FilterParser.isContainedInFilter("cmis:createdBy", requestedIds)) {
            properties.put("cmis:createdBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:createdBy", this.getCreatedBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:creationDate", requestedIds)) {
            properties.put("cmis:creationDate", (PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:creationDate", this.getCreatedAt()));
        }
        if (FilterParser.isContainedInFilter("cmis:lastModifiedBy", requestedIds)) {
            properties.put("cmis:lastModifiedBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:lastModifiedBy", this.getModifiedBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:lastModificationDate", requestedIds)) {
            properties.put("cmis:lastModificationDate", (PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:lastModificationDate", this.getModifiedAt()));
        }
        if (FilterParser.isContainedInFilter("cmis:changeToken", requestedIds)) {
            String token = this.getChangeToken();
            properties.put("cmis:changeToken", (PropertyData<?>)objFactory.createPropertyStringData("cmis:changeToken", token));
        }
        if (null != this.fProperties) {
            for (Map.Entry<String, PropertyData<?>> prop : this.fProperties.entrySet()) {
                if (!FilterParser.isContainedInFilter(prop.getKey(), requestedIds)) continue;
                properties.put(prop.getKey(), prop.getValue());
            }
        }
    }

    @Override
    public void setCustomProperties(Map<String, PropertyData<?>> properties) {
        properties = new HashMap(properties);
        this.removeAllSystemProperties(properties);
        this.setProperties(properties);
    }

    private GregorianCalendar getNow() {
        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        return now;
    }

    private void addSystemBaseProperties(Map<String, PropertyData<?>> properties, String user, boolean isCreated) {
        if (user == null) {
            user = "unknown";
        }
        this.setModifiedBy(user);
        if (isCreated) {
            this.setCreatedBy(user);
            this.setName((String)properties.get("cmis:name").getFirstValue());
            this.setTypeId((String)properties.get("cmis:objectTypeId").getFirstValue());
        } else {
            this.setModifiedAtNow();
        }
    }

    protected void setSystemBasePropertiesWhenCreatedDirect(String name, String typeId, String user) {
        this.setModifiedBy(user);
        this.setCreatedBy(user);
        this.setName(name);
        this.setTypeId(typeId);
    }

    private void removeAllSystemProperties(Map<String, PropertyData<?>> properties) {
        if (properties.containsKey("cmis:name")) {
            properties.remove("cmis:name");
        }
        if (properties.containsKey("cmis:objectId")) {
            properties.remove("cmis:objectId");
        }
        if (properties.containsKey("cmis:objectTypeId")) {
            properties.remove("cmis:objectTypeId");
        }
        if (properties.containsKey("cmis:baseTypeId")) {
            properties.remove("cmis:baseTypeId");
        }
        if (properties.containsKey("cmis:createdBy")) {
            properties.remove("cmis:createdBy");
        }
        if (properties.containsKey("cmis:creationDate")) {
            properties.remove("cmis:creationDate");
        }
        if (properties.containsKey("cmis:lastModifiedBy")) {
            properties.remove("cmis:lastModifiedBy");
        }
        if (properties.containsKey("cmis:lastModificationDate")) {
            properties.remove("cmis:lastModificationDate");
        }
        if (properties.containsKey("cmis:changeToken")) {
            properties.remove("cmis:changeToken");
        }
        if (properties.containsKey("cmis:isImmutable")) {
            properties.remove("cmis:isImmutable");
        }
        if (properties.containsKey("cmis:isLatestVersion")) {
            properties.remove("cmis:isLatestVersion");
        }
        if (properties.containsKey("cmis:isMajorVersion")) {
            properties.remove("cmis:isMajorVersion");
        }
        if (properties.containsKey("cmis:isLatestMajorVersion")) {
            properties.remove("cmis:isLatestMajorVersion");
        }
        if (properties.containsKey("cmis:versionLabel")) {
            properties.remove("cmis:versionLabel");
        }
        if (properties.containsKey("cmis:versionSeriesId")) {
            properties.remove("cmis:versionSeriesId");
        }
        if (properties.containsKey("cmis:isVersionSeriesCheckedOut")) {
            properties.remove("cmis:isVersionSeriesCheckedOut");
        }
        if (properties.containsKey("cmis:versionSeriesCheckedOutBy")) {
            properties.remove("cmis:versionSeriesCheckedOutBy");
        }
        if (properties.containsKey("cmis:versionSeriesCheckedOutId")) {
            properties.remove("cmis:versionSeriesCheckedOutId");
        }
        if (properties.containsKey("cmis:checkinComment")) {
            properties.remove("cmis:checkinComment");
        }
        if (properties.containsKey("cmis:contentStreamLength")) {
            properties.remove("cmis:contentStreamLength");
        }
        if (properties.containsKey("cmis:contentStreamMimeType")) {
            properties.remove("cmis:contentStreamMimeType");
        }
        if (properties.containsKey("cmis:contentStreamFileName")) {
            properties.remove("cmis:contentStreamFileName");
        }
        if (properties.containsKey("cmis:contentStreamId")) {
            properties.remove("cmis:contentStreamId");
        }
        if (properties.containsKey("cmis:parentId")) {
            properties.remove("cmis:parentId");
        }
        if (properties.containsKey("cmis:allowedChildObjectTypeIds")) {
            properties.remove("cmis:allowedChildObjectTypeIds");
        }
        if (properties.containsKey("cmis:path")) {
            properties.remove("cmis:path");
        }
        if (properties.containsKey("cmis:sourceId")) {
            properties.remove("cmis:sourceId");
        }
        if (properties.containsKey("cmis:targetId")) {
            properties.remove("cmis:targetId");
        }
        if (properties.containsKey("cmis:policyText")) {
            properties.remove("cmis:policyText");
        }
    }

    @Override
    public void persist() {
        this.fId = this.fObjStore.storeObject(this);
    }
}

