/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.RepositoryInfoCreator;
import org.apache.chemistry.opencmis.inmemory.TypeCreator;
import org.apache.chemistry.opencmis.inmemory.TypeManagerImpl;
import org.apache.chemistry.opencmis.inmemory.query.InMemoryQueryProcessor;
import org.apache.chemistry.opencmis.inmemory.server.BaseServiceValidatorImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.CmisServiceValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreManagerImpl
implements StoreManager {
    private static Log LOG = LogFactory.getLog(StoreManagerImpl.class);
    protected BindingsObjectFactory fObjectFactory;
    protected RepositoryInfo fRepositoryInfo;
    protected CmisServiceValidator validator;
    private Map<String, TypeManagerImpl> fMapRepositoryToTypeManager = new HashMap<String, TypeManagerImpl>();
    private Map<String, ObjectStore> fMapRepositoryToObjectStore = new HashMap<String, ObjectStore>();

    public ObjectStoreImpl getStore(String repositoryId) {
        return (ObjectStoreImpl)this.fMapRepositoryToObjectStore.get(repositoryId);
    }

    public StoreManagerImpl() {
        this.fObjectFactory = new BindingsObjectFactoryImpl();
    }

    @Override
    public List<String> getAllRepositoryIds() {
        Set<String> repIds = this.fMapRepositoryToObjectStore.keySet();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(repIds);
        return result;
    }

    @Override
    public void initRepository(String repositoryId) {
        this.fMapRepositoryToObjectStore.put(repositoryId, new ObjectStoreImpl(repositoryId));
        this.fMapRepositoryToTypeManager.put(repositoryId, new TypeManagerImpl());
    }

    @Override
    public void createAndInitRepository(String repositoryId, String typeCreatorClassName) {
        if (this.fMapRepositoryToObjectStore.containsKey(repositoryId) || this.fMapRepositoryToTypeManager.containsKey(repositoryId)) {
            throw new RuntimeException("Cannot add repository, repository " + repositoryId + " already exists.");
        }
        this.fMapRepositoryToObjectStore.put(repositoryId, new ObjectStoreImpl(repositoryId));
        this.fMapRepositoryToTypeManager.put(repositoryId, new TypeManagerImpl());
        this.initTypeSystem(repositoryId, typeCreatorClassName);
    }

    @Override
    public ObjectStore getObjectStore(String repositoryId) {
        return this.fMapRepositoryToObjectStore.get(repositoryId);
    }

    @Override
    public CmisServiceValidator getServiceValidator() {
        return new BaseServiceValidatorImpl(this);
    }

    @Override
    public BindingsObjectFactory getObjectFactory() {
        return this.fObjectFactory;
    }

    @Override
    public TypeDefinitionContainer getTypeById(String repositoryId, String typeId) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new RuntimeException("Unknown repository " + repositoryId);
        }
        return typeManager.getTypeById(typeId);
    }

    @Override
    public TypeDefinitionContainer getTypeById(String repositoryId, String typeId, boolean includePropertyDefinitions, int depth) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException("Unknown repository " + repositoryId);
        }
        TypeDefinitionContainer tc = typeManager.getTypeById(typeId);
        List result = null;
        if (tc != null) {
            if (depth == -1) {
                result = tc.getChildren();
                if (!includePropertyDefinitions) {
                    this.cloneTypeList(depth - 1, false, result);
                }
            } else {
                if (depth == 0 || depth < -1) {
                    throw new CmisInvalidArgumentException("illegal depth value: " + depth);
                }
                result = tc.getChildren();
                this.cloneTypeList(depth - 1, includePropertyDefinitions, result);
            }
        }
        return tc;
    }

    @Override
    public Collection<TypeDefinitionContainer> getTypeDefinitionList(String repositoryId, boolean includePropertyDefinitions) {
        ArrayList<TypeDefinitionContainerImpl> result;
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException("Unknown repository " + repositoryId);
        }
        ArrayList<TypeDefinitionContainerImpl> typeColl = typeManager.getTypeDefinitionList();
        if (includePropertyDefinitions) {
            result = typeColl;
        } else {
            result = new ArrayList<TypeDefinitionContainerImpl>(typeColl.size());
            for (TypeDefinitionContainer typeDefinitionContainer : typeColl) {
                AbstractTypeDefinition td = ((AbstractTypeDefinition)typeDefinitionContainer.getTypeDefinition()).clone();
                TypeDefinitionContainerImpl tdc = new TypeDefinitionContainerImpl((TypeDefinition)td);
                tdc.setChildren(typeDefinitionContainer.getChildren());
                td.setPropertyDefinitions(null);
                result.add(tdc);
            }
        }
        return result;
    }

    public Map<String, TypeDefinitionContainer> getTypeDefinitionMap(String repositoryId) {
        return null;
    }

    @Override
    public List<TypeDefinitionContainer> getRootTypes(String repositoryId) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException("Unknown repository " + repositoryId);
        }
        List rootTypes = typeManager.getRootTypes();
        return rootTypes;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId) {
        ObjectStore sm = this.fMapRepositoryToObjectStore.get(repositoryId);
        if (null == sm) {
            return null;
        }
        RepositoryInfo repoInfo = this.createDefaultRepositoryInfo(repositoryId);
        return repoInfo;
    }

    public void clearTypeSystem(String repositoryId) {
        TypeManagerImpl typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new CmisInvalidArgumentException("Unknown repository " + repositoryId);
        }
        typeManager.clearTypeSystem();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initRepositoryInfo(String repositoryId, String repoInfoCreatorClassName) {
        RepositoryInfoCreator repoCreator = null;
        if (repoInfoCreatorClassName != null) {
            Object obj = null;
            try {
                obj = Class.forName(repoInfoCreatorClassName).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Illegal class to create type system, must implement RepositoryInfoCreator interface.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal class to create type system, must implement RepositoryInfoCreator interface.", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Illegal class to create type system, must implement RepositoryInfoCreator interface.", e);
            }
            if (!(obj instanceof RepositoryInfoCreator)) throw new RuntimeException("Illegal class to create repository info, must implement RepositoryInfoCreator interface.");
            repoCreator = obj;
            this.fRepositoryInfo = repoCreator.createRepositoryInfo();
            return;
        }
        this.createDefaultRepositoryInfo(repositoryId);
    }

    public List<TypeDefinition> initTypeSystem(String typeCreatorClassName) {
        List<TypeDefinition> typesList = null;
        if (typeCreatorClassName != null) {
            Object obj = null;
            TypeCreator typeCreator = null;
            try {
                obj = Class.forName(typeCreatorClassName).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Illegal class to create type system, must implement TypeCreator interface.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal class to create type system, must implement TypeCreator interface.", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Illegal class to create type system, must implement TypeCreator interface.", e);
            }
            if (!(obj instanceof TypeCreator)) {
                throw new RuntimeException("Illegal class to create type system, must implement TypeCreator interface.");
            }
            typeCreator = obj;
            typesList = typeCreator.createTypesList();
        }
        return typesList;
    }

    private void initTypeSystem(String repositoryId, String typeCreatorClassName) {
        List<TypeDefinition> typeDefs = null;
        TypeManagerImpl typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        if (null == typeManager) {
            throw new RuntimeException("Unknown repository " + repositoryId);
        }
        if (null != typeCreatorClassName) {
            typeDefs = this.initTypeSystem(typeCreatorClassName);
        }
        typeManager.initTypeSystem(typeDefs);
    }

    private RepositoryInfo createDefaultRepositoryInfo(String repositoryId) {
        ObjectStore objStore = this.getObjectStore(repositoryId);
        String rootFolderId = objStore.getRootFolder().getId();
        RepositoryInfoImpl repoInfo = new RepositoryInfoImpl();
        repoInfo.setId(repositoryId == null ? "inMem" : repositoryId);
        repoInfo.setName("InMemory Repository");
        repoInfo.setDescription("InMemory Test Repository");
        repoInfo.setCmisVersionSupported("1.0");
        repoInfo.setCapabilities(null);
        repoInfo.setRootFolder(rootFolderId);
        repoInfo.setPrincipalAnonymous("anonymous");
        repoInfo.setPrincipalAnyone("anyone");
        repoInfo.setThinClientUri(null);
        repoInfo.setChangesIncomplete(Boolean.TRUE);
        repoInfo.setChangesOnType(null);
        repoInfo.setLatestChangeLogToken(null);
        repoInfo.setVendorName("OpenCMIS");
        repoInfo.setProductName("OpenCMIS InMemory-Server");
        repoInfo.setProductVersion("0.1");
        RepositoryCapabilitiesImpl caps = new RepositoryCapabilitiesImpl();
        caps.setAllVersionsSearchable(Boolean.valueOf(false));
        caps.setCapabilityAcl(CapabilityAcl.NONE);
        caps.setCapabilityChanges(CapabilityChanges.PROPERTIES);
        caps.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.PWCONLY);
        caps.setCapabilityJoin(CapabilityJoin.NONE);
        caps.setCapabilityQuery(CapabilityQuery.METADATAONLY);
        caps.setCapabilityRendition(CapabilityRenditions.NONE);
        caps.setIsPwcSearchable(Boolean.valueOf(false));
        caps.setIsPwcUpdatable(Boolean.valueOf(true));
        caps.setSupportsGetDescendants(Boolean.valueOf(true));
        caps.setSupportsGetFolderTree(Boolean.valueOf(true));
        caps.setSupportsMultifiling(Boolean.valueOf(true));
        caps.setSupportsUnfiling(Boolean.valueOf(true));
        caps.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        repoInfo.setCapabilities((RepositoryCapabilities)caps);
        repoInfo.setAclCapabilities(null);
        this.fRepositoryInfo = repoInfo;
        return repoInfo;
    }

    private void cloneTypeList(int depth, boolean includePropertyDefinitions, List<TypeDefinitionContainer> types) {
        ListIterator<TypeDefinitionContainer> it = types.listIterator();
        while (it.hasNext()) {
            TypeDefinitionContainer tdc = it.next();
            AbstractTypeDefinition td = ((AbstractTypeDefinition)tdc.getTypeDefinition()).clone();
            if (!includePropertyDefinitions) {
                td.setPropertyDefinitions(null);
            }
            TypeDefinitionContainerImpl tdcClone = new TypeDefinitionContainerImpl((TypeDefinition)td);
            if (depth > 0) {
                ArrayList<TypeDefinitionContainer> children = new ArrayList<TypeDefinitionContainer>(tdc.getChildren().size());
                children.addAll(tdc.getChildren());
                tdcClone.setChildren(children);
                this.cloneTypeList(depth - 1, includePropertyDefinitions, children);
            }
            it.set((TypeDefinitionContainer)tdcClone);
        }
    }

    @Override
    public TypeManager getTypeManager(String repositoryId) {
        TypeManager typeManager = this.fMapRepositoryToTypeManager.get(repositoryId);
        return typeManager;
    }

    @Override
    public ObjectList query(String user, String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        TypeManager tm = this.getTypeManager(repositoryId);
        ObjectStore objectStore = this.getObjectStore(repositoryId);
        InMemoryQueryProcessor queryProcessor = new InMemoryQueryProcessor();
        ObjectList objList = queryProcessor.query(tm, objectStore, user, repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount);
        LOG.debug((Object)("Query result, number of matching objects: " + objList.getNumItems()));
        return objList;
    }
}

