/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreManagerFactory {
    private static Log log = LogFactory.getLog(StoreManagerFactory.class);

    public static StoreManager createInstance(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String msg = "Failed to create StoredObjectCreator, class " + className + " does not exist.";
            log.error((Object)msg, (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(msg, e);
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Failed to create StoredObjectCreator from class " + className), (Throwable)e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Failed to create StoredObjectCreator from class " + className), (Throwable)e);
            e.printStackTrace();
        }
        if (obj instanceof StoreManager) {
            return obj;
        }
        log.error((Object)("Failed to create StoredObjectCreator, class " + className + " does not implement interface StoredObjectCreator"));
        return null;
    }
}

