/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.SingleFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.DocumentImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FolderImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.VersionedDocumentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreImpl
implements ObjectStore {
    private static int NEXT_UNUSED_ID = 100;
    private Map<String, StoredObject> fStoredObjectMap = new ConcurrentHashMap<String, StoredObject>();
    private Lock fLock = new ReentrantLock();
    final String fRepositoryId;
    FolderImpl fRootFolder = null;

    public ObjectStoreImpl(String repositoryId) {
        this.fRepositoryId = repositoryId;
        this.createRootFolder();
    }

    private static synchronized Integer getNextId() {
        return NEXT_UNUSED_ID++;
    }

    public void lock() {
        this.fLock.lock();
    }

    public void unlock() {
        this.fLock.unlock();
    }

    @Override
    public Folder getRootFolder() {
        return this.fRootFolder;
    }

    @Override
    public StoredObject getObjectByPath(String path) {
        for (StoredObject so : this.fStoredObjectMap.values()) {
            if (so instanceof SingleFiling) {
                String soPath = ((SingleFiling)((Object)so)).getPath();
                if (!soPath.equals(path)) continue;
                return so;
            }
            if (so instanceof MultiFiling) {
                MultiFiling mfo = (MultiFiling)((Object)so);
                List<Folder> parents = mfo.getParents();
                for (Folder parent : parents) {
                    String parentPath = parent.getPath();
                    String mfPath = parentPath.equals("/") ? parentPath + mfo.getPathSegment() : parentPath + "/" + mfo.getPathSegment();
                    if (!mfPath.equals(path)) continue;
                    return so;
                }
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    public StoredObject getObjectById(String objectId) {
        StoredObject so = this.fStoredObjectMap.get(objectId);
        return so;
    }

    @Override
    public void deleteObject(String objectId) {
        String path = objectId;
        StoredObject obj = this.fStoredObjectMap.get(path);
        if (null == obj) {
            throw new RuntimeException("Cannot delete object with id  " + objectId + ". Object does not exist.");
        }
        if (obj instanceof FolderImpl) {
            this.deleteFolder(objectId);
        } else if (obj instanceof DocumentVersion) {
            DocumentVersion vers = (DocumentVersion)obj;
            VersionedDocument parentDoc = vers.getParentDocument();
            this.fStoredObjectMap.remove(path);
            boolean otherVersionsExist = vers.getParentDocument().deleteVersion(vers);
            if (!otherVersionsExist) {
                this.fStoredObjectMap.remove(parentDoc.getId());
            }
        } else {
            this.fStoredObjectMap.remove(path);
        }
    }

    public void removeVersion(DocumentVersion vers) {
        StoredObject found = this.fStoredObjectMap.remove(vers.getId());
        if (null == found) {
            throw new CmisInvalidArgumentException("Cannot delete object with id  " + vers.getId() + ". Object does not exist.");
        }
    }

    public String storeObject(StoredObject so) {
        String id = so.getId();
        if (null == id) {
            id = ObjectStoreImpl.getNextId().toString();
        }
        this.fStoredObjectMap.put(id, so);
        return id;
    }

    StoredObject getObject(String id) {
        return this.fStoredObjectMap.get(id);
    }

    void removeObject(String id) {
        this.fStoredObjectMap.remove(id);
    }

    public Set<String> getIds() {
        Set<String> entries = this.fStoredObjectMap.keySet();
        return entries;
    }

    private void createRootFolder() {
        FolderImpl rootFolder = new FolderImpl(this);
        rootFolder.setName("RootFolder");
        rootFolder.setParent(null);
        rootFolder.setTypeId(BaseTypeId.CMIS_FOLDER.value());
        rootFolder.setCreatedBy("Admin");
        rootFolder.setModifiedBy("Admin");
        rootFolder.setModifiedAtNow();
        rootFolder.setRepositoryId(this.fRepositoryId);
        rootFolder.persist();
        this.fRootFolder = rootFolder;
    }

    @Override
    public Document createDocument(String name) {
        DocumentImpl doc = new DocumentImpl(this);
        doc.setRepositoryId(this.fRepositoryId);
        doc.setName(name);
        return doc;
    }

    @Override
    public VersionedDocument createVersionedDocument(String name) {
        VersionedDocumentImpl doc = new VersionedDocumentImpl(this);
        doc.setRepositoryId(this.fRepositoryId);
        doc.setName(name);
        return doc;
    }

    @Override
    public Folder createFolder(String name) {
        FolderImpl folder = new FolderImpl(this, name, null);
        folder.setRepositoryId(this.fRepositoryId);
        return folder;
    }

    @Override
    public List<VersionedDocument> getCheckedOutDocuments(String orderBy) {
        ArrayList<VersionedDocument> res = new ArrayList<VersionedDocument>();
        for (StoredObject so : this.fStoredObjectMap.values()) {
            VersionedDocument verDoc;
            if (!(so instanceof VersionedDocument) || !(verDoc = (VersionedDocument)so).isCheckedOut()) continue;
            res.add(verDoc);
        }
        return res;
    }

    private void deleteFolder(String folderId) {
        StoredObject folder = this.fStoredObjectMap.get(folderId);
        if (folder == null) {
            throw new CmisInvalidArgumentException("Unknown object with id:  " + folderId);
        }
        if (!(folder instanceof FolderImpl)) {
            throw new CmisInvalidArgumentException("Cannot delete folder with id:  " + folderId + ". Object exists but is not a folder.");
        }
        List<StoredObject> children = ((Folder)folder).getChildren(-1, -1);
        if (children != null && !children.isEmpty()) {
            throw new CmisConstraintException("Cannot delete folder with id:  " + folderId + ". Folder is not empty.");
        }
        this.fStoredObjectMap.remove(folderId);
    }
}

