/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Filing;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.SingleFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.AbstractSingleFilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderImpl
extends AbstractSingleFilingImpl
implements Folder {
    private static final Log LOG = LogFactory.getLog((String)AbstractSingleFilingImpl.class.getName());

    FolderImpl(ObjectStoreImpl objStore) {
        super(objStore);
    }

    public FolderImpl(ObjectStoreImpl objStore, String name, Folder parent) {
        super(objStore);
        this.init(name, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildFolder(Folder folder) {
        try {
            this.fObjStore.lock();
            String name = folder.getName();
            boolean hasChild = this.hasChild(name);
            if (hasChild) {
                throw new CmisNameConstraintViolationException("Cannot create folder " + name + ". Name already exists in parent folder");
            }
            folder.setParent(this);
            folder.persist();
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    @Override
    public void addChildDocument(Document doc) {
        this.addChildObject(doc);
    }

    @Override
    public void addChildDocument(VersionedDocument doc) {
        this.addChildObject(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildObject(StoredObject so) {
        try {
            this.fObjStore.lock();
            String name = so.getName();
            if (!NameValidator.isValidId(name)) {
                throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
            }
            boolean hasChild = this.hasChild(name);
            if (hasChild) {
                throw new CmisNameConstraintViolationException("Cannot create object: " + name + ". Name already exists in parent folder");
            }
            if (so instanceof SingleFiling) {
                ((SingleFiling)((Object)so)).setParent(this);
            } else if (so instanceof MultiFiling) {
                ((MultiFiling)((Object)so)).addParent(this);
            } else {
                throw new CmisInvalidArgumentException("Cannot create document, object is not fileable.");
            }
            so.persist();
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    @Override
    public List<StoredObject> getChildren(int maxItems, int skipCount) {
        ArrayList<StoredObject> result = new ArrayList<StoredObject>();
        for (String id : this.fObjStore.getIds()) {
            StoredObject obj = this.fObjStore.getObject(id);
            Filing pathObj = (Filing)((Object)obj);
            if (!pathObj.getParents().contains(this)) continue;
            if (pathObj instanceof VersionedDocument) {
                DocumentVersion ver = ((VersionedDocument)pathObj).getLatestVersion(false);
                result.add(ver);
                continue;
            }
            if (pathObj instanceof DocumentVersion) continue;
            result.add(obj);
        }
        this.sortFolderList(result);
        if (maxItems < 0) {
            maxItems = result.size();
        }
        if (skipCount < 0) {
            skipCount = 0;
        }
        int from = Math.min(skipCount, result.size());
        int to = Math.min(maxItems + from, result.size());
        result = result.subList(from, to);
        return result;
    }

    @Override
    public List<Folder> getFolderChildren(int maxItems, int skipCount) {
        ArrayList<Folder> result = new ArrayList();
        for (String id : this.fObjStore.getIds()) {
            SingleFiling pathObj;
            StoredObject obj = this.fObjStore.getObject(id);
            if (!(obj instanceof SingleFiling) || (pathObj = (SingleFiling)((Object)obj)).getParent() != this || !(pathObj instanceof Folder)) continue;
            result.add((Folder)obj);
        }
        this.sortFolderList(result);
        int from = Math.min(skipCount, result.size());
        int to = Math.min(maxItems + from, result.size());
        result = result.subList(from, to);
        return result;
    }

    @Override
    public boolean hasChild(String name) {
        for (String id : this.fObjStore.getIds()) {
            Filing pathObj;
            StoredObject obj = this.fObjStore.getObject(id);
            if (!(obj instanceof Filing) || !(pathObj = (Filing)((Object)obj)).getParents().contains(this) || !obj.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:parentId", requestedIds)) {
            String parentId;
            String string = parentId = this.getParent() == null ? null : this.getParent().getId();
            if (parentId != null) {
                properties.put("cmis:parentId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:parentId", parentId));
            }
        }
        if (FilterParser.isContainedInFilter("cmis:allowedChildObjectTypeIds", requestedIds)) {
            String allowedChildObjects = "*";
            properties.put("cmis:allowedChildObjectTypeIds", (PropertyData<?>)objFactory.createPropertyIdData("cmis:allowedChildObjectTypeIds", allowedChildObjects));
        }
        if (FilterParser.isContainedInFilter("cmis:path", requestedIds)) {
            String path = this.getPath();
            properties.put("cmis:path", (PropertyData<?>)objFactory.createPropertyStringData("cmis:path", path));
        }
    }

    private void init(String name, Folder parent) {
        if (!NameValidator.isValidId(name)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        this.setName(name);
        this.setParent(parent);
    }

    private void sortFolderList(List<? extends StoredObject> list) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FolderComparator
        implements Comparator<StoredObject> {
            FolderComparator() {
            }

            @Override
            public int compare(StoredObject f1, StoredObject f2) {
                String segment1 = f1.getName();
                String segment2 = f2.getName();
                return segment1.compareTo(segment2);
            }
        }
        Collections.sort(list, new FolderComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildDocument(StoredObject so, Folder oldParent, Folder newParent) {
        try {
            this.fObjStore.lock();
            if (newParent.hasChild(so.getName())) {
                throw new IllegalArgumentException("Cannot move object, this name already exists in target.");
            }
            if (!(so instanceof Filing)) {
                throw new IllegalArgumentException("Cannot move object, object does not have a path.");
            }
            if (so instanceof SingleFiling) {
                SingleFiling pathObj = (SingleFiling)((Object)so);
                pathObj.setParent(newParent);
            } else if (so instanceof MultiFiling) {
                MultiFiling pathObj = (MultiFiling)((Object)so);
                pathObj.addParent(newParent);
                pathObj.removeParent(oldParent);
            }
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    @Override
    public List<String> getAllowedChildObjectTypeIds() {
        return null;
    }
}

