/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentVersionImpl
extends StoredObjectImpl
implements DocumentVersion {
    private ContentStreamDataImpl fContent;
    private VersionedDocument fContainer;
    private String fComment;
    boolean fIsMajor;
    boolean fIsPwc;

    public DocumentVersionImpl(String repositoryId, VersionedDocument container, ContentStream content, VersioningState verState, ObjectStoreImpl objStore) {
        super(objStore);
        this.setRepositoryId(repositoryId);
        this.fContainer = container;
        this.setContent(content, false);
        this.fIsMajor = verState == VersioningState.MAJOR;
        this.fIsPwc = verState == VersioningState.CHECKEDOUT;
        this.fProperties = new HashMap();
    }

    @Override
    public void setContent(ContentStream content, boolean mustPersist) {
        if (null == content) {
            this.fContent = null;
        } else {
            this.fContent = new ContentStreamDataImpl();
            this.fContent.setFileName(content.getFileName());
            this.fContent.setMimeType(content.getMimeType());
            try {
                this.fContent.setContent(content.getStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to get content from InputStream", e);
            }
        }
    }

    @Override
    public void setCheckinComment(String comment) {
        this.fComment = comment;
    }

    @Override
    public String getCheckinComment() {
        return this.fComment;
    }

    @Override
    public String getVersionLabel() {
        int majorNo = 0;
        int minorNo = 0;
        List<DocumentVersion> allVersions = this.fContainer.getAllVersions();
        for (DocumentVersion ver : allVersions) {
            if (ver.isMajor()) {
                ++majorNo;
                minorNo = 0;
            } else {
                ++minorNo;
            }
            if (ver != this) continue;
            break;
        }
        String label = "V " + majorNo + "." + minorNo;
        return label;
    }

    @Override
    public boolean isMajor() {
        return this.fIsMajor && !this.isPwc();
    }

    @Override
    public boolean isPwc() {
        return this.fIsPwc;
    }

    @Override
    public void commit(boolean isMajor) {
        this.fIsPwc = false;
        this.fIsMajor = isMajor;
    }

    @Override
    public ContentStream getContent(long offset, long length) {
        if (offset <= 0L && length < 0L) {
            return this.fContent;
        }
        return this.fContent.getCloneWithLimits(offset, length);
    }

    @Override
    public VersionedDocument getParentDocument() {
        return this.fContainer;
    }

    private boolean isLatestVersion() {
        List<DocumentVersion> allVers = this.fContainer.getAllVersions();
        boolean isLatestVersion = this.isPwc() ? allVers.size() > 1 && allVers.get(allVers.size() - 2).equals(this) : allVers.get(allVers.size() - 1).equals(this);
        return isLatestVersion;
    }

    private boolean isLatestMajorVersion() {
        if (!this.fIsMajor) {
            return false;
        }
        List<DocumentVersion> allVersions = this.fContainer.getAllVersions();
        DocumentVersion latestMajor = null;
        for (DocumentVersion ver : allVersions) {
            if (!ver.isMajor() || ver.isPwc()) continue;
            latestMajor = ver;
        }
        boolean isLatestMajorVersion = latestMajor == this;
        return isLatestMajorVersion;
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        DocumentVersion pwc = this.fContainer.getPwc();
        this.fContainer.fillProperties(properties, objFactory, requestedIds);
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:isLatestVersion", requestedIds)) {
            properties.put("cmis:isLatestVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestVersion", Boolean.valueOf(this.isLatestVersion())));
        }
        if (FilterParser.isContainedInFilter("cmis:isMajorVersion", requestedIds)) {
            properties.put("cmis:isMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isMajorVersion", Boolean.valueOf(this.fIsMajor)));
        }
        if (FilterParser.isContainedInFilter("cmis:isLatestMajorVersion", requestedIds)) {
            properties.put("cmis:isLatestMajorVersion", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isLatestMajorVersion", Boolean.valueOf(this.isLatestMajorVersion())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesId", requestedIds)) {
            properties.put("cmis:versionSeriesId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesId", this.fContainer.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:isVersionSeriesCheckedOut", requestedIds)) {
            properties.put("cmis:isVersionSeriesCheckedOut", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(this.fContainer.isCheckedOut())));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutBy", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutBy", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", this.fContainer.getCheckedOutBy()));
        }
        if (FilterParser.isContainedInFilter("cmis:versionSeriesCheckedOutId", requestedIds)) {
            properties.put("cmis:versionSeriesCheckedOutId", (PropertyData<?>)objFactory.createPropertyIdData("cmis:versionSeriesCheckedOutId", pwc == null ? null : pwc.getId()));
        }
        if (FilterParser.isContainedInFilter("cmis:checkinComment", requestedIds)) {
            properties.put("cmis:checkinComment", (PropertyData<?>)objFactory.createPropertyStringData("cmis:checkinComment", this.fComment));
        }
        if (FilterParser.isContainedInFilter("cmis:versionLabel", requestedIds)) {
            properties.put("cmis:versionLabel", (PropertyData<?>)objFactory.createPropertyStringData("cmis:versionLabel", this.getVersionLabel()));
        }
        if (null != this.fContent) {
            if (FilterParser.isContainedInFilter("cmis:contentStreamFileName", requestedIds)) {
                properties.put("cmis:contentStreamFileName", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamFileName", this.fContent.getFileName()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamLength", requestedIds)) {
                properties.put("cmis:contentStreamLength", (PropertyData<?>)objFactory.createPropertyIntegerData("cmis:contentStreamLength", this.fContent.getBigLength()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamMimeType", requestedIds)) {
                properties.put("cmis:contentStreamMimeType", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamMimeType", this.fContent.getMimeType()));
            }
        }
    }

    @Override
    public List<Folder> getParents() {
        return this.fContainer.getParents();
    }

    @Override
    public String getPathSegment() {
        return this.fContainer.getPathSegment();
    }

    @Override
    public void move(Folder oldParent, Folder newParent) {
        this.fContainer.move(oldParent, newParent);
    }

    @Override
    public void addParent(Folder parent) {
        this.fContainer.addParent(parent);
    }

    @Override
    public void removeParent(Folder parent) {
        this.fContainer.removeParent(parent);
    }

    @Override
    public boolean hasContent() {
        return null != this.fContent;
    }

    @Override
    public boolean hasParent() {
        return true;
    }
}

