/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.AbstractMultiFilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.AbstractSingleFilingImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentImpl
extends AbstractMultiFilingImpl
implements Document {
    private ContentStreamDataImpl fContent;
    private static final Log LOG = LogFactory.getLog((String)AbstractSingleFilingImpl.class.getName());

    DocumentImpl(ObjectStoreImpl objStore) {
        super(objStore);
    }

    @Override
    public ContentStream getContent(long offset, long length) {
        if (null == this.fContent) {
            return null;
        }
        if (offset <= 0L && length < 0L) {
            return this.fContent;
        }
        return this.fContent.getCloneWithLimits(offset, length);
    }

    @Override
    public void setContent(ContentStream content, boolean mustPersist) {
        if (null == content) {
            this.fContent = null;
        } else {
            this.fContent = new ContentStreamDataImpl();
            String fileName = content.getFileName();
            if (null == fileName || fileName.length() <= 0) {
                fileName = this.getName();
            }
            this.fContent.setFileName(fileName);
            String mimeType = content.getMimeType();
            if (null == mimeType || mimeType.length() <= 0) {
                mimeType = "application/octet-stream";
            }
            this.fContent.setMimeType(mimeType);
            try {
                this.fContent.setContent(content.getStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to get content from InputStream", e);
            }
        }
    }

    @Override
    public void fillProperties(Map<String, PropertyData<?>> properties, BindingsObjectFactory objFactory, List<String> requestedIds) {
        super.fillProperties(properties, objFactory, requestedIds);
        if (FilterParser.isContainedInFilter("cmis:isImmutable", requestedIds)) {
            properties.put("cmis:isImmutable", (PropertyData<?>)objFactory.createPropertyBooleanData("cmis:isImmutable", Boolean.valueOf(false)));
        }
        if (null != this.fContent) {
            if (FilterParser.isContainedInFilter("cmis:contentStreamFileName", requestedIds)) {
                properties.put("cmis:contentStreamFileName", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamFileName", this.fContent.getFileName()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamLength", requestedIds)) {
                properties.put("cmis:contentStreamLength", (PropertyData<?>)objFactory.createPropertyIntegerData("cmis:contentStreamLength", this.fContent.getBigLength()));
            }
            if (FilterParser.isContainedInFilter("cmis:contentStreamMimeType", requestedIds)) {
                properties.put("cmis:contentStreamMimeType", (PropertyData<?>)objFactory.createPropertyStringData("cmis:contentStreamMimeType", this.fContent.getMimeType()));
            }
        }
    }

    @Override
    public boolean hasContent() {
        return null != this.fContent;
    }
}

