/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentStreamDataImpl
implements ContentStream {
    private int fLength;
    private String fMimeType;
    private String fFileName;
    private byte[] fContent;
    private long fStreamLimitOffset;
    private long fStreamLimitLength;

    public void setContent(InputStream in) throws IOException {
        this.fStreamLimitLength = -1L;
        this.fStreamLimitOffset = -1L;
        if (null == in) {
            this.fContent = null;
            this.fLength = 0;
        } else {
            byte[] buffer = new byte[65535];
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                contentStream.write(buffer, 0, len);
                this.fLength += len;
            }
            this.fContent = contentStream.toByteArray();
            this.fLength = contentStream.size();
            contentStream.close();
            in.close();
        }
    }

    public long getLength() {
        return this.fLength;
    }

    public BigInteger getBigLength() {
        return BigInteger.valueOf(this.fLength);
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setMimeType(String fMimeType) {
        this.fMimeType = fMimeType;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public String getFilename() {
        return this.fFileName;
    }

    public InputStream getStream() {
        if (null == this.fContent) {
            return null;
        }
        if (this.fStreamLimitOffset <= 0L && this.fStreamLimitLength < 0L) {
            return new ByteArrayInputStream(this.fContent);
        }
        return new ByteArrayInputStream(this.fContent, (int)(this.fStreamLimitOffset < 0L ? 0L : this.fStreamLimitOffset), (int)(this.fStreamLimitLength < 0L ? (long)this.fLength : this.fStreamLimitLength));
    }

    public ContentStream getCloneWithLimits(long offset, long length) {
        ContentStreamDataImpl clone = new ContentStreamDataImpl();
        clone.fFileName = this.fFileName;
        clone.fLength = this.fLength;
        clone.fContent = this.fContent;
        clone.fMimeType = this.fMimeType;
        clone.fStreamLimitOffset = offset;
        clone.fStreamLimitLength = length;
        return clone;
    }

    public List<CmisExtensionElement> getExtensions() {
        return null;
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
    }
}

