/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.SingleFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FolderImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleFilingImpl
extends StoredObjectImpl
implements SingleFiling {
    protected FolderImpl fParent;

    protected AbstractSingleFilingImpl(ObjectStoreImpl objStore) {
        super(objStore);
    }

    @Override
    public String getPath() {
        StringBuffer path = new StringBuffer(this.getName());
        if (null == this.getParent()) {
            path.replace(0, path.length(), "/");
        } else {
            Folder f = this.getParent();
            while (f.getParent() != null) {
                path.insert(0, "/");
                path.insert(0, f.getName());
                f = f.getParent();
            }
            path.insert(0, "/");
        }
        return path.toString();
    }

    @Override
    public Folder getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasParent() {
        return null != this.fParent;
    }

    @Override
    public List<Folder> getParents() {
        if (null == this.fParent) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.fParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(Folder parent) {
        try {
            this.fObjStore.lock();
            this.fParent = (FolderImpl)parent;
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String newName) {
        if (!NameValidator.isValidId(newName)) {
            throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
        }
        try {
            this.fObjStore.lock();
            if (this.getParent() == null) {
                throw new CmisInvalidArgumentException("Root folder cannot be renamed.");
            }
            if (this.getParent().hasChild(newName)) {
                throw new CmisNameConstraintViolationException("Cannot rename object to " + newName + ". This path already exists.");
            }
            this.setName(newName);
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Folder oldParent, Folder newParent) {
        try {
            this.fObjStore.lock();
            if (this instanceof Document || this instanceof VersionedDocument) {
                this.fParent.moveChildDocument(this, oldParent, newParent);
            } else {
                if (this.getParent() == null) {
                    throw new IllegalArgumentException("Root folder cannot be moved.");
                }
                if (newParent == null) {
                    throw new IllegalArgumentException("null is not a valid move target.");
                }
                if (newParent.hasChild(this.getName())) {
                    throw new IllegalArgumentException("Cannot move folder, this name already exists in target.");
                }
                this.setParent(newParent);
            }
        }
        finally {
            this.fObjStore.unlock();
        }
    }
}

