/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ObjectStoreImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiFilingImpl
extends StoredObjectImpl
implements MultiFiling {
    protected List<Folder> fParents = new ArrayList<Folder>(1);

    AbstractMultiFilingImpl(ObjectStoreImpl objStore) {
        super(objStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParent(Folder parent) {
        try {
            this.fObjStore.lock();
            this.addParentIntern(parent);
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    private void addParentIntern(Folder parent) {
        if (parent.hasChild(this.getName())) {
            throw new IllegalArgumentException("Cannot assign new parent folder, this name already exists in target folder.");
        }
        if (null == this.fParents) {
            this.fParents = new ArrayList<Folder>();
        }
        this.fParents.add(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParent(Folder parent) {
        try {
            this.fObjStore.lock();
            this.removeParentIntern(parent);
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    private void removeParentIntern(Folder parent) {
        this.fParents.remove(parent);
        if (this.fParents.isEmpty()) {
            this.fParents = null;
        }
    }

    @Override
    public List<Folder> getParents() {
        return this.fParents;
    }

    @Override
    public boolean hasParent() {
        return null != this.fParents && !this.fParents.isEmpty();
    }

    @Override
    public String getPathSegment() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Folder oldParent, Folder newParent) {
        try {
            this.fObjStore.lock();
            this.addParentIntern(newParent);
            this.removeParentIntern(oldParent);
        }
        finally {
            this.fObjStore.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String newName) {
        try {
            if (!NameValidator.isValidId(newName)) {
                throw new CmisInvalidArgumentException("Id contains illegal characters, allowed are 'a'..'z', 'A'..'Z', '0'..'9', '-', '_', '.', ' '");
            }
            this.fObjStore.lock();
            for (Folder folder : this.fParents) {
                if (folder == null) {
                    throw new CmisInvalidArgumentException("Root folder cannot be renamed.");
                }
                if (!folder.hasChild(newName)) continue;
                throw new CmisNameConstraintViolationException("Cannot rename object to " + newName + ". This path already exists in parent " + folder.getPath() + ".");
            }
            this.setName(newName);
        }
        finally {
            this.fObjStore.unlock();
        }
    }
}

