/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.server.AtomLinkInfoProvider;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryObjectServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryVersioningServiceImpl
extends InMemoryAbstractServiceImpl {
    private static final Log LOG = LogFactory.getLog((String)InMemoryVersioningServiceImpl.class.getName());
    InMemoryObjectServiceImpl fObjectService;
    AtomLinkInfoProvider fAtomLinkProvider;

    public InMemoryVersioningServiceImpl(StoreManager storeManager, InMemoryObjectServiceImpl objectService) {
        super(storeManager);
        this.fObjectService = objectService;
        this.fAtomLinkProvider = new AtomLinkInfoProvider(this.fStoreManager);
    }

    public void cancelCheckOut(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        StoredObject so = this.validator.cancelCheckOut(context, repositoryId, objectId, extension);
        String user = context.getUsername();
        VersionedDocument verDoc = this.testHasProperCheckedOutStatus(so, user);
        verDoc.cancelCheckOut(user);
    }

    public void checkIn(CallContext context, String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        StoredObject so = this.validator.checkIn(context, repositoryId, objectId, extension);
        String user = context.getUsername();
        VersionedDocument verDoc = this.testHasProperCheckedOutStatus(so, user);
        DocumentVersion pwc = verDoc.getPwc();
        if (null != contentStream) {
            pwc.setContent(contentStream, false);
        }
        if (null != properties && null != properties.getProperties()) {
            pwc.setCustomProperties(properties.getProperties());
        }
        verDoc.checkIn(major, checkinComment, user);
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public void checkOut(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied, ObjectInfoHandler objectInfos) {
        StoredObject so = this.validator.checkOut(context, repositoryId, objectId, extension, contentCopied);
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so);
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            throw new CmisNotSupportedException("Only documents can be checked-out.");
        }
        if (!((DocumentTypeDefinition)typeDef).isVersionable().booleanValue()) {
            throw new CmisNotSupportedException("Object can't be checked-out, type is not versionable.");
        }
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        ContentStream content = null;
        content = so instanceof DocumentVersion ? ((DocumentVersion)so).getContent(0L, -1L) : ((VersionedDocument)so).getLatestVersion(false).getContent(0L, -1L);
        if (verDoc.isCheckedOut()) {
            throw new CmisUpdateConflictException("Document " + (String)objectId.getValue() + " is already checked out.");
        }
        String user = context.getUsername();
        this.checkHasUser(user);
        DocumentVersion pwc = verDoc.checkOut(content, user);
        objectId.setValue((Object)pwc.getId());
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, pwc, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public List<ObjectData> getAllVersions(CallContext context, String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        if (null == versionSeriesId) {
            throw new CmisInvalidArgumentException("getAllVersions requires a version series id, but ist was null.");
        }
        StoredObject so = this.validator.getAllVersions(context, repositoryId, objectId, versionSeriesId, extension);
        if (!(so instanceof VersionedDocument)) {
            throw new CmisInvalidArgumentException("Object is not instance of a VersionedDocument (version series)");
        }
        VersionedDocument verDoc = (VersionedDocument)so;
        ArrayList<ObjectData> res = new ArrayList<ObjectData>();
        List<DocumentVersion> versions = verDoc.getAllVersions();
        for (DocumentVersion version : versions) {
            ObjectData objData = this.getObject(context, repositoryId, version.getId(), filter, includeAllowableActions, extension, objectInfos);
            res.add(objData);
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return res;
    }

    public ObjectData getObjectOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        StoredObject so = this.validator.getObjectOfLatestVersion(context, repositoryId, objectId, versionSeriesId, extension);
        ObjectData objData = null;
        if (so instanceof VersionedDocument) {
            VersionedDocument verDoc = (VersionedDocument)so;
            DocumentVersion latestVersion = verDoc.getLatestVersion(major);
            objData = this.getObject(context, repositoryId, latestVersion.getId(), filter, includeAllowableActions, extension, objectInfos);
        } else if (so instanceof Document) {
            objData = this.getObject(context, repositoryId, so.getId(), filter, includeAllowableActions, extension, objectInfos);
        } else {
            throw new CmisInvalidArgumentException("Object is not instance of a document (version series)");
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return objData;
    }

    public Properties getPropertiesOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        StoredObject so = this.validator.getPropertiesOfLatestVersion(context, repositoryId, objectId, versionSeriesId, extension);
        StoredObject latestVersionObject = null;
        if (so instanceof VersionedDocument) {
            VersionedDocument verDoc = (VersionedDocument)so;
            latestVersionObject = verDoc.getLatestVersion(major);
        } else if (so instanceof Document) {
            latestVersionObject = so;
        } else {
            throw new CmisInvalidArgumentException("Object is not instance of a document (version series)");
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        TypeDefinition td = this.fStoreManager.getTypeById(repositoryId, so.getTypeId()).getTypeDefinition();
        Properties props = PropertyCreationHelper.getPropertiesFromObject(latestVersionObject, td, requestedIds, true);
        return props;
    }

    private ObjectData getObject(CallContext context, String repositoryId, String objectId, String filter, Boolean includeAllowableActions, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        return this.fObjectService.getObject(context, repositoryId, objectId, filter, includeAllowableActions, IncludeRelationships.NONE, null, false, includeAllowableActions, extension, objectInfos);
    }
}

