/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryService;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoreManagerFactory;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoreManagerImpl;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.apache.chemistry.opencmis.util.repository.ObjectGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryServiceFactoryImpl
extends AbstractServiceFactory {
    private static final Log LOG = LogFactory.getLog((String)InMemoryServiceFactoryImpl.class.getName());
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(1000L);
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(100L);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(2L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    private static CallContext OVERRIDE_CTX;
    private Map<String, String> inMemoryServiceParameters;
    private ThreadLocal<CmisServiceWrapper<InMemoryService>> threadLocalService = new ThreadLocal();
    private boolean fUseOverrideCtx = false;
    private StoreManager storeManager;

    public void init(Map<String, String> parameters) {
        String repositoryClassName;
        LOG.info((Object)"Initializing in-memory repository...");
        this.inMemoryServiceParameters = parameters;
        String overrideCtx = parameters.get("InMemoryServer.OverrideCallContext");
        if (null != overrideCtx) {
            this.fUseOverrideCtx = true;
        }
        if (null == (repositoryClassName = parameters.get("InMemoryServer.Class"))) {
            repositoryClassName = StoreManagerImpl.class.getName();
        }
        if (null == this.storeManager) {
            this.storeManager = StoreManagerFactory.createInstance(repositoryClassName);
        }
        this.initStorageManager(parameters);
        this.fillRepositoryIfConfigured(parameters);
        LOG.info((Object)"...initialized in-memory repository.");
    }

    public static void setOverrideCallContext(CallContext ctx) {
        OVERRIDE_CTX = ctx;
    }

    public CmisService getService(CallContext context) {
        CmisServiceWrapper wrapperService;
        LOG.debug((Object)"start getService()");
        if (this.fUseOverrideCtx && null != OVERRIDE_CTX) {
            context = OVERRIDE_CTX;
        }
        if ((wrapperService = this.threadLocalService.get()) == null) {
            wrapperService = new CmisServiceWrapper((CmisService)new InMemoryService(this.inMemoryServiceParameters, this.storeManager), DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
            this.threadLocalService.set((CmisServiceWrapper<InMemoryService>)wrapperService);
        }
        ((InMemoryService)wrapperService.getWrappedService()).setCallContext(context);
        LOG.debug((Object)"stop getService()");
        return wrapperService.getWrappedService();
    }

    public void destroy() {
        this.threadLocalService = null;
    }

    private void initStorageManager(Map<String, String> parameters) {
        String repositoryClassName = parameters.get("InMemoryServer.Class");
        if (null == repositoryClassName) {
            repositoryClassName = StoreManagerImpl.class.getName();
        }
        if (null == this.storeManager) {
            this.storeManager = StoreManagerFactory.createInstance(repositoryClassName);
        }
        String repositoryId = parameters.get("InMemoryServer.RepositoryId");
        List<String> allAvailableRepositories = this.storeManager.getAllRepositoryIds();
        for (String existingRepId : allAvailableRepositories) {
            this.storeManager.initRepository(existingRepId);
        }
        if (null != repositoryId) {
            if (allAvailableRepositories.contains(repositoryId)) {
                LOG.warn((Object)("Repostory " + repositoryId + " already exists and will not be created."));
            } else {
                String typeCreatorClassName = parameters.get("InMemoryServer.TypesCreatorClass");
                this.storeManager.createAndInitRepository(repositoryId, typeCreatorClassName);
            }
        }
    }

    private List<String> readPropertiesToSetFromConfig(Map<String, String> parameters, String keyPrefix) {
        String propertyKey;
        String propertyToAdd;
        ArrayList<String> propsToSet = new ArrayList<String>();
        int i = 0;
        while (null != (propertyToAdd = parameters.get(propertyKey = keyPrefix + Integer.toString(i)))) {
            propsToSet.add(propertyToAdd);
            ++i;
        }
        return propsToSet;
    }

    private void fillRepositoryIfConfigured(Map<String, String> parameters) {
        boolean doFillRepository;
        String repositoryId = parameters.get("InMemoryServer.RepositoryId");
        String doFillRepositoryStr = parameters.get("RepositoryFiller.Enable");
        boolean bl = doFillRepository = doFillRepositoryStr == null ? false : Boolean.parseBoolean(doFillRepositoryStr);
        if (doFillRepository) {
            String folderTypeId;
            String documentTypeId;
            InMemoryService svc = new InMemoryService(this.inMemoryServiceParameters, this.storeManager);
            BindingsObjectFactoryImpl objectFactory = new BindingsObjectFactoryImpl();
            String levelsStr = parameters.get("RepositoryFiller.Depth");
            int levels = 1;
            if (null != levelsStr) {
                levels = Integer.parseInt(levelsStr);
            }
            String docsPerLevelStr = parameters.get("RepositoryFiller.DocsPerFolder");
            int docsPerLevel = 1;
            if (null != docsPerLevelStr) {
                docsPerLevel = Integer.parseInt(docsPerLevelStr);
            }
            String childrenPerLevelStr = parameters.get("RepositoryFiller.FolderPerFolder");
            int childrenPerLevel = 2;
            if (null != childrenPerLevelStr) {
                childrenPerLevel = Integer.parseInt(childrenPerLevelStr);
            }
            if (null == (documentTypeId = parameters.get("RepositoryFiller.DocumentTypeId"))) {
                documentTypeId = BaseTypeId.CMIS_DOCUMENT.value();
            }
            if (null == (folderTypeId = parameters.get("RepositoryFiller.FolderTypeId"))) {
                folderTypeId = BaseTypeId.CMIS_FOLDER.value();
            }
            int contentSizeKB = 0;
            String contentSizeKBStr = parameters.get("RepositoryFiller.ContentSizeInKB");
            if (null != contentSizeKBStr) {
                contentSizeKB = Integer.parseInt(contentSizeKBStr);
            }
            ObjectGenerator gen = new ObjectGenerator((BindingsObjectFactory)objectFactory, (NavigationService)svc, (ObjectService)svc, repositoryId);
            gen.setNumberOfDocumentsToCreatePerFolder(docsPerLevel);
            gen.setDocumentTypeId(documentTypeId);
            gen.setFolderTypeId(folderTypeId);
            gen.setContentSizeInKB(contentSizeKB);
            List<String> propsToSet = this.readPropertiesToSetFromConfig(parameters, "RepositoryFiller.DocumentProperty.");
            if (null != propsToSet) {
                gen.setDocumentPropertiesToGenerate(propsToSet);
            }
            if (null != (propsToSet = this.readPropertiesToSetFromConfig(parameters, "RepositoryFiller.FolderProperty."))) {
                gen.setFolderPropertiesToGenerate(propsToSet);
            }
            class DummyCallContext
            implements CallContext {
                DummyCallContext() {
                }

                public String get(String key) {
                    return null;
                }

                public String getBinding() {
                    return null;
                }

                public boolean isObjectInfoRequired() {
                    return false;
                }

                public String getRepositoryId() {
                    return null;
                }

                public String getLocale() {
                    return null;
                }

                public BigInteger getOffset() {
                    return null;
                }

                public BigInteger getLength() {
                    return null;
                }

                public String getPassword() {
                    return null;
                }

                public String getUsername() {
                    return null;
                }
            }
            DummyCallContext ctx = new DummyCallContext();
            svc.setCallContext(ctx);
            RepositoryInfo rep = svc.getRepositoryInfo(repositoryId, null);
            String rootFolderId = rep.getRootFolderId();
            try {
                gen.createFolderHierachy(levels, childrenPerLevel, rootFolderId);
                gen.dumpFolder(rootFolderId, "*");
            }
            catch (Exception e) {
                LOG.error((Object)("Could not create folder hierarchy with documents. " + e));
                e.printStackTrace();
            }
        }
    }
}

